@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.SecurityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a NLB Security Policy resource.
 * For information about NLB Security Policy and how to use it, see [What is Security Policy](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createsecuritypolicy-nlb).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultSecurityPolicy = new alicloud.nlb.SecurityPolicy("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     securityPolicyName: name,
 *     ciphers: [
 *         "ECDHE-RSA-AES128-SHA",
 *         "ECDHE-ECDSA-AES128-SHA",
 *     ],
 *     tlsVersions: [
 *         "TLSv1.0",
 *         "TLSv1.1",
 *         "TLSv1.2",
 *     ],
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_security_policy = alicloud.nlb.SecurityPolicy("default",
 *     resource_group_id=default.ids[0],
 *     security_policy_name=name,
 *     ciphers=[
 *         "ECDHE-RSA-AES128-SHA",
 *         "ECDHE-ECDSA-AES128-SHA",
 *     ],
 *     tls_versions=[
 *         "TLSv1.0",
 *         "TLSv1.1",
 *         "TLSv1.2",
 *     ],
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultSecurityPolicy = new AliCloud.Nlb.SecurityPolicy("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         SecurityPolicyName = name,
 *         Ciphers = new[]
 *         {
 *             "ECDHE-RSA-AES128-SHA",
 *             "ECDHE-ECDSA-AES128-SHA",
 *         },
 *         TlsVersions = new[]
 *         {
 *             "TLSv1.0",
 *             "TLSv1.1",
 *             "TLSv1.2",
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewSecurityPolicy(ctx, "default", &nlb.SecurityPolicyArgs{
 * 			ResourceGroupId:    pulumi.String(_default.Ids[0]),
 * 			SecurityPolicyName: pulumi.String(name),
 * 			Ciphers: pulumi.StringArray{
 * 				pulumi.String("ECDHE-RSA-AES128-SHA"),
 * 				pulumi.String("ECDHE-ECDSA-AES128-SHA"),
 * 			},
 * 			TlsVersions: pulumi.StringArray{
 * 				pulumi.String("TLSv1.0"),
 * 				pulumi.String("TLSv1.1"),
 * 				pulumi.String("TLSv1.2"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.nlb.SecurityPolicy;
 * import com.pulumi.alicloud.nlb.SecurityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultSecurityPolicy = new SecurityPolicy("defaultSecurityPolicy", SecurityPolicyArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .securityPolicyName(name)
 *             .ciphers(
 *                 "ECDHE-RSA-AES128-SHA",
 *                 "ECDHE-ECDSA-AES128-SHA")
 *             .tlsVersions(
 *                 "TLSv1.0",
 *                 "TLSv1.1",
 *                 "TLSv1.2")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultSecurityPolicy:
 *     type: alicloud:nlb:SecurityPolicy
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       securityPolicyName: ${name}
 *       ciphers:
 *         - ECDHE-RSA-AES128-SHA
 *         - ECDHE-ECDSA-AES128-SHA
 *       tlsVersions:
 *         - TLSv1.0
 *         - TLSv1.1
 *         - TLSv1.2
 *       tags:
 *         Created: TF
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Security Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/securityPolicy:SecurityPolicy example <id>
 * ```
 * @property ciphers The supported cipher suites, which are determined by the TLS protocol version. You can specify at most 32 cipher suites.
 * - TLS 1.0 and TLS 1.1 support the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA`, `DES-CBC3-SHA`
 * - TLS 1.2 supports the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA, DES-CBC3-SHA`, `ECDHE-ECDSA-AES128-GCM-SHA256`, `ECDHE-ECDSA-AES256-GCM-SHA384`, `ECDHE-ECDSA-AES128-SHA256`, `ECDHE-ECDSA-AES256-SHA384`, `ECDHE-RSA-AES128-GCM-SHA256`, `ECDHE-RSA-AES256-GCM-SHA384`, `ECDHE-RSA-AES128-SHA256`, `ECDHE-RSA-AES256-SHA384`, `AES128-GCM-SHA256`, `AES256-GCM-SHA384`, `AES128-SHA256`, `AES256-SHA256`
 * - TLS 1.3 supports the following cipher suites: `TLS_AES_128_GCM_SHA256`, `TLS_AES_256_GCM_SHA384`, `TLS_CHACHA20_POLY1305_SHA256`, `TLS_AES_128_CCM_SHA256`, `TLS_AES_128_CCM_8_SHA256`.
 * @property resourceGroupId The ID of the resource group.
 * @property securityPolicyName The name of the security policy. The name must be 1 to 200 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
 * @property tags The tag of the resource.
 * @property tlsVersions The supported versions of the Transport Layer Security (TLS) protocol. Valid values: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`, and `TLSv1.3`. You can specify at most four TLS versions.
 */
public data class SecurityPolicyArgs(
    public val ciphers: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityPolicyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tlsVersions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.SecurityPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.SecurityPolicyArgs =
        com.pulumi.alicloud.nlb.SecurityPolicyArgs.builder()
            .ciphers(ciphers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityPolicyName(securityPolicyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tlsVersions(tlsVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SecurityPolicyArgs].
 */
@PulumiTagMarker
public class SecurityPolicyArgsBuilder internal constructor() {
    private var ciphers: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityPolicyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tlsVersions: Output<List<String>>? = null

    /**
     * @param value The supported cipher suites, which are determined by the TLS protocol version. You can specify at most 32 cipher suites.
     * - TLS 1.0 and TLS 1.1 support the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA`, `DES-CBC3-SHA`
     * - TLS 1.2 supports the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA, DES-CBC3-SHA`, `ECDHE-ECDSA-AES128-GCM-SHA256`, `ECDHE-ECDSA-AES256-GCM-SHA384`, `ECDHE-ECDSA-AES128-SHA256`, `ECDHE-ECDSA-AES256-SHA384`, `ECDHE-RSA-AES128-GCM-SHA256`, `ECDHE-RSA-AES256-GCM-SHA384`, `ECDHE-RSA-AES128-SHA256`, `ECDHE-RSA-AES256-SHA384`, `AES128-GCM-SHA256`, `AES256-GCM-SHA384`, `AES128-SHA256`, `AES256-SHA256`
     * - TLS 1.3 supports the following cipher suites: `TLS_AES_128_GCM_SHA256`, `TLS_AES_256_GCM_SHA384`, `TLS_CHACHA20_POLY1305_SHA256`, `TLS_AES_128_CCM_SHA256`, `TLS_AES_128_CCM_8_SHA256`.
     */
    @JvmName("dfofsjjdaunfumlx")
    public suspend fun ciphers(`value`: Output<List<String>>) {
        this.ciphers = value
    }

    @JvmName("nreyjalbjcbdeopy")
    public suspend fun ciphers(vararg values: Output<String>) {
        this.ciphers = Output.all(values.asList())
    }

    /**
     * @param values The supported cipher suites, which are determined by the TLS protocol version. You can specify at most 32 cipher suites.
     * - TLS 1.0 and TLS 1.1 support the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA`, `DES-CBC3-SHA`
     * - TLS 1.2 supports the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA, DES-CBC3-SHA`, `ECDHE-ECDSA-AES128-GCM-SHA256`, `ECDHE-ECDSA-AES256-GCM-SHA384`, `ECDHE-ECDSA-AES128-SHA256`, `ECDHE-ECDSA-AES256-SHA384`, `ECDHE-RSA-AES128-GCM-SHA256`, `ECDHE-RSA-AES256-GCM-SHA384`, `ECDHE-RSA-AES128-SHA256`, `ECDHE-RSA-AES256-SHA384`, `AES128-GCM-SHA256`, `AES256-GCM-SHA384`, `AES128-SHA256`, `AES256-SHA256`
     * - TLS 1.3 supports the following cipher suites: `TLS_AES_128_GCM_SHA256`, `TLS_AES_256_GCM_SHA384`, `TLS_CHACHA20_POLY1305_SHA256`, `TLS_AES_128_CCM_SHA256`, `TLS_AES_128_CCM_8_SHA256`.
     */
    @JvmName("ewhmqctwqmemsvdj")
    public suspend fun ciphers(values: List<Output<String>>) {
        this.ciphers = Output.all(values)
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("hwghnlefylbbcqom")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The name of the security policy. The name must be 1 to 200 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("uwloagxofjsgbmqx")
    public suspend fun securityPolicyName(`value`: Output<String>) {
        this.securityPolicyName = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("rdyvtdgpnkxakkvm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The supported versions of the Transport Layer Security (TLS) protocol. Valid values: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`, and `TLSv1.3`. You can specify at most four TLS versions.
     */
    @JvmName("onqmiunnxrtmdtuf")
    public suspend fun tlsVersions(`value`: Output<List<String>>) {
        this.tlsVersions = value
    }

    @JvmName("kqltqabbscphpwfk")
    public suspend fun tlsVersions(vararg values: Output<String>) {
        this.tlsVersions = Output.all(values.asList())
    }

    /**
     * @param values The supported versions of the Transport Layer Security (TLS) protocol. Valid values: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`, and `TLSv1.3`. You can specify at most four TLS versions.
     */
    @JvmName("fnurcbsfgaiyhegx")
    public suspend fun tlsVersions(values: List<Output<String>>) {
        this.tlsVersions = Output.all(values)
    }

    /**
     * @param value The supported cipher suites, which are determined by the TLS protocol version. You can specify at most 32 cipher suites.
     * - TLS 1.0 and TLS 1.1 support the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA`, `DES-CBC3-SHA`
     * - TLS 1.2 supports the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA, DES-CBC3-SHA`, `ECDHE-ECDSA-AES128-GCM-SHA256`, `ECDHE-ECDSA-AES256-GCM-SHA384`, `ECDHE-ECDSA-AES128-SHA256`, `ECDHE-ECDSA-AES256-SHA384`, `ECDHE-RSA-AES128-GCM-SHA256`, `ECDHE-RSA-AES256-GCM-SHA384`, `ECDHE-RSA-AES128-SHA256`, `ECDHE-RSA-AES256-SHA384`, `AES128-GCM-SHA256`, `AES256-GCM-SHA384`, `AES128-SHA256`, `AES256-SHA256`
     * - TLS 1.3 supports the following cipher suites: `TLS_AES_128_GCM_SHA256`, `TLS_AES_256_GCM_SHA384`, `TLS_CHACHA20_POLY1305_SHA256`, `TLS_AES_128_CCM_SHA256`, `TLS_AES_128_CCM_8_SHA256`.
     */
    @JvmName("jbbiddtnecdojphb")
    public suspend fun ciphers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciphers = mapped
    }

    /**
     * @param values The supported cipher suites, which are determined by the TLS protocol version. You can specify at most 32 cipher suites.
     * - TLS 1.0 and TLS 1.1 support the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA`, `DES-CBC3-SHA`
     * - TLS 1.2 supports the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA, DES-CBC3-SHA`, `ECDHE-ECDSA-AES128-GCM-SHA256`, `ECDHE-ECDSA-AES256-GCM-SHA384`, `ECDHE-ECDSA-AES128-SHA256`, `ECDHE-ECDSA-AES256-SHA384`, `ECDHE-RSA-AES128-GCM-SHA256`, `ECDHE-RSA-AES256-GCM-SHA384`, `ECDHE-RSA-AES128-SHA256`, `ECDHE-RSA-AES256-SHA384`, `AES128-GCM-SHA256`, `AES256-GCM-SHA384`, `AES128-SHA256`, `AES256-SHA256`
     * - TLS 1.3 supports the following cipher suites: `TLS_AES_128_GCM_SHA256`, `TLS_AES_256_GCM_SHA384`, `TLS_CHACHA20_POLY1305_SHA256`, `TLS_AES_128_CCM_SHA256`, `TLS_AES_128_CCM_8_SHA256`.
     */
    @JvmName("ysfinhddllxnrwgt")
    public suspend fun ciphers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ciphers = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("viymdxuojjoqipqp")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of the security policy. The name must be 1 to 200 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("cbwhuscqpjsteurh")
    public suspend fun securityPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyName = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("weftjfwjywgylrgv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("xhhhhnexqrjxfyjb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The supported versions of the Transport Layer Security (TLS) protocol. Valid values: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`, and `TLSv1.3`. You can specify at most four TLS versions.
     */
    @JvmName("dwwgjhpegbyrvtbx")
    public suspend fun tlsVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    /**
     * @param values The supported versions of the Transport Layer Security (TLS) protocol. Valid values: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`, and `TLSv1.3`. You can specify at most four TLS versions.
     */
    @JvmName("rgshgqjywyeiexoi")
    public suspend fun tlsVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    internal fun build(): SecurityPolicyArgs = SecurityPolicyArgs(
        ciphers = ciphers,
        resourceGroupId = resourceGroupId,
        securityPolicyName = securityPolicyName,
        tags = tags,
        tlsVersions = tlsVersions,
    )
}
