@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.kotlin.outputs.ServerGroupHealthCheck
import com.pulumi.alicloud.nlb.kotlin.outputs.ServerGroupHealthCheck.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServerGroup].
 */
@PulumiTagMarker
public class ServerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerGroupArgs = ServerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerGroupArgsBuilder.() -> Unit) {
        val builder = ServerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerGroup {
        val builtJavaResource = com.pulumi.alicloud.nlb.ServerGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerGroup(builtJavaResource)
    }
}

/**
 * Provides a NLB Server Group resource.
 * For information about NLB Server Group and how to use it, see [What is Server Group](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createservergroup-nlb).
 * > **NOTE:** Available since v1.186.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultServerGroup = new alicloud.nlb.ServerGroup("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     serverGroupName: name,
 *     serverGroupType: "Instance",
 *     vpcId: defaultNetwork.id,
 *     scheduler: "Wrr",
 *     protocol: "TCP",
 *     connectionDrain: true,
 *     connectionDrainTimeout: 60,
 *     addressIpVersion: "Ipv4",
 *     healthCheck: {
 *         healthCheckEnabled: true,
 *         healthCheckType: "TCP",
 *         healthCheckConnectPort: 0,
 *         healthyThreshold: 2,
 *         unhealthyThreshold: 2,
 *         healthCheckConnectTimeout: 5,
 *         healthCheckInterval: 10,
 *         httpCheckMethod: "GET",
 *         healthCheckHttpCodes: [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *     },
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_server_group = alicloud.nlb.ServerGroup("default",
 *     resource_group_id=default.ids[0],
 *     server_group_name=name,
 *     server_group_type="Instance",
 *     vpc_id=default_network.id,
 *     scheduler="Wrr",
 *     protocol="TCP",
 *     connection_drain=True,
 *     connection_drain_timeout=60,
 *     address_ip_version="Ipv4",
 *     health_check={
 *         "health_check_enabled": True,
 *         "health_check_type": "TCP",
 *         "health_check_connect_port": 0,
 *         "healthy_threshold": 2,
 *         "unhealthy_threshold": 2,
 *         "health_check_connect_timeout": 5,
 *         "health_check_interval": 10,
 *         "http_check_method": "GET",
 *         "health_check_http_codes": [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *     },
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultServerGroup = new AliCloud.Nlb.ServerGroup("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         ServerGroupName = name,
 *         ServerGroupType = "Instance",
 *         VpcId = defaultNetwork.Id,
 *         Scheduler = "Wrr",
 *         Protocol = "TCP",
 *         ConnectionDrain = true,
 *         ConnectionDrainTimeout = 60,
 *         AddressIpVersion = "Ipv4",
 *         HealthCheck = new AliCloud.Nlb.Inputs.ServerGroupHealthCheckArgs
 *         {
 *             HealthCheckEnabled = true,
 *             HealthCheckType = "TCP",
 *             HealthCheckConnectPort = 0,
 *             HealthyThreshold = 2,
 *             UnhealthyThreshold = 2,
 *             HealthCheckConnectTimeout = 5,
 *             HealthCheckInterval = 10,
 *             HttpCheckMethod = "GET",
 *             HealthCheckHttpCodes = new[]
 *             {
 *                 "http_2xx",
 *                 "http_3xx",
 *                 "http_4xx",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewServerGroup(ctx, "default", &nlb.ServerGroupArgs{
 * 			ResourceGroupId:        pulumi.String(_default.Ids[0]),
 * 			ServerGroupName:        pulumi.String(name),
 * 			ServerGroupType:        pulumi.String("Instance"),
 * 			VpcId:                  defaultNetwork.ID(),
 * 			Scheduler:              pulumi.String("Wrr"),
 * 			Protocol:               pulumi.String("TCP"),
 * 			ConnectionDrain:        pulumi.Bool(true),
 * 			ConnectionDrainTimeout: pulumi.Int(60),
 * 			AddressIpVersion:       pulumi.String("Ipv4"),
 * 			HealthCheck: &nlb.ServerGroupHealthCheckArgs{
 * 				HealthCheckEnabled:        pulumi.Bool(true),
 * 				HealthCheckType:           pulumi.String("TCP"),
 * 				HealthCheckConnectPort:    pulumi.Int(0),
 * 				HealthyThreshold:          pulumi.Int(2),
 * 				UnhealthyThreshold:        pulumi.Int(2),
 * 				HealthCheckConnectTimeout: pulumi.Int(5),
 * 				HealthCheckInterval:       pulumi.Int(10),
 * 				HttpCheckMethod:           pulumi.String("GET"),
 * 				HealthCheckHttpCodes: pulumi.StringArray{
 * 					pulumi.String("http_2xx"),
 * 					pulumi.String("http_3xx"),
 * 					pulumi.String("http_4xx"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.nlb.ServerGroup;
 * import com.pulumi.alicloud.nlb.ServerGroupArgs;
 * import com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .serverGroupName(name)
 *             .serverGroupType("Instance")
 *             .vpcId(defaultNetwork.id())
 *             .scheduler("Wrr")
 *             .protocol("TCP")
 *             .connectionDrain(true)
 *             .connectionDrainTimeout(60)
 *             .addressIpVersion("Ipv4")
 *             .healthCheck(ServerGroupHealthCheckArgs.builder()
 *                 .healthCheckEnabled(true)
 *                 .healthCheckType("TCP")
 *                 .healthCheckConnectPort(0)
 *                 .healthyThreshold(2)
 *                 .unhealthyThreshold(2)
 *                 .healthCheckConnectTimeout(5)
 *                 .healthCheckInterval(10)
 *                 .httpCheckMethod("GET")
 *                 .healthCheckHttpCodes(
 *                     "http_2xx",
 *                     "http_3xx",
 *                     "http_4xx")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultServerGroup:
 *     type: alicloud:nlb:ServerGroup
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       serverGroupName: ${name}
 *       serverGroupType: Instance
 *       vpcId: ${defaultNetwork.id}
 *       scheduler: Wrr
 *       protocol: TCP
 *       connectionDrain: true
 *       connectionDrainTimeout: 60
 *       addressIpVersion: Ipv4
 *       healthCheck:
 *         healthCheckEnabled: true
 *         healthCheckType: TCP
 *         healthCheckConnectPort: 0
 *         healthyThreshold: 2
 *         unhealthyThreshold: 2
 *         healthCheckConnectTimeout: 5
 *         healthCheckInterval: 10
 *         httpCheckMethod: GET
 *         healthCheckHttpCodes:
 *           - http_2xx
 *           - http_3xx
 *           - http_4xx
 *       tags:
 *         Created: TF
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Server Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/serverGroup:ServerGroup example <id>
 * ```
 */
public class ServerGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.nlb.ServerGroup,
) : KotlinCustomResource(javaResource, ServerGroupMapper) {
    /**
     * The protocol version. Valid values: `Ipv4` (default), `DualStack`.
     */
    public val addressIpVersion: Output<String>
        get() = javaResource.addressIpVersion().applyValue({ args0 -> args0 })

    /**
     * Full port forwarding.
     */
    public val anyPortEnabled: Output<Boolean>
        get() = javaResource.anyPortEnabled().applyValue({ args0 -> args0 })

    /**
     * . Field 'connection_drain' has been deprecated from provider version 1.214.0. New field 'connection_drain_enabled' instead.
     */
    @Deprecated(
        message = """
  Field 'connection_drain' has been deprecated since provider version 1.214.0. New field
      'connection_drain_enabled' instead.
  """,
    )
    public val connectionDrain: Output<Boolean>
        get() = javaResource.connectionDrain().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable connection draining.
     */
    public val connectionDrainEnabled: Output<Boolean>
        get() = javaResource.connectionDrainEnabled().applyValue({ args0 -> args0 })

    /**
     * Set the connection elegant interrupt timeout. Unit: seconds. Valid values: **10** ~ **900**.
     */
    public val connectionDrainTimeout: Output<Int>
        get() = javaResource.connectionDrainTimeout().applyValue({ args0 -> args0 })

    /**
     * Health check configuration information. See `health_check` below.
     */
    public val healthCheck: Output<ServerGroupHealthCheck>
        get() = javaResource.healthCheck().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Indicates whether client address retention is enabled. Special instructions: When **AddressIPVersion** is of the **ipv4** type, the default value is **true**. **Addrestipversion** can only be **false** when the value of **ipv6** is **ipv6**, and can be **true** when supported by the underlying layer.
     */
    public val preserveClientIpEnabled: Output<Boolean>
        get() = javaResource.preserveClientIpEnabled().applyValue({ args0 -> args0 })

    /**
     * The backend protocol. Valid values: `TCP` (default), `UDP`, and `TCPSSL`.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group to which the security group belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The routing algorithm. Valid values:
     * - `Wrr` (default): The Weighted Round Robin algorithm is used. Backend servers with higher weights receive more requests than backend servers with lower weights.
     * - `Rr`: The round-robin algorithm is used. Requests are forwarded to backend servers in sequence.
     * - `Sch`: Source IP hashing is used. Requests from the same source IP address are forwarded to the same backend server.
     * - `Tch`: Four-element hashing is used. It specifies consistent hashing that is based on four factors: source IP address, destination IP address, source port, and destination port. Requests that contain the same information based on the four factors are forwarded to the same backend server.
     * - `Qch`: QUIC ID hashing is used. Requests that contain the same QUIC ID are forwarded to the same backend server.
     */
    public val scheduler: Output<String>
        get() = javaResource.scheduler().applyValue({ args0 -> args0 })

    /**
     * The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    public val serverGroupName: Output<String>
        get() = javaResource.serverGroupName().applyValue({ args0 -> args0 })

    /**
     * The type of the server group. Valid values:
     * - `Instance` (default): allows you to specify `Ecs`, `Ens`, or `Eci`.
     * - `Ip`: allows you to specify IP addresses.
     */
    public val serverGroupType: Output<String>
        get() = javaResource.serverGroupType().applyValue({ args0 -> args0 })

    /**
     * Server group status. Value:
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Label.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the VPC to which the server group belongs.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ServerGroupMapper : ResourceMapper<ServerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nlb.ServerGroup::class == javaResource::class

    override fun map(javaResource: Resource): ServerGroup = ServerGroup(
        javaResource as
            com.pulumi.alicloud.nlb.ServerGroup,
    )
}

/**
 * @see [ServerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerGroup].
 */
public suspend fun serverGroup(name: String, block: suspend ServerGroupResourceBuilder.() -> Unit): ServerGroup {
    val builder = ServerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverGroup(name: String): ServerGroup {
    val builder = ServerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
