@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.ServerGroupArgs.builder
import com.pulumi.alicloud.nlb.kotlin.inputs.ServerGroupHealthCheckArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.ServerGroupHealthCheckArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a NLB Server Group resource.
 * For information about NLB Server Group and how to use it, see [What is Server Group](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createservergroup-nlb).
 * > **NOTE:** Available since v1.186.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultServerGroup = new alicloud.nlb.ServerGroup("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     serverGroupName: name,
 *     serverGroupType: "Instance",
 *     vpcId: defaultNetwork.id,
 *     scheduler: "Wrr",
 *     protocol: "TCP",
 *     connectionDrain: true,
 *     connectionDrainTimeout: 60,
 *     addressIpVersion: "Ipv4",
 *     healthCheck: {
 *         healthCheckEnabled: true,
 *         healthCheckType: "TCP",
 *         healthCheckConnectPort: 0,
 *         healthyThreshold: 2,
 *         unhealthyThreshold: 2,
 *         healthCheckConnectTimeout: 5,
 *         healthCheckInterval: 10,
 *         httpCheckMethod: "GET",
 *         healthCheckHttpCodes: [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *     },
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_server_group = alicloud.nlb.ServerGroup("default",
 *     resource_group_id=default.ids[0],
 *     server_group_name=name,
 *     server_group_type="Instance",
 *     vpc_id=default_network.id,
 *     scheduler="Wrr",
 *     protocol="TCP",
 *     connection_drain=True,
 *     connection_drain_timeout=60,
 *     address_ip_version="Ipv4",
 *     health_check={
 *         "health_check_enabled": True,
 *         "health_check_type": "TCP",
 *         "health_check_connect_port": 0,
 *         "healthy_threshold": 2,
 *         "unhealthy_threshold": 2,
 *         "health_check_connect_timeout": 5,
 *         "health_check_interval": 10,
 *         "http_check_method": "GET",
 *         "health_check_http_codes": [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *     },
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultServerGroup = new AliCloud.Nlb.ServerGroup("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         ServerGroupName = name,
 *         ServerGroupType = "Instance",
 *         VpcId = defaultNetwork.Id,
 *         Scheduler = "Wrr",
 *         Protocol = "TCP",
 *         ConnectionDrain = true,
 *         ConnectionDrainTimeout = 60,
 *         AddressIpVersion = "Ipv4",
 *         HealthCheck = new AliCloud.Nlb.Inputs.ServerGroupHealthCheckArgs
 *         {
 *             HealthCheckEnabled = true,
 *             HealthCheckType = "TCP",
 *             HealthCheckConnectPort = 0,
 *             HealthyThreshold = 2,
 *             UnhealthyThreshold = 2,
 *             HealthCheckConnectTimeout = 5,
 *             HealthCheckInterval = 10,
 *             HttpCheckMethod = "GET",
 *             HealthCheckHttpCodes = new[]
 *             {
 *                 "http_2xx",
 *                 "http_3xx",
 *                 "http_4xx",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewServerGroup(ctx, "default", &nlb.ServerGroupArgs{
 * 			ResourceGroupId:        pulumi.String(_default.Ids[0]),
 * 			ServerGroupName:        pulumi.String(name),
 * 			ServerGroupType:        pulumi.String("Instance"),
 * 			VpcId:                  defaultNetwork.ID(),
 * 			Scheduler:              pulumi.String("Wrr"),
 * 			Protocol:               pulumi.String("TCP"),
 * 			ConnectionDrain:        pulumi.Bool(true),
 * 			ConnectionDrainTimeout: pulumi.Int(60),
 * 			AddressIpVersion:       pulumi.String("Ipv4"),
 * 			HealthCheck: &nlb.ServerGroupHealthCheckArgs{
 * 				HealthCheckEnabled:        pulumi.Bool(true),
 * 				HealthCheckType:           pulumi.String("TCP"),
 * 				HealthCheckConnectPort:    pulumi.Int(0),
 * 				HealthyThreshold:          pulumi.Int(2),
 * 				UnhealthyThreshold:        pulumi.Int(2),
 * 				HealthCheckConnectTimeout: pulumi.Int(5),
 * 				HealthCheckInterval:       pulumi.Int(10),
 * 				HttpCheckMethod:           pulumi.String("GET"),
 * 				HealthCheckHttpCodes: pulumi.StringArray{
 * 					pulumi.String("http_2xx"),
 * 					pulumi.String("http_3xx"),
 * 					pulumi.String("http_4xx"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.nlb.ServerGroup;
 * import com.pulumi.alicloud.nlb.ServerGroupArgs;
 * import com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .serverGroupName(name)
 *             .serverGroupType("Instance")
 *             .vpcId(defaultNetwork.id())
 *             .scheduler("Wrr")
 *             .protocol("TCP")
 *             .connectionDrain(true)
 *             .connectionDrainTimeout(60)
 *             .addressIpVersion("Ipv4")
 *             .healthCheck(ServerGroupHealthCheckArgs.builder()
 *                 .healthCheckEnabled(true)
 *                 .healthCheckType("TCP")
 *                 .healthCheckConnectPort(0)
 *                 .healthyThreshold(2)
 *                 .unhealthyThreshold(2)
 *                 .healthCheckConnectTimeout(5)
 *                 .healthCheckInterval(10)
 *                 .httpCheckMethod("GET")
 *                 .healthCheckHttpCodes(
 *                     "http_2xx",
 *                     "http_3xx",
 *                     "http_4xx")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultServerGroup:
 *     type: alicloud:nlb:ServerGroup
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       serverGroupName: ${name}
 *       serverGroupType: Instance
 *       vpcId: ${defaultNetwork.id}
 *       scheduler: Wrr
 *       protocol: TCP
 *       connectionDrain: true
 *       connectionDrainTimeout: 60
 *       addressIpVersion: Ipv4
 *       healthCheck:
 *         healthCheckEnabled: true
 *         healthCheckType: TCP
 *         healthCheckConnectPort: 0
 *         healthyThreshold: 2
 *         unhealthyThreshold: 2
 *         healthCheckConnectTimeout: 5
 *         healthCheckInterval: 10
 *         httpCheckMethod: GET
 *         healthCheckHttpCodes:
 *           - http_2xx
 *           - http_3xx
 *           - http_4xx
 *       tags:
 *         Created: TF
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Server Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/serverGroup:ServerGroup example <id>
 * ```
 * @property addressIpVersion The protocol version. Valid values: `Ipv4` (default), `DualStack`.
 * @property anyPortEnabled Full port forwarding.
 * @property connectionDrain . Field 'connection_drain' has been deprecated from provider version 1.214.0. New field 'connection_drain_enabled' instead.
 * @property connectionDrainEnabled Specifies whether to enable connection draining.
 * @property connectionDrainTimeout Set the connection elegant interrupt timeout. Unit: seconds. Valid values: **10** ~ **900**.
 * @property healthCheck Health check configuration information. See `health_check` below.
 * @property preserveClientIpEnabled Indicates whether client address retention is enabled. Special instructions: When **AddressIPVersion** is of the **ipv4** type, the default value is **true**. **Addrestipversion** can only be **false** when the value of **ipv6** is **ipv6**, and can be **true** when supported by the underlying layer.
 * @property protocol The backend protocol. Valid values: `TCP` (default), `UDP`, and `TCPSSL`.
 * @property resourceGroupId The ID of the resource group to which the security group belongs.
 * @property scheduler The routing algorithm. Valid values:
 * - `Wrr` (default): The Weighted Round Robin algorithm is used. Backend servers with higher weights receive more requests than backend servers with lower weights.
 * - `Rr`: The round-robin algorithm is used. Requests are forwarded to backend servers in sequence.
 * - `Sch`: Source IP hashing is used. Requests from the same source IP address are forwarded to the same backend server.
 * - `Tch`: Four-element hashing is used. It specifies consistent hashing that is based on four factors: source IP address, destination IP address, source port, and destination port. Requests that contain the same information based on the four factors are forwarded to the same backend server.
 * - `Qch`: QUIC ID hashing is used. Requests that contain the same QUIC ID are forwarded to the same backend server.
 * @property serverGroupName The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
 * @property serverGroupType The type of the server group. Valid values:
 * - `Instance` (default): allows you to specify `Ecs`, `Ens`, or `Eci`.
 * - `Ip`: allows you to specify IP addresses.
 * @property tags Label.
 * @property vpcId The ID of the VPC to which the server group belongs.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class ServerGroupArgs(
    public val addressIpVersion: Output<String>? = null,
    public val anyPortEnabled: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'connection_drain' has been deprecated since provider version 1.214.0. New field
      'connection_drain_enabled' instead.
  """,
    )
    public val connectionDrain: Output<Boolean>? = null,
    public val connectionDrainEnabled: Output<Boolean>? = null,
    public val connectionDrainTimeout: Output<Int>? = null,
    public val healthCheck: Output<ServerGroupHealthCheckArgs>? = null,
    public val preserveClientIpEnabled: Output<Boolean>? = null,
    public val protocol: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scheduler: Output<String>? = null,
    public val serverGroupName: Output<String>? = null,
    public val serverGroupType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.ServerGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.ServerGroupArgs =
        com.pulumi.alicloud.nlb.ServerGroupArgs.builder()
            .addressIpVersion(addressIpVersion?.applyValue({ args0 -> args0 }))
            .anyPortEnabled(anyPortEnabled?.applyValue({ args0 -> args0 }))
            .connectionDrain(connectionDrain?.applyValue({ args0 -> args0 }))
            .connectionDrainEnabled(connectionDrainEnabled?.applyValue({ args0 -> args0 }))
            .connectionDrainTimeout(connectionDrainTimeout?.applyValue({ args0 -> args0 }))
            .healthCheck(healthCheck?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preserveClientIpEnabled(preserveClientIpEnabled?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scheduler(scheduler?.applyValue({ args0 -> args0 }))
            .serverGroupName(serverGroupName?.applyValue({ args0 -> args0 }))
            .serverGroupType(serverGroupType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerGroupArgs].
 */
@PulumiTagMarker
public class ServerGroupArgsBuilder internal constructor() {
    private var addressIpVersion: Output<String>? = null

    private var anyPortEnabled: Output<Boolean>? = null

    private var connectionDrain: Output<Boolean>? = null

    private var connectionDrainEnabled: Output<Boolean>? = null

    private var connectionDrainTimeout: Output<Int>? = null

    private var healthCheck: Output<ServerGroupHealthCheckArgs>? = null

    private var preserveClientIpEnabled: Output<Boolean>? = null

    private var protocol: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scheduler: Output<String>? = null

    private var serverGroupName: Output<String>? = null

    private var serverGroupType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The protocol version. Valid values: `Ipv4` (default), `DualStack`.
     */
    @JvmName("bkclorvhmncgpnqq")
    public suspend fun addressIpVersion(`value`: Output<String>) {
        this.addressIpVersion = value
    }

    /**
     * @param value Full port forwarding.
     */
    @JvmName("huovrniixsbuspxh")
    public suspend fun anyPortEnabled(`value`: Output<Boolean>) {
        this.anyPortEnabled = value
    }

    /**
     * @param value . Field 'connection_drain' has been deprecated from provider version 1.214.0. New field 'connection_drain_enabled' instead.
     */
    @Deprecated(
        message = """
  Field 'connection_drain' has been deprecated since provider version 1.214.0. New field
      'connection_drain_enabled' instead.
  """,
    )
    @JvmName("kqsoaxgneegyvmpl")
    public suspend fun connectionDrain(`value`: Output<Boolean>) {
        this.connectionDrain = value
    }

    /**
     * @param value Specifies whether to enable connection draining.
     */
    @JvmName("apefxcoewtxqpeqh")
    public suspend fun connectionDrainEnabled(`value`: Output<Boolean>) {
        this.connectionDrainEnabled = value
    }

    /**
     * @param value Set the connection elegant interrupt timeout. Unit: seconds. Valid values: **10** ~ **900**.
     */
    @JvmName("jiwmnwpvxrvglfjr")
    public suspend fun connectionDrainTimeout(`value`: Output<Int>) {
        this.connectionDrainTimeout = value
    }

    /**
     * @param value Health check configuration information. See `health_check` below.
     */
    @JvmName("hvxdrepmsjqgcnwj")
    public suspend fun healthCheck(`value`: Output<ServerGroupHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value Indicates whether client address retention is enabled. Special instructions: When **AddressIPVersion** is of the **ipv4** type, the default value is **true**. **Addrestipversion** can only be **false** when the value of **ipv6** is **ipv6**, and can be **true** when supported by the underlying layer.
     */
    @JvmName("gkshmjjkhenddbye")
    public suspend fun preserveClientIpEnabled(`value`: Output<Boolean>) {
        this.preserveClientIpEnabled = value
    }

    /**
     * @param value The backend protocol. Valid values: `TCP` (default), `UDP`, and `TCPSSL`.
     */
    @JvmName("deegphpqcyebetnn")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The ID of the resource group to which the security group belongs.
     */
    @JvmName("sbbaccusmfgqxcnh")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The routing algorithm. Valid values:
     * - `Wrr` (default): The Weighted Round Robin algorithm is used. Backend servers with higher weights receive more requests than backend servers with lower weights.
     * - `Rr`: The round-robin algorithm is used. Requests are forwarded to backend servers in sequence.
     * - `Sch`: Source IP hashing is used. Requests from the same source IP address are forwarded to the same backend server.
     * - `Tch`: Four-element hashing is used. It specifies consistent hashing that is based on four factors: source IP address, destination IP address, source port, and destination port. Requests that contain the same information based on the four factors are forwarded to the same backend server.
     * - `Qch`: QUIC ID hashing is used. Requests that contain the same QUIC ID are forwarded to the same backend server.
     */
    @JvmName("rkiideefbqvpstad")
    public suspend fun scheduler(`value`: Output<String>) {
        this.scheduler = value
    }

    /**
     * @param value The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("tmtyvmqhssucihyh")
    public suspend fun serverGroupName(`value`: Output<String>) {
        this.serverGroupName = value
    }

    /**
     * @param value The type of the server group. Valid values:
     * - `Instance` (default): allows you to specify `Ecs`, `Ens`, or `Eci`.
     * - `Ip`: allows you to specify IP addresses.
     */
    @JvmName("wreufpgdlblkgigl")
    public suspend fun serverGroupType(`value`: Output<String>) {
        this.serverGroupType = value
    }

    /**
     * @param value Label.
     */
    @JvmName("kdwucviyujasegcg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC to which the server group belongs.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("nwjomjpmuroisvwt")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The protocol version. Valid values: `Ipv4` (default), `DualStack`.
     */
    @JvmName("freeyqfxwveypcmj")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressIpVersion = mapped
    }

    /**
     * @param value Full port forwarding.
     */
    @JvmName("ujekkeevmfdbqcmh")
    public suspend fun anyPortEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anyPortEnabled = mapped
    }

    /**
     * @param value . Field 'connection_drain' has been deprecated from provider version 1.214.0. New field 'connection_drain_enabled' instead.
     */
    @Deprecated(
        message = """
  Field 'connection_drain' has been deprecated since provider version 1.214.0. New field
      'connection_drain_enabled' instead.
  """,
    )
    @JvmName("bfcbebqmgrulqmpo")
    public suspend fun connectionDrain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDrain = mapped
    }

    /**
     * @param value Specifies whether to enable connection draining.
     */
    @JvmName("wwejlfdswyayytva")
    public suspend fun connectionDrainEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDrainEnabled = mapped
    }

    /**
     * @param value Set the connection elegant interrupt timeout. Unit: seconds. Valid values: **10** ~ **900**.
     */
    @JvmName("kmjtiotdyuvafxmn")
    public suspend fun connectionDrainTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDrainTimeout = mapped
    }

    /**
     * @param value Health check configuration information. See `health_check` below.
     */
    @JvmName("wblwpifopjybubsv")
    public suspend fun healthCheck(`value`: ServerGroupHealthCheckArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument Health check configuration information. See `health_check` below.
     */
    @JvmName("sgyvmlqugfuiekji")
    public suspend fun healthCheck(argument: suspend ServerGroupHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = ServerGroupHealthCheckArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    /**
     * @param value Indicates whether client address retention is enabled. Special instructions: When **AddressIPVersion** is of the **ipv4** type, the default value is **true**. **Addrestipversion** can only be **false** when the value of **ipv6** is **ipv6**, and can be **true** when supported by the underlying layer.
     */
    @JvmName("bmtqbwjbeljknhgn")
    public suspend fun preserveClientIpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveClientIpEnabled = mapped
    }

    /**
     * @param value The backend protocol. Valid values: `TCP` (default), `UDP`, and `TCPSSL`.
     */
    @JvmName("vnqcgpxxecdmlkos")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The ID of the resource group to which the security group belongs.
     */
    @JvmName("bnmsfonhfgvofvkp")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The routing algorithm. Valid values:
     * - `Wrr` (default): The Weighted Round Robin algorithm is used. Backend servers with higher weights receive more requests than backend servers with lower weights.
     * - `Rr`: The round-robin algorithm is used. Requests are forwarded to backend servers in sequence.
     * - `Sch`: Source IP hashing is used. Requests from the same source IP address are forwarded to the same backend server.
     * - `Tch`: Four-element hashing is used. It specifies consistent hashing that is based on four factors: source IP address, destination IP address, source port, and destination port. Requests that contain the same information based on the four factors are forwarded to the same backend server.
     * - `Qch`: QUIC ID hashing is used. Requests that contain the same QUIC ID are forwarded to the same backend server.
     */
    @JvmName("ledbjwyipaqyhmkv")
    public suspend fun scheduler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduler = mapped
    }

    /**
     * @param value The name of the server group. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("rxghoxfmemlcxecs")
    public suspend fun serverGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupName = mapped
    }

    /**
     * @param value The type of the server group. Valid values:
     * - `Instance` (default): allows you to specify `Ecs`, `Ens`, or `Eci`.
     * - `Ip`: allows you to specify IP addresses.
     */
    @JvmName("wegkxeiiurbkwpfq")
    public suspend fun serverGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupType = mapped
    }

    /**
     * @param value Label.
     */
    @JvmName("jovfmgmgaekbwlqb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Label.
     */
    @JvmName("hdnrgjxawukddlll")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC to which the server group belongs.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("xbtoalmhlgailrxj")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ServerGroupArgs = ServerGroupArgs(
        addressIpVersion = addressIpVersion,
        anyPortEnabled = anyPortEnabled,
        connectionDrain = connectionDrain,
        connectionDrainEnabled = connectionDrainEnabled,
        connectionDrainTimeout = connectionDrainTimeout,
        healthCheck = healthCheck,
        preserveClientIpEnabled = preserveClientIpEnabled,
        protocol = protocol,
        resourceGroupId = resourceGroupId,
        scheduler = scheduler,
        serverGroupName = serverGroupName,
        serverGroupType = serverGroupType,
        tags = tags,
        vpcId = vpcId,
    )
}
