@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerGroupServerAttachment].
 */
@PulumiTagMarker
public class ServerGroupServerAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerGroupServerAttachmentArgs = ServerGroupServerAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerGroupServerAttachmentArgsBuilder.() -> Unit) {
        val builder = ServerGroupServerAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerGroupServerAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.nlb.ServerGroupServerAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerGroupServerAttachment(builtJavaResource)
    }
}

/**
 * Provides a NLB Server Group Server Attachment resource.
 * For information about NLB Server Group Server Attachment and how to use it, see [What is Server Group Server Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/addserverstoservergroup-nlb).
 * > **NOTE:** Available since v1.192.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultServerGroup = new alicloud.nlb.ServerGroup("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     serverGroupName: name,
 *     serverGroupType: "Ip",
 *     vpcId: defaultNetwork.id,
 *     scheduler: "Wrr",
 *     protocol: "TCP",
 *     healthCheck: {
 *         healthCheckEnabled: false,
 *     },
 *     addressIpVersion: "Ipv4",
 * });
 * const defaultServerGroupServerAttachment = new alicloud.nlb.ServerGroupServerAttachment("default", {
 *     serverType: "Ip",
 *     serverId: "10.0.0.0",
 *     description: name,
 *     port: 80,
 *     serverGroupId: defaultServerGroup.id,
 *     weight: 100,
 *     serverIp: "10.0.0.0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_server_group = alicloud.nlb.ServerGroup("default",
 *     resource_group_id=default.ids[0],
 *     server_group_name=name,
 *     server_group_type="Ip",
 *     vpc_id=default_network.id,
 *     scheduler="Wrr",
 *     protocol="TCP",
 *     health_check={
 *         "health_check_enabled": False,
 *     },
 *     address_ip_version="Ipv4")
 * default_server_group_server_attachment = alicloud.nlb.ServerGroupServerAttachment("default",
 *     server_type="Ip",
 *     server_id="10.0.0.0",
 *     description=name,
 *     port=80,
 *     server_group_id=default_server_group.id,
 *     weight=100,
 *     server_ip="10.0.0.0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultServerGroup = new AliCloud.Nlb.ServerGroup("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         ServerGroupName = name,
 *         ServerGroupType = "Ip",
 *         VpcId = defaultNetwork.Id,
 *         Scheduler = "Wrr",
 *         Protocol = "TCP",
 *         HealthCheck = new AliCloud.Nlb.Inputs.ServerGroupHealthCheckArgs
 *         {
 *             HealthCheckEnabled = false,
 *         },
 *         AddressIpVersion = "Ipv4",
 *     });
 *     var defaultServerGroupServerAttachment = new AliCloud.Nlb.ServerGroupServerAttachment("default", new()
 *     {
 *         ServerType = "Ip",
 *         ServerId = "10.0.0.0",
 *         Description = name,
 *         Port = 80,
 *         ServerGroupId = defaultServerGroup.Id,
 *         Weight = 100,
 *         ServerIp = "10.0.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultServerGroup, err := nlb.NewServerGroup(ctx, "default", &nlb.ServerGroupArgs{
 * 			ResourceGroupId: pulumi.String(_default.Ids[0]),
 * 			ServerGroupName: pulumi.String(name),
 * 			ServerGroupType: pulumi.String("Ip"),
 * 			VpcId:           defaultNetwork.ID(),
 * 			Scheduler:       pulumi.String("Wrr"),
 * 			Protocol:        pulumi.String("TCP"),
 * 			HealthCheck: &nlb.ServerGroupHealthCheckArgs{
 * 				HealthCheckEnabled: pulumi.Bool(false),
 * 			},
 * 			AddressIpVersion: pulumi.String("Ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewServerGroupServerAttachment(ctx, "default", &nlb.ServerGroupServerAttachmentArgs{
 * 			ServerType:    pulumi.String("Ip"),
 * 			ServerId:      pulumi.String("10.0.0.0"),
 * 			Description:   pulumi.String(name),
 * 			Port:          pulumi.Int(80),
 * 			ServerGroupId: defaultServerGroup.ID(),
 * 			Weight:        pulumi.Int(100),
 * 			ServerIp:      pulumi.String("10.0.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.nlb.ServerGroup;
 * import com.pulumi.alicloud.nlb.ServerGroupArgs;
 * import com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs;
 * import com.pulumi.alicloud.nlb.ServerGroupServerAttachment;
 * import com.pulumi.alicloud.nlb.ServerGroupServerAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .serverGroupName(name)
 *             .serverGroupType("Ip")
 *             .vpcId(defaultNetwork.id())
 *             .scheduler("Wrr")
 *             .protocol("TCP")
 *             .healthCheck(ServerGroupHealthCheckArgs.builder()
 *                 .healthCheckEnabled(false)
 *                 .build())
 *             .addressIpVersion("Ipv4")
 *             .build());
 *         var defaultServerGroupServerAttachment = new ServerGroupServerAttachment("defaultServerGroupServerAttachment", ServerGroupServerAttachmentArgs.builder()
 *             .serverType("Ip")
 *             .serverId("10.0.0.0")
 *             .description(name)
 *             .port(80)
 *             .serverGroupId(defaultServerGroup.id())
 *             .weight(100)
 *             .serverIp("10.0.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultServerGroup:
 *     type: alicloud:nlb:ServerGroup
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       serverGroupName: ${name}
 *       serverGroupType: Ip
 *       vpcId: ${defaultNetwork.id}
 *       scheduler: Wrr
 *       protocol: TCP
 *       healthCheck:
 *         healthCheckEnabled: false
 *       addressIpVersion: Ipv4
 *   defaultServerGroupServerAttachment:
 *     type: alicloud:nlb:ServerGroupServerAttachment
 *     name: default
 *     properties:
 *       serverType: Ip
 *       serverId: 10.0.0.0
 *       description: ${name}
 *       port: 80
 *       serverGroupId: ${defaultServerGroup.id}
 *       weight: 100
 *       serverIp: 10.0.0.0
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Server Group Server Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/serverGroupServerAttachment:ServerGroupServerAttachment example <server_group_id>:<server_id>:<server_type>:<port>
 * ```
 */
public class ServerGroupServerAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.nlb.ServerGroupServerAttachment,
) : KotlinCustomResource(javaResource, ServerGroupServerAttachmentMapper) {
    /**
     * The description of the servers. The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port used by the backend server. Valid values: 1 to 65535.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The ID of the server group.
     */
    public val serverGroupId: Output<String>
        get() = javaResource.serverGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the server.
     * - If the server group type is Instance, set the ServerId parameter to the ID of an Elastic Compute Service (ECS) instance, an elastic network interface (ENI), or an elastic container instance. These backend servers are specified by Ecs, Eni, or Eci.
     * - If the server group type is Ip, set the ServerId parameter to an IP address.
     */
    public val serverId: Output<String>
        get() = javaResource.serverId().applyValue({ args0 -> args0 })

    /**
     * The IP address of the server. If the server group type is Ip, set the ServerId parameter to an IP address.
     */
    public val serverIp: Output<String>
        get() = javaResource.serverIp().applyValue({ args0 -> args0 })

    /**
     * The type of the backend server. Valid values: `Ecs`, `Eni`, `Eci`, `Ip`.
     */
    public val serverType: Output<String>
        get() = javaResource.serverType().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The weight of the backend server. Valid values: 0 to 100. Default value: 100. If the weight of a backend server is set to 0, no requests are forwarded to the backend server.
     */
    public val weight: Output<Int>
        get() = javaResource.weight().applyValue({ args0 -> args0 })

    /**
     * The zoneId of the server.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ServerGroupServerAttachmentMapper : ResourceMapper<ServerGroupServerAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nlb.ServerGroupServerAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ServerGroupServerAttachment =
        ServerGroupServerAttachment(
            javaResource as
                com.pulumi.alicloud.nlb.ServerGroupServerAttachment,
        )
}

/**
 * @see [ServerGroupServerAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerGroupServerAttachment].
 */
public suspend fun serverGroupServerAttachment(
    name: String,
    block: suspend ServerGroupServerAttachmentResourceBuilder.() -> Unit,
): ServerGroupServerAttachment {
    val builder = ServerGroupServerAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerGroupServerAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverGroupServerAttachment(name: String): ServerGroupServerAttachment {
    val builder = ServerGroupServerAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
