@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.GetListenersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getListeners.
 * @property ids A list of Listener IDs.
 * @property listenerProtocol The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
 * @property loadBalancerIds The ID of the NLB instance. You can specify at most 20 IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetListenersPlainArgs(
    public val ids: List<String>? = null,
    public val listenerProtocol: String? = null,
    public val loadBalancerIds: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.GetListenersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.GetListenersPlainArgs =
        com.pulumi.alicloud.nlb.inputs.GetListenersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerProtocol(listenerProtocol?.let({ args0 -> args0 }))
            .loadBalancerIds(loadBalancerIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetListenersPlainArgs].
 */
@PulumiTagMarker
public class GetListenersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var listenerProtocol: String? = null

    private var loadBalancerIds: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Listener IDs.
     */
    @JvmName("wmyecfgbudrmvafe")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Listener IDs.
     */
    @JvmName("iuhvchyipjpbfwvk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
     */
    @JvmName("tudfnqcvpkxtnyys")
    public suspend fun listenerProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerProtocol = mapped
    }

    /**
     * @param value The ID of the NLB instance. You can specify at most 20 IDs.
     */
    @JvmName("joeqlnoywsucixnl")
    public suspend fun loadBalancerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param values The ID of the NLB instance. You can specify at most 20 IDs.
     */
    @JvmName("nwxwbkfvqpjscffg")
    public suspend fun loadBalancerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gecmcelrtimexgyt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetListenersPlainArgs = GetListenersPlainArgs(
        ids = ids,
        listenerProtocol = listenerProtocol,
        loadBalancerIds = loadBalancerIds,
        outputFile = outputFile,
    )
}
