@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.GetLoadBalancersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLoadBalancers.
 * @property addressIpVersion The IP version. Valid values: `ipv4`, `DualStack`.
 * @property addressType The type of IPv4 address used by the NLB instance. Valid values: `Internet`, `Intranet`.
 * @property dnsName The domain name of the NLB instance.
 * @property ids A list of Load Balancer IDs.
 * @property ipv6AddressType The type of IPv6 address used by the NLB instance. Valid values: `Internet`, `Intranet`.
 * @property loadBalancerBusinessStatus The business status of the NLB instance. Valid values: `Abnormal`, `Normal`.
 * @property loadBalancerNames The name of the NLB instance. You can specify at most 10 names.
 * @property nameRegex A regex string to filter results by Load Balancer name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the NLB instance. Valid values: `Inactive`, `Active`, `Provisioning`, `Configuring`, `Deleting`, `Deleted`.
 * @property tags
 * @property vpcIds The ID of the virtual private cloud (VPC) where the NLB instance is deployed. You can specify at most 10 IDs.
 * @property zoneId The name of the zone.
 */
public data class GetLoadBalancersPlainArgs(
    public val addressIpVersion: String? = null,
    public val addressType: String? = null,
    public val dnsName: String? = null,
    public val ids: List<String>? = null,
    public val ipv6AddressType: String? = null,
    public val loadBalancerBusinessStatus: String? = null,
    public val loadBalancerNames: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcIds: List<String>? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.GetLoadBalancersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.GetLoadBalancersPlainArgs =
        com.pulumi.alicloud.nlb.inputs.GetLoadBalancersPlainArgs.builder()
            .addressIpVersion(addressIpVersion?.let({ args0 -> args0 }))
            .addressType(addressType?.let({ args0 -> args0 }))
            .dnsName(dnsName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressType(ipv6AddressType?.let({ args0 -> args0 }))
            .loadBalancerBusinessStatus(loadBalancerBusinessStatus?.let({ args0 -> args0 }))
            .loadBalancerNames(loadBalancerNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcIds(vpcIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadBalancersPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancersPlainArgsBuilder internal constructor() {
    private var addressIpVersion: String? = null

    private var addressType: String? = null

    private var dnsName: String? = null

    private var ids: List<String>? = null

    private var ipv6AddressType: String? = null

    private var loadBalancerBusinessStatus: String? = null

    private var loadBalancerNames: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcIds: List<String>? = null

    private var zoneId: String? = null

    /**
     * @param value The IP version. Valid values: `ipv4`, `DualStack`.
     */
    @JvmName("xqquwasdwtqkfnlc")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addressIpVersion = mapped
    }

    /**
     * @param value The type of IPv4 address used by the NLB instance. Valid values: `Internet`, `Intranet`.
     */
    @JvmName("etjuptkyahrhjpll")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addressType = mapped
    }

    /**
     * @param value The domain name of the NLB instance.
     */
    @JvmName("bnamuqansasijywb")
    public suspend fun dnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dnsName = mapped
    }

    /**
     * @param value A list of Load Balancer IDs.
     */
    @JvmName("hcytvbywthpjhewq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Load Balancer IDs.
     */
    @JvmName("ystiqtggrxotokne")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The type of IPv6 address used by the NLB instance. Valid values: `Internet`, `Intranet`.
     */
    @JvmName("pnrttioeqiunpghr")
    public suspend fun ipv6AddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipv6AddressType = mapped
    }

    /**
     * @param value The business status of the NLB instance. Valid values: `Abnormal`, `Normal`.
     */
    @JvmName("numgfhkxfhmhiusv")
    public suspend fun loadBalancerBusinessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerBusinessStatus = mapped
    }

    /**
     * @param value The name of the NLB instance. You can specify at most 10 names.
     */
    @JvmName("sqwvphggxqauoxpo")
    public suspend fun loadBalancerNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerNames = mapped
    }

    /**
     * @param values The name of the NLB instance. You can specify at most 10 names.
     */
    @JvmName("ukvotjcemqbsamuy")
    public suspend fun loadBalancerNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerNames = mapped
    }

    /**
     * @param value A regex string to filter results by Load Balancer name.
     */
    @JvmName("kqnnlkummttqwulj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ushtlbwsjrdlhdqs")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("xdvvdqrgkitarqcd")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the NLB instance. Valid values: `Inactive`, `Active`, `Provisioning`, `Configuring`, `Deleting`, `Deleted`.
     */
    @JvmName("ybdcxamhigmnshth")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("ywrtpossixapisdh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("cwpmoosmqbwmcsvt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) where the NLB instance is deployed. You can specify at most 10 IDs.
     */
    @JvmName("qplojcccfaavhefj")
    public suspend fun vpcIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcIds = mapped
    }

    /**
     * @param values The ID of the virtual private cloud (VPC) where the NLB instance is deployed. You can specify at most 10 IDs.
     */
    @JvmName("lagfrpixffsfppqh")
    public suspend fun vpcIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpcIds = mapped
    }

    /**
     * @param value The name of the zone.
     */
    @JvmName("wjjawjhljjlooeoy")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetLoadBalancersPlainArgs = GetLoadBalancersPlainArgs(
        addressIpVersion = addressIpVersion,
        addressType = addressType,
        dnsName = dnsName,
        ids = ids,
        ipv6AddressType = ipv6AddressType,
        loadBalancerBusinessStatus = loadBalancerBusinessStatus,
        loadBalancerNames = loadBalancerNames,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
        vpcIds = vpcIds,
        zoneId = zoneId,
    )
}
