@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.GetSecurityPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityPolicies.
 * @property ids A list of Security Policy IDs.
 * @property nameRegex A regex string to filter results by Security Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group.
 * @property securityPolicyNames The names of the TLS security policies.
 * @property status The status of the resource. Valid values: `Available`, `Configuring`.
 * @property tags
 */
public data class GetSecurityPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val securityPolicyNames: List<String>? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.GetSecurityPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.GetSecurityPoliciesPlainArgs =
        com.pulumi.alicloud.nlb.inputs.GetSecurityPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .securityPolicyNames(securityPolicyNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSecurityPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var securityPolicyNames: List<String>? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of Security Policy IDs.
     */
    @JvmName("rysydwnovtfqsogc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Security Policy IDs.
     */
    @JvmName("jysjbcptamkwdacx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Security Policy name.
     */
    @JvmName("ghlraahureahcuyf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yeeefmjnbnguaiki")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ghtdodqurftkouwv")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The names of the TLS security policies.
     */
    @JvmName("qldaitjvhmkbebqs")
    public suspend fun securityPolicyNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityPolicyNames = mapped
    }

    /**
     * @param values The names of the TLS security policies.
     */
    @JvmName("tethpjeydcmejafg")
    public suspend fun securityPolicyNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityPolicyNames = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Available`, `Configuring`.
     */
    @JvmName("ippcvkskokyliein")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("aomblnrswawuxbma")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("udjmrtmlvbcosgqy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSecurityPoliciesPlainArgs = GetSecurityPoliciesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        securityPolicyNames = securityPolicyNames,
        status = status,
        tags = tags,
    )
}
