@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.GetServerGroupServerAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerGroupServerAttachments.
 * @property ids A list of Server Group Server Attachment IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serverGroupId The ID of the server group.
 * @property serverIds The IDs of the servers. You can specify at most 40 server IDs in each call.
 * @property serverIps The IP addresses of the servers. You can specify at most 40 server IP addresses in each call.
 */
public data class GetServerGroupServerAttachmentsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val serverGroupId: String? = null,
    public val serverIds: List<String>? = null,
    public val serverIps: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.GetServerGroupServerAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.GetServerGroupServerAttachmentsPlainArgs =
        com.pulumi.alicloud.nlb.inputs.GetServerGroupServerAttachmentsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serverGroupId(serverGroupId?.let({ args0 -> args0 }))
            .serverIds(serverIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .serverIps(serverIps?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetServerGroupServerAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetServerGroupServerAttachmentsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var serverGroupId: String? = null

    private var serverIds: List<String>? = null

    private var serverIps: List<String>? = null

    /**
     * @param value A list of Server Group Server Attachment IDs.
     */
    @JvmName("vudxevohhbyulikl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Server Group Server Attachment IDs.
     */
    @JvmName("dvyxlonbonagjjge")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hgccpentyeipcgjg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the server group.
     */
    @JvmName("agpasdupyjtavjfm")
    public suspend fun serverGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverGroupId = mapped
    }

    /**
     * @param value The IDs of the servers. You can specify at most 40 server IDs in each call.
     */
    @JvmName("thfljyfqwvuxuelw")
    public suspend fun serverIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverIds = mapped
    }

    /**
     * @param values The IDs of the servers. You can specify at most 40 server IDs in each call.
     */
    @JvmName("picacjmwvjnesehx")
    public suspend fun serverIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverIds = mapped
    }

    /**
     * @param value The IP addresses of the servers. You can specify at most 40 server IP addresses in each call.
     */
    @JvmName("vhwwemvwkrdlsfik")
    public suspend fun serverIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverIps = mapped
    }

    /**
     * @param values The IP addresses of the servers. You can specify at most 40 server IP addresses in each call.
     */
    @JvmName("fyggfrqvnfpqvlcj")
    public suspend fun serverIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverIps = mapped
    }

    internal fun build(): GetServerGroupServerAttachmentsPlainArgs =
        GetServerGroupServerAttachmentsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            serverGroupId = serverGroupId,
            serverIds = serverIds,
            serverIps = serverIps,
        )
}
