@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.GetServerGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerGroups.
 * @property ids A list of Server Group IDs.
 * @property nameRegex A regex string to filter results by Server Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group to which the security group belongs.
 * @property serverGroupNames The names of the server groups to be queried.
 * @property serverGroupType The type of the server group. Valid values: `Instance`, `Ip`.
 * @property status The status of the resource. Valid values: `Available`, `Configuring`, `Creating`.
 * @property tags
 */
public data class GetServerGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val serverGroupNames: List<String>? = null,
    public val serverGroupType: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.GetServerGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.GetServerGroupsPlainArgs =
        com.pulumi.alicloud.nlb.inputs.GetServerGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .serverGroupNames(serverGroupNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .serverGroupType(serverGroupType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetServerGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetServerGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var serverGroupNames: List<String>? = null

    private var serverGroupType: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of Server Group IDs.
     */
    @JvmName("ktgjtiyjgfdmhmis")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Server Group IDs.
     */
    @JvmName("miaryfvybrimlrhs")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Server Group name.
     */
    @JvmName("ohunybkfvttrffmx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lowbtqcicdlnyodg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group to which the security group belongs.
     */
    @JvmName("oademteajieoxbad")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The names of the server groups to be queried.
     */
    @JvmName("kcodruuyqgyfodap")
    public suspend fun serverGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverGroupNames = mapped
    }

    /**
     * @param values The names of the server groups to be queried.
     */
    @JvmName("iswhymlcartkwgin")
    public suspend fun serverGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverGroupNames = mapped
    }

    /**
     * @param value The type of the server group. Valid values: `Instance`, `Ip`.
     */
    @JvmName("vegsubyvlhrpupnn")
    public suspend fun serverGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverGroupType = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Available`, `Configuring`, `Creating`.
     */
    @JvmName("xcuusyeofoswwfxe")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("ukgjswmicxufgets")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("nyuygliqmhfrkcls")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetServerGroupsPlainArgs = GetServerGroupsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        serverGroupNames = serverGroupNames,
        serverGroupType = serverGroupType,
        status = status,
        tags = tags,
    )
}
