@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.LoadBalancerDeletionProtectionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Delete protection enable.
 * @property enabledTime Opening time.
 * @property reason Reason for opening.
 */
public data class LoadBalancerDeletionProtectionConfigArgs(
    public val enabled: Output<Boolean>? = null,
    public val enabledTime: Output<String>? = null,
    public val reason: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.LoadBalancerDeletionProtectionConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.LoadBalancerDeletionProtectionConfigArgs =
        com.pulumi.alicloud.nlb.inputs.LoadBalancerDeletionProtectionConfigArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .enabledTime(enabledTime?.applyValue({ args0 -> args0 }))
            .reason(reason?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerDeletionProtectionConfigArgs].
 */
@PulumiTagMarker
public class LoadBalancerDeletionProtectionConfigArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var enabledTime: Output<String>? = null

    private var reason: Output<String>? = null

    /**
     * @param value Delete protection enable.
     */
    @JvmName("tfbyshgjpdfovxfx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Opening time.
     */
    @JvmName("qnayrsewgxcovxko")
    public suspend fun enabledTime(`value`: Output<String>) {
        this.enabledTime = value
    }

    /**
     * @param value Reason for opening.
     */
    @JvmName("oikufqgpdhbvtdve")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value Delete protection enable.
     */
    @JvmName("sayofqlysafxviqb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Opening time.
     */
    @JvmName("xghcvoljllkwkjmf")
    public suspend fun enabledTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledTime = mapped
    }

    /**
     * @param value Reason for opening.
     */
    @JvmName("vyvihbeuwpnubeer")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    internal fun build(): LoadBalancerDeletionProtectionConfigArgs =
        LoadBalancerDeletionProtectionConfigArgs(
            enabled = enabled,
            enabledTime = enabledTime,
            reason = reason,
        )
}
