@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.LoadBalancerModificationProtectionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabledTime Opening time.
 * @property reason Reason for opening.
 * @property status ON.
 */
public data class LoadBalancerModificationProtectionConfigArgs(
    public val enabledTime: Output<String>? = null,
    public val reason: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.LoadBalancerModificationProtectionConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.LoadBalancerModificationProtectionConfigArgs = com.pulumi.alicloud.nlb.inputs.LoadBalancerModificationProtectionConfigArgs.builder()
        .enabledTime(enabledTime?.applyValue({ args0 -> args0 }))
        .reason(reason?.applyValue({ args0 -> args0 }))
        .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerModificationProtectionConfigArgs].
 */
@PulumiTagMarker
public class LoadBalancerModificationProtectionConfigArgsBuilder internal constructor() {
    private var enabledTime: Output<String>? = null

    private var reason: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Opening time.
     */
    @JvmName("tkxyjqvdetuqksxa")
    public suspend fun enabledTime(`value`: Output<String>) {
        this.enabledTime = value
    }

    /**
     * @param value Reason for opening.
     */
    @JvmName("xjwtyijrlkmnqyhd")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value ON.
     */
    @JvmName("qmeaygunjcqsqnis")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Opening time.
     */
    @JvmName("jaujgctvymwgscgh")
    public suspend fun enabledTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledTime = mapped
    }

    /**
     * @param value Reason for opening.
     */
    @JvmName("tvhigknmwfruelbc")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    /**
     * @param value ON.
     */
    @JvmName("sqceryfbjbndfvbh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): LoadBalancerModificationProtectionConfigArgs =
        LoadBalancerModificationProtectionConfigArgs(
            enabledTime = enabledTime,
            reason = reason,
            status = status,
        )
}
