@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allocationId The ID of the elastic IP address.
 * @property eniId The ID of ENI.
 * @property ipv6Address The IPv6 address of a network-based server load balancer instance.
 * @property privateIpv4Address The private IPv4 address of a network-based server load balancer instance.
 * @property publicIpv4Address Public IPv4 address of a network-based server load balancer instance.
 * @property status Zone Status.
 * @property vswitchId The switch corresponding to the zone. Each zone uses one switch and one subnet by default.
 * @property zoneId The name of the zone. You can call the DescribeZones operation to obtain the name of the zone.
 */
public data class LoadBalancerZoneMappingArgs(
    public val allocationId: Output<String>? = null,
    public val eniId: Output<String>? = null,
    public val ipv6Address: Output<String>? = null,
    public val privateIpv4Address: Output<String>? = null,
    public val publicIpv4Address: Output<String>? = null,
    public val status: Output<String>? = null,
    public val vswitchId: Output<String>,
    public val zoneId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs =
        com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs.builder()
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .eniId(eniId?.applyValue({ args0 -> args0 }))
            .ipv6Address(ipv6Address?.applyValue({ args0 -> args0 }))
            .privateIpv4Address(privateIpv4Address?.applyValue({ args0 -> args0 }))
            .publicIpv4Address(publicIpv4Address?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId.applyValue({ args0 -> args0 }))
            .zoneId(zoneId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerZoneMappingArgs].
 */
@PulumiTagMarker
public class LoadBalancerZoneMappingArgsBuilder internal constructor() {
    private var allocationId: Output<String>? = null

    private var eniId: Output<String>? = null

    private var ipv6Address: Output<String>? = null

    private var privateIpv4Address: Output<String>? = null

    private var publicIpv4Address: Output<String>? = null

    private var status: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The ID of the elastic IP address.
     */
    @JvmName("dakxkbxvlqygdrwv")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value The ID of ENI.
     */
    @JvmName("edklycdtxiecymeo")
    public suspend fun eniId(`value`: Output<String>) {
        this.eniId = value
    }

    /**
     * @param value The IPv6 address of a network-based server load balancer instance.
     */
    @JvmName("xjthwjwqdqmbkutp")
    public suspend fun ipv6Address(`value`: Output<String>) {
        this.ipv6Address = value
    }

    /**
     * @param value The private IPv4 address of a network-based server load balancer instance.
     */
    @JvmName("gavoqqrylginpqoh")
    public suspend fun privateIpv4Address(`value`: Output<String>) {
        this.privateIpv4Address = value
    }

    /**
     * @param value Public IPv4 address of a network-based server load balancer instance.
     */
    @JvmName("bgihlihocqfhlcyu")
    public suspend fun publicIpv4Address(`value`: Output<String>) {
        this.publicIpv4Address = value
    }

    /**
     * @param value Zone Status.
     */
    @JvmName("dymdanwcqajrmnys")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The switch corresponding to the zone. Each zone uses one switch and one subnet by default.
     */
    @JvmName("kvarmplogklyqyqd")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The name of the zone. You can call the DescribeZones operation to obtain the name of the zone.
     */
    @JvmName("xevinykqxfqfxonq")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The ID of the elastic IP address.
     */
    @JvmName("mfvcniyswywtxuny")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value The ID of ENI.
     */
    @JvmName("eihwefbcttjkljxl")
    public suspend fun eniId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniId = mapped
    }

    /**
     * @param value The IPv6 address of a network-based server load balancer instance.
     */
    @JvmName("nybwbubdbilbkqup")
    public suspend fun ipv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Address = mapped
    }

    /**
     * @param value The private IPv4 address of a network-based server load balancer instance.
     */
    @JvmName("fileyfcphwlqpchn")
    public suspend fun privateIpv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpv4Address = mapped
    }

    /**
     * @param value Public IPv4 address of a network-based server load balancer instance.
     */
    @JvmName("eneitprejhshreor")
    public suspend fun publicIpv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpv4Address = mapped
    }

    /**
     * @param value Zone Status.
     */
    @JvmName("qcheuiqbqycgxllo")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The switch corresponding to the zone. Each zone uses one switch and one subnet by default.
     */
    @JvmName("thhfqmhhyyjbgqcl")
    public suspend fun vswitchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The name of the zone. You can call the DescribeZones operation to obtain the name of the zone.
     */
    @JvmName("wctffsruwxedmwvr")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): LoadBalancerZoneMappingArgs = LoadBalancerZoneMappingArgs(
        allocationId = allocationId,
        eniId = eniId,
        ipv6Address = ipv6Address,
        privateIpv4Address = privateIpv4Address,
        publicIpv4Address = publicIpv4Address,
        status = status,
        vswitchId = vswitchId ?: throw PulumiNullFieldException("vswitchId"),
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
