@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.inputs

import com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property healthCheckConnectPort The port of the backend server for health checks. Valid values: **0** ~ **65535**. **0** indicates that the port of the backend server is used for health check.
 * @property healthCheckConnectTimeout Maximum timeout for health check responses. Unit: seconds. Valid values: **1** ~ **300**.
 * @property healthCheckDomain The domain name used for health check. Valid values:
 * - **$SERVER_IP**: uses the intranet IP of the backend server.
 * - **domain**: Specify a specific domain name. The length is limited to 1 to 80 characters. Only lowercase letters, numbers, dashes (-), and half-width periods (.) can be used.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property healthCheckEnabled Whether to enable health check. Valid values:
 * - **true**: on.
 * - **false**: closed.
 * @property healthCheckHttpCodes Health status return code. Multiple status codes are separated by commas (,). Valid values: **http\_2xx**, **http\_3xx**, **http\_4xx**, and **http\_5xx**.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property healthCheckInterval Time interval of health examination. Unit: seconds.  Valid values: **5** ~ **50**.
 * @property healthCheckType Health check protocol. Valid values: **TCP** or **HTTP**.
 * @property healthCheckUrl Health check path.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property healthyThreshold After the health check is successful, the health check status of the backend server is determined from **failed** to **successful**.  Valid values: **2** to **10**.
 * @property httpCheckMethod The health check method. Valid values: **GET** or **HEAD**.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property unhealthyThreshold After the health check fails for many times in a row, the health check status of the backend server is determined from **Success** to **Failure**. Valid values: **2** to **10**.
 */
public data class ServerGroupHealthCheckArgs(
    public val healthCheckConnectPort: Output<Int>? = null,
    public val healthCheckConnectTimeout: Output<Int>? = null,
    public val healthCheckDomain: Output<String>? = null,
    public val healthCheckEnabled: Output<Boolean>? = null,
    public val healthCheckHttpCodes: Output<List<String>>? = null,
    public val healthCheckInterval: Output<Int>? = null,
    public val healthCheckType: Output<String>? = null,
    public val healthCheckUrl: Output<String>? = null,
    public val healthyThreshold: Output<Int>? = null,
    public val httpCheckMethod: Output<String>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs =
        com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs.builder()
            .healthCheckConnectPort(healthCheckConnectPort?.applyValue({ args0 -> args0 }))
            .healthCheckConnectTimeout(healthCheckConnectTimeout?.applyValue({ args0 -> args0 }))
            .healthCheckDomain(healthCheckDomain?.applyValue({ args0 -> args0 }))
            .healthCheckEnabled(healthCheckEnabled?.applyValue({ args0 -> args0 }))
            .healthCheckHttpCodes(healthCheckHttpCodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .healthCheckInterval(healthCheckInterval?.applyValue({ args0 -> args0 }))
            .healthCheckType(healthCheckType?.applyValue({ args0 -> args0 }))
            .healthCheckUrl(healthCheckUrl?.applyValue({ args0 -> args0 }))
            .healthyThreshold(healthyThreshold?.applyValue({ args0 -> args0 }))
            .httpCheckMethod(httpCheckMethod?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerGroupHealthCheckArgs].
 */
@PulumiTagMarker
public class ServerGroupHealthCheckArgsBuilder internal constructor() {
    private var healthCheckConnectPort: Output<Int>? = null

    private var healthCheckConnectTimeout: Output<Int>? = null

    private var healthCheckDomain: Output<String>? = null

    private var healthCheckEnabled: Output<Boolean>? = null

    private var healthCheckHttpCodes: Output<List<String>>? = null

    private var healthCheckInterval: Output<Int>? = null

    private var healthCheckType: Output<String>? = null

    private var healthCheckUrl: Output<String>? = null

    private var healthyThreshold: Output<Int>? = null

    private var httpCheckMethod: Output<String>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value The port of the backend server for health checks. Valid values: **0** ~ **65535**. **0** indicates that the port of the backend server is used for health check.
     */
    @JvmName("atycitngjskasvff")
    public suspend fun healthCheckConnectPort(`value`: Output<Int>) {
        this.healthCheckConnectPort = value
    }

    /**
     * @param value Maximum timeout for health check responses. Unit: seconds. Valid values: **1** ~ **300**.
     */
    @JvmName("bwmwnkxfxtetfnla")
    public suspend fun healthCheckConnectTimeout(`value`: Output<Int>) {
        this.healthCheckConnectTimeout = value
    }

    /**
     * @param value The domain name used for health check. Valid values:
     * - **$SERVER_IP**: uses the intranet IP of the backend server.
     * - **domain**: Specify a specific domain name. The length is limited to 1 to 80 characters. Only lowercase letters, numbers, dashes (-), and half-width periods (.) can be used.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("ehhslhxkpghclpxs")
    public suspend fun healthCheckDomain(`value`: Output<String>) {
        this.healthCheckDomain = value
    }

    /**
     * @param value Whether to enable health check. Valid values:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("exalsctvidbnnubs")
    public suspend fun healthCheckEnabled(`value`: Output<Boolean>) {
        this.healthCheckEnabled = value
    }

    /**
     * @param value Health status return code. Multiple status codes are separated by commas (,). Valid values: **http\_2xx**, **http\_3xx**, **http\_4xx**, and **http\_5xx**.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("acrnjkidfxdkdphd")
    public suspend fun healthCheckHttpCodes(`value`: Output<List<String>>) {
        this.healthCheckHttpCodes = value
    }

    @JvmName("hlibxdjgdjwqfbra")
    public suspend fun healthCheckHttpCodes(vararg values: Output<String>) {
        this.healthCheckHttpCodes = Output.all(values.asList())
    }

    /**
     * @param values Health status return code. Multiple status codes are separated by commas (,). Valid values: **http\_2xx**, **http\_3xx**, **http\_4xx**, and **http\_5xx**.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("qpkfyqfwxqibichn")
    public suspend fun healthCheckHttpCodes(values: List<Output<String>>) {
        this.healthCheckHttpCodes = Output.all(values)
    }

    /**
     * @param value Time interval of health examination. Unit: seconds.  Valid values: **5** ~ **50**.
     */
    @JvmName("qqtngbvkuwlvrkrh")
    public suspend fun healthCheckInterval(`value`: Output<Int>) {
        this.healthCheckInterval = value
    }

    /**
     * @param value Health check protocol. Valid values: **TCP** or **HTTP**.
     */
    @JvmName("uqbrregdwicxonbx")
    public suspend fun healthCheckType(`value`: Output<String>) {
        this.healthCheckType = value
    }

    /**
     * @param value Health check path.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("lmfbsflebcitknhx")
    public suspend fun healthCheckUrl(`value`: Output<String>) {
        this.healthCheckUrl = value
    }

    /**
     * @param value After the health check is successful, the health check status of the backend server is determined from **failed** to **successful**.  Valid values: **2** to **10**.
     */
    @JvmName("xxurrhujwvyvcpac")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value The health check method. Valid values: **GET** or **HEAD**.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("vfvefldevgemprlv")
    public suspend fun httpCheckMethod(`value`: Output<String>) {
        this.httpCheckMethod = value
    }

    /**
     * @param value After the health check fails for many times in a row, the health check status of the backend server is determined from **Success** to **Failure**. Valid values: **2** to **10**.
     */
    @JvmName("qmwvmnawhhmpnlhn")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value The port of the backend server for health checks. Valid values: **0** ~ **65535**. **0** indicates that the port of the backend server is used for health check.
     */
    @JvmName("wsabpyfbbvafcdap")
    public suspend fun healthCheckConnectPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConnectPort = mapped
    }

    /**
     * @param value Maximum timeout for health check responses. Unit: seconds. Valid values: **1** ~ **300**.
     */
    @JvmName("qbdmbydrwuuijjra")
    public suspend fun healthCheckConnectTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConnectTimeout = mapped
    }

    /**
     * @param value The domain name used for health check. Valid values:
     * - **$SERVER_IP**: uses the intranet IP of the backend server.
     * - **domain**: Specify a specific domain name. The length is limited to 1 to 80 characters. Only lowercase letters, numbers, dashes (-), and half-width periods (.) can be used.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("evayrqfidulfgjkp")
    public suspend fun healthCheckDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckDomain = mapped
    }

    /**
     * @param value Whether to enable health check. Valid values:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("rvayjllbtxaiadtr")
    public suspend fun healthCheckEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckEnabled = mapped
    }

    /**
     * @param value Health status return code. Multiple status codes are separated by commas (,). Valid values: **http\_2xx**, **http\_3xx**, **http\_4xx**, and **http\_5xx**.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("hsorowkipnqjbdvc")
    public suspend fun healthCheckHttpCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckHttpCodes = mapped
    }

    /**
     * @param values Health status return code. Multiple status codes are separated by commas (,). Valid values: **http\_2xx**, **http\_3xx**, **http\_4xx**, and **http\_5xx**.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("mrbmtlopwmrupkof")
    public suspend fun healthCheckHttpCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckHttpCodes = mapped
    }

    /**
     * @param value Time interval of health examination. Unit: seconds.  Valid values: **5** ~ **50**.
     */
    @JvmName("wvsprnttdwkwadca")
    public suspend fun healthCheckInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckInterval = mapped
    }

    /**
     * @param value Health check protocol. Valid values: **TCP** or **HTTP**.
     */
    @JvmName("epvqptvucfcvcqlt")
    public suspend fun healthCheckType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckType = mapped
    }

    /**
     * @param value Health check path.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("rtymvuojijtryqse")
    public suspend fun healthCheckUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckUrl = mapped
    }

    /**
     * @param value After the health check is successful, the health check status of the backend server is determined from **failed** to **successful**.  Valid values: **2** to **10**.
     */
    @JvmName("kqunqsmyljehgpnh")
    public suspend fun healthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value The health check method. Valid values: **GET** or **HEAD**.
     * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
     */
    @JvmName("rojkcqjfxnjvhsek")
    public suspend fun httpCheckMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpCheckMethod = mapped
    }

    /**
     * @param value After the health check fails for many times in a row, the health check status of the backend server is determined from **Success** to **Failure**. Valid values: **2** to **10**.
     */
    @JvmName("jejeuqlurdoghmbb")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): ServerGroupHealthCheckArgs = ServerGroupHealthCheckArgs(
        healthCheckConnectPort = healthCheckConnectPort,
        healthCheckConnectTimeout = healthCheckConnectTimeout,
        healthCheckDomain = healthCheckDomain,
        healthCheckEnabled = healthCheckEnabled,
        healthCheckHttpCodes = healthCheckHttpCodes,
        healthCheckInterval = healthCheckInterval,
        healthCheckType = healthCheckType,
        healthCheckUrl = healthCheckUrl,
        healthyThreshold = healthyThreshold,
        httpCheckMethod = httpCheckMethod,
        unhealthyThreshold = unhealthyThreshold,
    )
}
