@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alpnEnabled ndicates whether Application-Layer Protocol Negotiation (ALPN) is enabled.
 * @property alpnPolicy The ALPN policy.
 * @property caCertificateIds CA certificate list information. Currently, only one CA certificate can be added. **NOTE:** This parameter only takes effect for `TCPSSL` listeners.
 * @property caEnabled Whether to start two-way authentication.
 * @property certificateIds Server certificate list information. Currently, only one server certificate can be added. This parameter only takes effect for `TCPSSL` listeners.
 * @property cps The new connection speed limit for a network-based load balancing instance per second. Valid values: `0` ~ `1000000`. `0` indicates unlimited speed.
 * @property endPort Full port listening end port. Valid values: `0` ~ `65535`. The value of the end port is less than the start port.
 * @property id The ID of the Nlb Listener.
 * @property idleTimeout Connection idle timeout time. Unit: seconds. Valid values: `1` ~ `900`.
 * @property listenerDescription Custom listener name. The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
 * @property listenerId The ID of the listener.
 * @property listenerPort Listening port. Valid values: `0` ~ `65535`. `0`: indicates that full port listening is used. When set to 0, you must configure `StartPort` and `EndPort`.
 * @property listenerProtocol The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
 * @property loadBalancerId The ID of the network-based server load balancer instance.
 * @property mss The maximum segment size of the TCP message. Unit: Bytes. Valid values: `0` ~ `1500`. `0` indicates that the MSS value of the TCP message is not modified. only `TCP` and `TCPSSL` listeners support this field value.
 * @property proxyProtocolEnabled Whether to enable the Proxy Protocol to carry the source address of the client to the backend server.
 * @property secSensorEnabled Indicates whether fine-grained monitoring is enabled.
 * @property securityPolicyId Security policy ID. Support system security policies and custom security policies. Valid values: `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`, or `tls_cipher_policy_1_2_strict_with_1_3`. **Note:** This parameter only takes effect for `TCPSSL` listeners.
 * @property serverGroupId The ID of the server group.
 * @property startPort Full Port listens to the starting port. Valid values: `0` ~ `65535`.
 * @property status The status of the resource.
 */
public data class GetListenersListener(
    public val alpnEnabled: Boolean,
    public val alpnPolicy: String,
    public val caCertificateIds: List<String>,
    public val caEnabled: Boolean,
    public val certificateIds: List<String>,
    public val cps: Int,
    public val endPort: String,
    public val id: String,
    public val idleTimeout: Int,
    public val listenerDescription: String,
    public val listenerId: String,
    public val listenerPort: Int,
    public val listenerProtocol: String,
    public val loadBalancerId: String,
    public val mss: Int,
    public val proxyProtocolEnabled: Boolean,
    public val secSensorEnabled: Boolean,
    public val securityPolicyId: String,
    public val serverGroupId: String,
    public val startPort: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetListenersListener): GetListenersListener = GetListenersListener(
            alpnEnabled = javaType.alpnEnabled(),
            alpnPolicy = javaType.alpnPolicy(),
            caCertificateIds = javaType.caCertificateIds().map({ args0 -> args0 }),
            caEnabled = javaType.caEnabled(),
            certificateIds = javaType.certificateIds().map({ args0 -> args0 }),
            cps = javaType.cps(),
            endPort = javaType.endPort(),
            id = javaType.id(),
            idleTimeout = javaType.idleTimeout(),
            listenerDescription = javaType.listenerDescription(),
            listenerId = javaType.listenerId(),
            listenerPort = javaType.listenerPort(),
            listenerProtocol = javaType.listenerProtocol(),
            loadBalancerId = javaType.loadBalancerId(),
            mss = javaType.mss(),
            proxyProtocolEnabled = javaType.proxyProtocolEnabled(),
            secSensorEnabled = javaType.secSensorEnabled(),
            securityPolicyId = javaType.securityPolicyId(),
            serverGroupId = javaType.serverGroupId(),
            startPort = javaType.startPort(),
            status = javaType.status(),
        )
    }
}
