@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getListeners.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerProtocol
 * @property listeners
 * @property loadBalancerIds
 * @property outputFile
 */
public data class GetListenersResult(
    public val id: String,
    public val ids: List<String>,
    public val listenerProtocol: String? = null,
    public val listeners: List<GetListenersListener>,
    public val loadBalancerIds: List<String>? = null,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetListenersResult): GetListenersResult = GetListenersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerProtocol = javaType.listenerProtocol().map({ args0 -> args0 }).orElse(null),
            listeners = javaType.listeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nlb.kotlin.outputs.GetListenersListener.Companion.toKotlin(args0)
                })
            }),
            loadBalancerIds = javaType.loadBalancerIds().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
