@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property addressIpVersion The IP version.
 * @property addressType The type of IPv4 address used by the NLB instance.
 * @property bandwidthPackageId The ID of the EIP bandwidth plan that is associated with the NLB instance if the NLB instance uses a public IP address.
 * @property createTime The time when the resource was created. The time is displayed in UTC in `yyyy-MM-ddTHH:mm:ssZ` format.
 * @property crossZoneEnabled Indicates whether cross-zone load balancing is enabled for the NLB instance.
 * @property dnsName The domain name of the NLB instance.
 * @property id The ID of the NLB instance.
 * @property ipv6AddressType The type of IPv6 address used by the NLB instance.
 * @property loadBalancerBusinessStatus The business status of the NLB instance.
 * @property loadBalancerId The ID of the NLB instance.
 * @property loadBalancerName The name of the NLB instance.
 * @property loadBalancerType The type of the SLB instance. Only Network is supported, which indicates NLB.
 * @property operationLocks The configuration of the operation lock. This parameter takes effect if LoadBalancerBussinessStatus is Abnormal.
 * @property resourceGroupId The ID of the resource group.
 * @property securityGroupIds The security group to which the NLB instance belongs.
 * @property status The status of the NLB instance.
 * @property tags The tag of the resource.
 * @property vpcId The ID of the VPC where the NLB instance is deployed.
 * @property zoneMappings The zones and the vSwitches in the zones. An NLB instance can be deployed across 2 to 10 zones.
 */
public data class GetLoadBalancersBalancer(
    public val addressIpVersion: String,
    public val addressType: String,
    public val bandwidthPackageId: String,
    public val createTime: String,
    public val crossZoneEnabled: Boolean,
    public val dnsName: String,
    public val id: String,
    public val ipv6AddressType: String,
    public val loadBalancerBusinessStatus: String,
    public val loadBalancerId: String,
    public val loadBalancerName: String,
    public val loadBalancerType: String,
    public val operationLocks: List<GetLoadBalancersBalancerOperationLock>,
    public val resourceGroupId: String,
    public val securityGroupIds: List<String>,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val vpcId: String,
    public val zoneMappings: List<GetLoadBalancersBalancerZoneMapping>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetLoadBalancersBalancer): GetLoadBalancersBalancer = GetLoadBalancersBalancer(
            addressIpVersion = javaType.addressIpVersion(),
            addressType = javaType.addressType(),
            bandwidthPackageId = javaType.bandwidthPackageId(),
            createTime = javaType.createTime(),
            crossZoneEnabled = javaType.crossZoneEnabled(),
            dnsName = javaType.dnsName(),
            id = javaType.id(),
            ipv6AddressType = javaType.ipv6AddressType(),
            loadBalancerBusinessStatus = javaType.loadBalancerBusinessStatus(),
            loadBalancerId = javaType.loadBalancerId(),
            loadBalancerName = javaType.loadBalancerName(),
            loadBalancerType = javaType.loadBalancerType(),
            operationLocks = javaType.operationLocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nlb.kotlin.outputs.GetLoadBalancersBalancerOperationLock.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            zoneMappings = javaType.zoneMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nlb.kotlin.outputs.GetLoadBalancersBalancerZoneMapping.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
