@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationId The ID of the elastic IP address (EIP).
 * @property eniId The ID of the elastic network interface (ENI) attached to the NLB instance.
 * @property ipv6Address The IPv6 address of the NLB instance.
 * @property privateIpv4Address The private IPv4 address used by the NLB instance.
 * @property publicIpv4Address The public IPv4 address used by the NLB instance.
 * @property vswitchId The ID of the vSwitch. By default, you can specify one vSwitch (subnet) in each zone of the NLB instance.
 * @property zoneId The name of the zone.
 */
public data class GetLoadBalancersBalancerZoneMapping(
    public val allocationId: String,
    public val eniId: String,
    public val ipv6Address: String,
    public val privateIpv4Address: String,
    public val publicIpv4Address: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetLoadBalancersBalancerZoneMapping): GetLoadBalancersBalancerZoneMapping = GetLoadBalancersBalancerZoneMapping(
            allocationId = javaType.allocationId(),
            eniId = javaType.eniId(),
            ipv6Address = javaType.ipv6Address(),
            privateIpv4Address = javaType.privateIpv4Address(),
            publicIpv4Address = javaType.publicIpv4Address(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
