@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLoadBalancers.
 * @property addressIpVersion
 * @property addressType
 * @property balancers
 * @property dnsName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property ipv6AddressType
 * @property loadBalancerBusinessStatus
 * @property loadBalancerNames
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property resourceGroupId
 * @property status
 * @property tags
 * @property vpcIds
 * @property zoneId
 */
public data class GetLoadBalancersResult(
    public val addressIpVersion: String? = null,
    public val addressType: String? = null,
    public val balancers: List<GetLoadBalancersBalancer>,
    public val dnsName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val ipv6AddressType: String? = null,
    public val loadBalancerBusinessStatus: String? = null,
    public val loadBalancerNames: List<String>? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcIds: List<String>? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetLoadBalancersResult): GetLoadBalancersResult = GetLoadBalancersResult(
            addressIpVersion = javaType.addressIpVersion().map({ args0 -> args0 }).orElse(null),
            addressType = javaType.addressType().map({ args0 -> args0 }).orElse(null),
            balancers = javaType.balancers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nlb.kotlin.outputs.GetLoadBalancersBalancer.Companion.toKotlin(args0)
                })
            }),
            dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ipv6AddressType = javaType.ipv6AddressType().map({ args0 -> args0 }).orElse(null),
            loadBalancerBusinessStatus = javaType.loadBalancerBusinessStatus().map({ args0 ->
                args0
            }).orElse(null),
            loadBalancerNames = javaType.loadBalancerNames().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcIds = javaType.vpcIds().map({ args0 -> args0 }),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
