@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property ciphers The supported cipher suites, which are determined by the TLS protocol version.
 * @property id The id of the TLS security policy.
 * @property resourceGroupId The ID of the resource group.
 * @property securityPolicyName The name of the TLS security policy.
 * @property status The status of the resource.
 * @property tags A mapping of tags to assign to the resource.
 * @property tlsVersions The TLS protocol versions that are supported.
 */
public data class GetSecurityPoliciesPolicy(
    public val ciphers: List<String>,
    public val id: String,
    public val resourceGroupId: String,
    public val securityPolicyName: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val tlsVersions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetSecurityPoliciesPolicy): GetSecurityPoliciesPolicy = GetSecurityPoliciesPolicy(
            ciphers = javaType.ciphers().map({ args0 -> args0 }),
            id = javaType.id(),
            resourceGroupId = javaType.resourceGroupId(),
            securityPolicyName = javaType.securityPolicyName(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tlsVersions = javaType.tlsVersions().map({ args0 -> args0 }),
        )
    }
}
