@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the backend server.
 * @property id The ID of the server group.
 * @property port The port used by the backend server.
 * @property serverGroupId The ID of the server group.
 * @property serverId The ID of the server.
 * @property serverIp The IP address of the backend server.
 * @property serverType The type of the backend server.
 * @property status Indicates the status of the backend server.
 * @property weight The weight of the backend server.
 * @property zoneId The zone ID of the server.
 */
public data class GetServerGroupServerAttachmentsAttachment(
    public val description: String,
    public val id: String,
    public val port: Int,
    public val serverGroupId: String,
    public val serverId: String,
    public val serverIp: String,
    public val serverType: String,
    public val status: String,
    public val weight: Int,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetServerGroupServerAttachmentsAttachment): GetServerGroupServerAttachmentsAttachment = GetServerGroupServerAttachmentsAttachment(
            description = javaType.description(),
            id = javaType.id(),
            port = javaType.port(),
            serverGroupId = javaType.serverGroupId(),
            serverId = javaType.serverId(),
            serverIp = javaType.serverIp(),
            serverType = javaType.serverType(),
            status = javaType.status(),
            weight = javaType.weight(),
            zoneId = javaType.zoneId(),
        )
    }
}
