@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerGroupServerAttachments.
 * @property attachments
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property serverGroupId
 * @property serverIds
 * @property serverIps
 */
public data class GetServerGroupServerAttachmentsResult(
    public val attachments: List<GetServerGroupServerAttachmentsAttachment>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val serverGroupId: String? = null,
    public val serverIds: List<String>? = null,
    public val serverIps: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetServerGroupServerAttachmentsResult): GetServerGroupServerAttachmentsResult = GetServerGroupServerAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nlb.kotlin.outputs.GetServerGroupServerAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            serverGroupId = javaType.serverGroupId().map({ args0 -> args0 }).orElse(null),
            serverIds = javaType.serverIds().map({ args0 -> args0 }),
            serverIps = javaType.serverIps().map({ args0 -> args0 }),
        )
    }
}
