@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property addressIpVersion The protocol version.
 * @property connectionDrain Indicates whether connection draining is enabled.
 * @property connectionDrainTimeout The timeout period of connection draining. Unit: seconds.
 * @property healthChecks The configurations of health checks.
 * @property id The ID of the Server Group.
 * @property preserveClientIpEnabled Indicates whether client address retention is enabled.
 * @property protocol The protocol used to forward requests to the backend servers.
 * @property relatedLoadBalancerIds The NLB instance.
 * @property resourceGroupId The ID of the resource group to which the security group belongs.
 * @property scheduler The routing algorithm.
 * @property serverCount The number of server groups associated with the NLB instance.
 * @property serverGroupName The name of the server group.
 * @property serverGroupType The type of the server group.
 * @property status The status of the server group.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The ID of the VPC to which the server group belongs.
 */
public data class GetServerGroupsGroup(
    public val addressIpVersion: String,
    public val connectionDrain: Boolean,
    public val connectionDrainTimeout: Int,
    public val healthChecks: List<GetServerGroupsGroupHealthCheck>,
    public val id: String,
    public val preserveClientIpEnabled: Boolean,
    public val protocol: String,
    public val relatedLoadBalancerIds: List<String>,
    public val resourceGroupId: String,
    public val scheduler: String,
    public val serverCount: Int,
    public val serverGroupName: String,
    public val serverGroupType: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetServerGroupsGroup): GetServerGroupsGroup = GetServerGroupsGroup(
            addressIpVersion = javaType.addressIpVersion(),
            connectionDrain = javaType.connectionDrain(),
            connectionDrainTimeout = javaType.connectionDrainTimeout(),
            healthChecks = javaType.healthChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nlb.kotlin.outputs.GetServerGroupsGroupHealthCheck.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            preserveClientIpEnabled = javaType.preserveClientIpEnabled(),
            protocol = javaType.protocol(),
            relatedLoadBalancerIds = javaType.relatedLoadBalancerIds().map({ args0 -> args0 }),
            resourceGroupId = javaType.resourceGroupId(),
            scheduler = javaType.scheduler(),
            serverCount = javaType.serverCount(),
            serverGroupName = javaType.serverGroupName(),
            serverGroupType = javaType.serverGroupType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
