@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property healthCheckConnectPort The backend port that is used for health checks.
 * @property healthCheckConnectTimeout The maximum timeout period of a health check response.
 * @property healthCheckDomain The domain name that is used for health checks.
 * @property healthCheckEnabled Specifies whether to enable health checks.
 * @property healthCheckHttpCodes The HTTP status codes returned for health checks.
 * @property healthCheckInterval The interval between two consecutive health checks.
 * @property healthCheckType The protocol that is used for health checks.
 * @property healthCheckUrl The path to which health check requests are sent.
 * @property healthyThreshold The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy.
 * @property httpCheckMethod The HTTP method that is used for health checks.
 * @property unhealthyThreshold The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy.
 */
public data class GetServerGroupsGroupHealthCheck(
    public val healthCheckConnectPort: Int,
    public val healthCheckConnectTimeout: Int,
    public val healthCheckDomain: String,
    public val healthCheckEnabled: Boolean,
    public val healthCheckHttpCodes: List<String>,
    public val healthCheckInterval: Int,
    public val healthCheckType: String,
    public val healthCheckUrl: String,
    public val healthyThreshold: Int,
    public val httpCheckMethod: String,
    public val unhealthyThreshold: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.GetServerGroupsGroupHealthCheck): GetServerGroupsGroupHealthCheck = GetServerGroupsGroupHealthCheck(
            healthCheckConnectPort = javaType.healthCheckConnectPort(),
            healthCheckConnectTimeout = javaType.healthCheckConnectTimeout(),
            healthCheckDomain = javaType.healthCheckDomain(),
            healthCheckEnabled = javaType.healthCheckEnabled(),
            healthCheckHttpCodes = javaType.healthCheckHttpCodes().map({ args0 -> args0 }),
            healthCheckInterval = javaType.healthCheckInterval(),
            healthCheckType = javaType.healthCheckType(),
            healthCheckUrl = javaType.healthCheckUrl(),
            healthyThreshold = javaType.healthyThreshold(),
            httpCheckMethod = javaType.httpCheckMethod(),
            unhealthyThreshold = javaType.unhealthyThreshold(),
        )
    }
}
