@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationId The ID of the elastic IP address.
 * @property eniId The ID of ENI.
 * @property ipv6Address The IPv6 address of a network-based server load balancer instance.
 * @property privateIpv4Address The private IPv4 address of a network-based server load balancer instance.
 * @property publicIpv4Address Public IPv4 address of a network-based server load balancer instance.
 * @property status Zone Status.
 * @property vswitchId The switch corresponding to the zone. Each zone uses one switch and one subnet by default.
 * @property zoneId The name of the zone. You can call the DescribeZones operation to obtain the name of the zone.
 */
public data class LoadBalancerZoneMapping(
    public val allocationId: String? = null,
    public val eniId: String? = null,
    public val ipv6Address: String? = null,
    public val privateIpv4Address: String? = null,
    public val publicIpv4Address: String? = null,
    public val status: String? = null,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.LoadBalancerZoneMapping): LoadBalancerZoneMapping = LoadBalancerZoneMapping(
            allocationId = javaType.allocationId().map({ args0 -> args0 }).orElse(null),
            eniId = javaType.eniId().map({ args0 -> args0 }).orElse(null),
            ipv6Address = javaType.ipv6Address().map({ args0 -> args0 }).orElse(null),
            privateIpv4Address = javaType.privateIpv4Address().map({ args0 -> args0 }).orElse(null),
            publicIpv4Address = javaType.publicIpv4Address().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
