@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property healthCheckConnectPort The port of the backend server for health checks. Valid values: **0** ~ **65535**. **0** indicates that the port of the backend server is used for health check.
 * @property healthCheckConnectTimeout Maximum timeout for health check responses. Unit: seconds. Valid values: **1** ~ **300**.
 * @property healthCheckDomain The domain name used for health check. Valid values:
 * - **$SERVER_IP**: uses the intranet IP of the backend server.
 * - **domain**: Specify a specific domain name. The length is limited to 1 to 80 characters. Only lowercase letters, numbers, dashes (-), and half-width periods (.) can be used.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property healthCheckEnabled Whether to enable health check. Valid values:
 * - **true**: on.
 * - **false**: closed.
 * @property healthCheckHttpCodes Health status return code. Multiple status codes are separated by commas (,). Valid values: **http\_2xx**, **http\_3xx**, **http\_4xx**, and **http\_5xx**.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property healthCheckInterval Time interval of health examination. Unit: seconds.  Valid values: **5** ~ **50**.
 * @property healthCheckType Health check protocol. Valid values: **TCP** or **HTTP**.
 * @property healthCheckUrl Health check path.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property healthyThreshold After the health check is successful, the health check status of the backend server is determined from **failed** to **successful**.  Valid values: **2** to **10**.
 * @property httpCheckMethod The health check method. Valid values: **GET** or **HEAD**.
 * > **NOTE:**  This parameter takes effect only when **HealthCheckType** is **HTTP**.
 * @property unhealthyThreshold After the health check fails for many times in a row, the health check status of the backend server is determined from **Success** to **Failure**. Valid values: **2** to **10**.
 */
public data class ServerGroupHealthCheck(
    public val healthCheckConnectPort: Int? = null,
    public val healthCheckConnectTimeout: Int? = null,
    public val healthCheckDomain: String? = null,
    public val healthCheckEnabled: Boolean? = null,
    public val healthCheckHttpCodes: List<String>? = null,
    public val healthCheckInterval: Int? = null,
    public val healthCheckType: String? = null,
    public val healthCheckUrl: String? = null,
    public val healthyThreshold: Int? = null,
    public val httpCheckMethod: String? = null,
    public val unhealthyThreshold: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nlb.outputs.ServerGroupHealthCheck): ServerGroupHealthCheck = ServerGroupHealthCheck(
            healthCheckConnectPort = javaType.healthCheckConnectPort().map({ args0 -> args0 }).orElse(null),
            healthCheckConnectTimeout = javaType.healthCheckConnectTimeout().map({ args0 ->
                args0
            }).orElse(null),
            healthCheckDomain = javaType.healthCheckDomain().map({ args0 -> args0 }).orElse(null),
            healthCheckEnabled = javaType.healthCheckEnabled().map({ args0 -> args0 }).orElse(null),
            healthCheckHttpCodes = javaType.healthCheckHttpCodes().map({ args0 -> args0 }),
            healthCheckInterval = javaType.healthCheckInterval().map({ args0 -> args0 }).orElse(null),
            healthCheckType = javaType.healthCheckType().map({ args0 -> args0 }).orElse(null),
            healthCheckUrl = javaType.healthCheckUrl().map({ args0 -> args0 }).orElse(null),
            healthyThreshold = javaType.healthyThreshold().map({ args0 -> args0 }).orElse(null),
            httpCheckMethod = javaType.httpCheckMethod().map({ args0 -> args0 }).orElse(null),
            unhealthyThreshold = javaType.unhealthyThreshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
