@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ocean.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BaseInstance].
 */
@PulumiTagMarker
public class BaseInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BaseInstanceArgs = BaseInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BaseInstanceArgsBuilder.() -> Unit) {
        val builder = BaseInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BaseInstance {
        val builtJavaResource = com.pulumi.alicloud.ocean.BaseInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BaseInstance(builtJavaResource)
    }
}

/**
 * Provides a Ocean Base Instance resource.
 * For information about Ocean Base Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/what-is-oceanbase-database).
 * > **NOTE:** Available since v1.203.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({});
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
 * const defaultBaseInstance = new alicloud.ocean.BaseInstance("default", {
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 *     zones: [
 *         Promise.all([_default, _default&#46;then(_default => _default&#46;ids)&#46;length])&#46;then(([_default, length]) => _default&#46;ids[length - 2]),
 *         Promise.all([_default, _default&#46;then(_default => _default&#46;ids)&#46;length])&#46;then(([_default, length]) => _default&#46;ids[length - 3]),
 *         Promise.all([_default, _default&#46;then(_default => _default&#46;ids)&#46;length])&#46;then(([_default, length]) => _default&#46;ids[length - 4]),
 *     ],
 *     autoRenew: false,
 *     diskSize: 100,
 *     paymentType: "PayAsYouGo",
 *     instanceClass: "8C32GB",
 *     backupRetainMode: "delete_all",
 *     series: "normal",
 *     instanceName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones()
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
 * default_base_instance = alicloud.ocean.BaseInstance("default",
 *     resource_group_id=default_get_resource_groups.ids[0],
 *     zones=[
 *         default.ids[len(default&#46;ids) - 2],
 *         default.ids[len(default&#46;ids) - 3],
 *         default.ids[len(default&#46;ids) - 4],
 *     ],
 *     auto_renew=False,
 *     disk_size=100,
 *     payment_type="PayAsYouGo",
 *     instance_class="8C32GB",
 *     backup_retain_mode="delete_all",
 *     series="normal",
 *     instance_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke();
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultBaseInstance = new AliCloud.Ocean.BaseInstance("default", new()
 *     {
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *         Zones = new[]
 *         {
 *             Output.Tuple(@default, @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids)).Length).Apply(values =>
 *             {
 *                 var @default = values.Item1;
 *                 var length = values.Item2;
 *                 return @default.Apply(getZonesResult => getZonesResult.Ids)[length - 2];
 *             }),
 *             Output.Tuple(@default, @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids)).Length).Apply(values =>
 *             {
 *                 var @default = values.Item1;
 *                 var length = values.Item2;
 *                 return @default.Apply(getZonesResult => getZonesResult.Ids)[length - 3];
 *             }),
 *             Output.Tuple(@default, @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids)).Length).Apply(values =>
 *             {
 *                 var @default = values.Item1;
 *                 var length = values.Item2;
 *                 return @default.Apply(getZonesResult => getZonesResult.Ids)[length - 4];
 *             }),
 *         },
 *         AutoRenew = false,
 *         DiskSize = 100,
 *         PaymentType = "PayAsYouGo",
 *         InstanceClass = "8C32GB",
 *         BackupRetainMode = "delete_all",
 *         Series = "normal",
 *         InstanceName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ocean"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ocean.NewBaseInstance(ctx, "default", &ocean.BaseInstanceArgs{
 * 			ResourceGroupId: pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String(_default.Ids[float64(pulumi&#46;Float64(len(_default&#46;Ids))-2)]),
 * 				pulumi.String(_default.Ids[float64(pulumi&#46;Float64(len(_default&#46;Ids))-3)]),
 * 				pulumi.String(_default.Ids[float64(pulumi&#46;Float64(len(_default&#46;Ids))-4)]),
 * 			},
 * 			AutoRenew:        pulumi.Bool(false),
 * 			DiskSize:         pulumi.Int(100),
 * 			PaymentType:      pulumi.String("PayAsYouGo"),
 * 			InstanceClass:    pulumi.String("8C32GB"),
 * 			BackupRetainMode: pulumi.String("delete_all"),
 * 			Series:           pulumi.String("normal"),
 * 			InstanceName:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ocean.BaseInstance;
 * import com.pulumi.alicloud.ocean.BaseInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones();
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultBaseInstance = new BaseInstance("defaultBaseInstance", BaseInstanceArgs.builder()
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .zones(
 *                 default_.ids()[default_&#46;ids()&#46;length() - 2],
 *                 default_.ids()[default_&#46;ids()&#46;length() - 3],
 *                 default_.ids()[default_&#46;ids()&#46;length() - 4])
 *             .autoRenew("false")
 *             .diskSize("100")
 *             .paymentType("PayAsYouGo")
 *             .instanceClass("8C32GB")
 *             .backupRetainMode("delete_all")
 *             .series("normal")
 *             .instanceName(name)
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ocean Base Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ocean/baseInstance:BaseInstance example <id>
 * ```
 */
public class BaseInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.ocean.BaseInstance,
) : KotlinCustomResource(javaResource, BaseInstanceMapper) {
    /**
     * Whether to automatically renew.
     * It takes effect when the parameter ChargeType is PrePaid. Value range:
     * - true: automatic renewal.
     * - false (default): no automatic renewal.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
     * - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
     * - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The backup retention policy after the cluster is deleted. The values are as follows:
     * - receive_all: Keep all backup sets;
     * - delete_all: delete all backup sets;
     * - receive_last: Keep the last backup set.
     * > **NOTE:**   The default value is delete_all.
     */
    public val backupRetainMode: Output<String>?
        get() = javaResource.backupRetainMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The product code of the OceanBase cluster._oceanbasepre_public_cn: Domestic station cloud database package Year-to-month package._oceanbasepost_public_cn: The domestic station cloud database is paid by the hour._obpre_public_intl: International Station Cloud Database Package Monthly Package.
     */
    public val commodityCode: Output<String>
        get() = javaResource.commodityCode().applyValue({ args0 -> args0 })

    /**
     * The number of CPU cores of the cluster.
     */
    public val cpu: Output<Int>
        get() = javaResource.cpu().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The size of the storage space, in GB.
     * The limits of storage space vary according to the cluster specifications, as follows:
     * - 8C32GB:100GB ~ 10000GB
     * - 14C70GB:200GB ~ 10000GB
     * - 30C180GB:400GB ~ 10000GB
     * - 62C400G:800GB ~ 10000GB.
     * The default value of each package is its minimum value.
     */
    public val diskSize: Output<Int>
        get() = javaResource.diskSize().applyValue({ args0 -> args0 })

    /**
     * The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
     * Two types are currently supported:
     * - cloud_essd_pl1: cloud disk ESSD pl1.
     * - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
     */
    public val diskType: Output<String>
        get() = javaResource.diskType().applyValue({ args0 -> args0 })

    /**
     * Cluster specification information.
     * Four packages are currently supported:
     * - 4C16GB：4cores 16GB
     * - 8C32GB：8cores 32GB
     * - 14C70GB：14cores 70GB
     * - 24C120GB：24cores 120GB
     * - 30C180GB：30cores 180GB
     * - 62C400GB：62cores 400GB
     * - 104C600GB：104cores 600GB
     * - 16C70GB：16cores 70GB
     * - 32C160GB：32cores 160GB
     * - 64C380GB：64cores 380GB
     * - 20C32GB：20cores 32GB
     * - 40C64GB：40cores 64GB
     * - 16C32GB：16cores 32GB
     * - 32C70GB：32cores 70GB
     * - 64C180GB：64cores 180GB
     * - 32C180GB：32cores 180GB
     * - 64C400GB：64cores 400GB.
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
     */
    public val nodeNum: Output<String>
        get() = javaResource.nodeNum().applyValue({ args0 -> args0 })

    /**
     * The OceanBase Server version number.
     */
    public val obVersion: Output<String>
        get() = javaResource.obVersion().applyValue({ args0 -> args0 })

    /**
     * The payment method of the instance. Value range:
     * - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
     * - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the enterprise resource group to which the instance resides.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
     */
    public val series: Output<String>
        get() = javaResource.series().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Information about the zone where the cluster is deployed.
     */
    public val zones: Output<List<String>>
        get() = javaResource.zones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object BaseInstanceMapper : ResourceMapper<BaseInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ocean.BaseInstance::class == javaResource::class

    override fun map(javaResource: Resource): BaseInstance = BaseInstance(
        javaResource as
            com.pulumi.alicloud.ocean.BaseInstance,
    )
}

/**
 * @see [BaseInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BaseInstance].
 */
public suspend fun baseInstance(
    name: String,
    block: suspend BaseInstanceResourceBuilder.() -> Unit,
): BaseInstance {
    val builder = BaseInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BaseInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun baseInstance(name: String): BaseInstance {
    val builder = BaseInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
