@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ocean.kotlin

import com.pulumi.alicloud.ocean.BaseInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Ocean Base Instance resource.
 * For information about Ocean Base Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/what-is-oceanbase-database).
 * > **NOTE:** Available since v1.203.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({});
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
 * const defaultBaseInstance = new alicloud.ocean.BaseInstance("default", {
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 *     zones: [
 *         Promise.all([_default, _default&#46;then(_default => _default&#46;ids)&#46;length])&#46;then(([_default, length]) => _default&#46;ids[length - 2]),
 *         Promise.all([_default, _default&#46;then(_default => _default&#46;ids)&#46;length])&#46;then(([_default, length]) => _default&#46;ids[length - 3]),
 *         Promise.all([_default, _default&#46;then(_default => _default&#46;ids)&#46;length])&#46;then(([_default, length]) => _default&#46;ids[length - 4]),
 *     ],
 *     autoRenew: false,
 *     diskSize: 100,
 *     paymentType: "PayAsYouGo",
 *     instanceClass: "8C32GB",
 *     backupRetainMode: "delete_all",
 *     series: "normal",
 *     instanceName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones()
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
 * default_base_instance = alicloud.ocean.BaseInstance("default",
 *     resource_group_id=default_get_resource_groups.ids[0],
 *     zones=[
 *         default.ids[len(default&#46;ids) - 2],
 *         default.ids[len(default&#46;ids) - 3],
 *         default.ids[len(default&#46;ids) - 4],
 *     ],
 *     auto_renew=False,
 *     disk_size=100,
 *     payment_type="PayAsYouGo",
 *     instance_class="8C32GB",
 *     backup_retain_mode="delete_all",
 *     series="normal",
 *     instance_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke();
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultBaseInstance = new AliCloud.Ocean.BaseInstance("default", new()
 *     {
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *         Zones = new[]
 *         {
 *             Output.Tuple(@default, @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids)).Length).Apply(values =>
 *             {
 *                 var @default = values.Item1;
 *                 var length = values.Item2;
 *                 return @default.Apply(getZonesResult => getZonesResult.Ids)[length - 2];
 *             }),
 *             Output.Tuple(@default, @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids)).Length).Apply(values =>
 *             {
 *                 var @default = values.Item1;
 *                 var length = values.Item2;
 *                 return @default.Apply(getZonesResult => getZonesResult.Ids)[length - 3];
 *             }),
 *             Output.Tuple(@default, @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids)).Length).Apply(values =>
 *             {
 *                 var @default = values.Item1;
 *                 var length = values.Item2;
 *                 return @default.Apply(getZonesResult => getZonesResult.Ids)[length - 4];
 *             }),
 *         },
 *         AutoRenew = false,
 *         DiskSize = 100,
 *         PaymentType = "PayAsYouGo",
 *         InstanceClass = "8C32GB",
 *         BackupRetainMode = "delete_all",
 *         Series = "normal",
 *         InstanceName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ocean"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ocean.NewBaseInstance(ctx, "default", &ocean.BaseInstanceArgs{
 * 			ResourceGroupId: pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String(_default.Ids[float64(pulumi&#46;Float64(len(_default&#46;Ids))-2)]),
 * 				pulumi.String(_default.Ids[float64(pulumi&#46;Float64(len(_default&#46;Ids))-3)]),
 * 				pulumi.String(_default.Ids[float64(pulumi&#46;Float64(len(_default&#46;Ids))-4)]),
 * 			},
 * 			AutoRenew:        pulumi.Bool(false),
 * 			DiskSize:         pulumi.Int(100),
 * 			PaymentType:      pulumi.String("PayAsYouGo"),
 * 			InstanceClass:    pulumi.String("8C32GB"),
 * 			BackupRetainMode: pulumi.String("delete_all"),
 * 			Series:           pulumi.String("normal"),
 * 			InstanceName:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ocean.BaseInstance;
 * import com.pulumi.alicloud.ocean.BaseInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones();
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultBaseInstance = new BaseInstance("defaultBaseInstance", BaseInstanceArgs.builder()
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .zones(
 *                 default_.ids()[default_&#46;ids()&#46;length() - 2],
 *                 default_.ids()[default_&#46;ids()&#46;length() - 3],
 *                 default_.ids()[default_&#46;ids()&#46;length() - 4])
 *             .autoRenew("false")
 *             .diskSize("100")
 *             .paymentType("PayAsYouGo")
 *             .instanceClass("8C32GB")
 *             .backupRetainMode("delete_all")
 *             .series("normal")
 *             .instanceName(name)
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ocean Base Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ocean/baseInstance:BaseInstance example <id>
 * ```
 * @property autoRenew Whether to automatically renew.
 * It takes effect when the parameter ChargeType is PrePaid. Value range:
 * - true: automatic renewal.
 * - false (default): no automatic renewal.
 * @property autoRenewPeriod The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
 * - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
 * - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
 * @property backupRetainMode The backup retention policy after the cluster is deleted. The values are as follows:
 * - receive_all: Keep all backup sets;
 * - delete_all: delete all backup sets;
 * - receive_last: Keep the last backup set.
 * > **NOTE:**   The default value is delete_all.
 * @property diskSize The size of the storage space, in GB.
 * The limits of storage space vary according to the cluster specifications, as follows:
 * - 8C32GB:100GB ~ 10000GB
 * - 14C70GB:200GB ~ 10000GB
 * - 30C180GB:400GB ~ 10000GB
 * - 62C400G:800GB ~ 10000GB.
 * The default value of each package is its minimum value.
 * @property diskType The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
 * Two types are currently supported:
 * - cloud_essd_pl1: cloud disk ESSD pl1.
 * - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
 * @property instanceClass Cluster specification information.
 * Four packages are currently supported:
 * - 4C16GB：4cores 16GB
 * - 8C32GB：8cores 32GB
 * - 14C70GB：14cores 70GB
 * - 24C120GB：24cores 120GB
 * - 30C180GB：30cores 180GB
 * - 62C400GB：62cores 400GB
 * - 104C600GB：104cores 600GB
 * - 16C70GB：16cores 70GB
 * - 32C160GB：32cores 160GB
 * - 64C380GB：64cores 380GB
 * - 20C32GB：20cores 32GB
 * - 40C64GB：40cores 64GB
 * - 16C32GB：16cores 32GB
 * - 32C70GB：32cores 70GB
 * - 64C180GB：64cores 180GB
 * - 32C180GB：32cores 180GB
 * - 64C400GB：64cores 400GB.
 * @property instanceName OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
 * @property nodeNum The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
 * @property obVersion The OceanBase Server version number.
 * @property paymentType The payment method of the instance. Value range:
 * - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
 * - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
 * @property period The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
 * @property periodUnit The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
 * @property resourceGroupId The ID of the enterprise resource group to which the instance resides.
 * @property series Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
 * @property zones Information about the zone where the cluster is deployed.
 */
public data class BaseInstanceArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val backupRetainMode: Output<String>? = null,
    public val diskSize: Output<Int>? = null,
    public val diskType: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val nodeNum: Output<String>? = null,
    public val obVersion: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val series: Output<String>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ocean.BaseInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ocean.BaseInstanceArgs =
        com.pulumi.alicloud.ocean.BaseInstanceArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .backupRetainMode(backupRetainMode?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .nodeNum(nodeNum?.applyValue({ args0 -> args0 }))
            .obVersion(obVersion?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .series(series?.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BaseInstanceArgs].
 */
@PulumiTagMarker
public class BaseInstanceArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var backupRetainMode: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var diskType: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var nodeNum: Output<String>? = null

    private var obVersion: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var series: Output<String>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Whether to automatically renew.
     * It takes effect when the parameter ChargeType is PrePaid. Value range:
     * - true: automatic renewal.
     * - false (default): no automatic renewal.
     */
    @JvmName("mryvuxwjaheaotar")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
     * - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
     * - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
     */
    @JvmName("ctqbnpvswsgowfmc")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The backup retention policy after the cluster is deleted. The values are as follows:
     * - receive_all: Keep all backup sets;
     * - delete_all: delete all backup sets;
     * - receive_last: Keep the last backup set.
     * > **NOTE:**   The default value is delete_all.
     */
    @JvmName("unxnjvotfiobkmlq")
    public suspend fun backupRetainMode(`value`: Output<String>) {
        this.backupRetainMode = value
    }

    /**
     * @param value The size of the storage space, in GB.
     * The limits of storage space vary according to the cluster specifications, as follows:
     * - 8C32GB:100GB ~ 10000GB
     * - 14C70GB:200GB ~ 10000GB
     * - 30C180GB:400GB ~ 10000GB
     * - 62C400G:800GB ~ 10000GB.
     * The default value of each package is its minimum value.
     */
    @JvmName("jcaujvnpnqwtwaqn")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
     * Two types are currently supported:
     * - cloud_essd_pl1: cloud disk ESSD pl1.
     * - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
     */
    @JvmName("cemexvicohdogahm")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value Cluster specification information.
     * Four packages are currently supported:
     * - 4C16GB：4cores 16GB
     * - 8C32GB：8cores 32GB
     * - 14C70GB：14cores 70GB
     * - 24C120GB：24cores 120GB
     * - 30C180GB：30cores 180GB
     * - 62C400GB：62cores 400GB
     * - 104C600GB：104cores 600GB
     * - 16C70GB：16cores 70GB
     * - 32C160GB：32cores 160GB
     * - 64C380GB：64cores 380GB
     * - 20C32GB：20cores 32GB
     * - 40C64GB：40cores 64GB
     * - 16C32GB：16cores 32GB
     * - 32C70GB：32cores 70GB
     * - 64C180GB：64cores 180GB
     * - 32C180GB：32cores 180GB
     * - 64C400GB：64cores 400GB.
     */
    @JvmName("fissmewdjffjilrn")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
     */
    @JvmName("fleuiuefxedmdwet")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
     */
    @JvmName("iijouttgnxujelhk")
    public suspend fun nodeNum(`value`: Output<String>) {
        this.nodeNum = value
    }

    /**
     * @param value The OceanBase Server version number.
     */
    @JvmName("mnsrvnptjhgqrjgw")
    public suspend fun obVersion(`value`: Output<String>) {
        this.obVersion = value
    }

    /**
     * @param value The payment method of the instance. Value range:
     * - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
     * - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
     */
    @JvmName("yefdtjpibjwcpmqo")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
     */
    @JvmName("pceubxsqrqyalbld")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
     */
    @JvmName("whswytxqeytbjevu")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The ID of the enterprise resource group to which the instance resides.
     */
    @JvmName("laskwmnbtwipcyxl")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
     */
    @JvmName("sipivhlxafdfgnop")
    public suspend fun series(`value`: Output<String>) {
        this.series = value
    }

    /**
     * @param value Information about the zone where the cluster is deployed.
     */
    @JvmName("fnaqsmrgjuokdngj")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("mcolwxerdaipixqy")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Information about the zone where the cluster is deployed.
     */
    @JvmName("thoxywbabidxpcxh")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Whether to automatically renew.
     * It takes effect when the parameter ChargeType is PrePaid. Value range:
     * - true: automatic renewal.
     * - false (default): no automatic renewal.
     */
    @JvmName("ksnjvfsijxioyaec")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The duration of each auto-renewal. When the value of the AutoRenew parameter is True, this parameter is required.
     * - PeriodUnit is Week, AutoRenewPeriod is {"1", "2", "3"}.
     * - PeriodUnit is Month, AutoRenewPeriod is {"1", "2", "3", "6", "12"}.
     */
    @JvmName("tkicaijbeegoqtma")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The backup retention policy after the cluster is deleted. The values are as follows:
     * - receive_all: Keep all backup sets;
     * - delete_all: delete all backup sets;
     * - receive_last: Keep the last backup set.
     * > **NOTE:**   The default value is delete_all.
     */
    @JvmName("qnteqputyecttqxm")
    public suspend fun backupRetainMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetainMode = mapped
    }

    /**
     * @param value The size of the storage space, in GB.
     * The limits of storage space vary according to the cluster specifications, as follows:
     * - 8C32GB:100GB ~ 10000GB
     * - 14C70GB:200GB ~ 10000GB
     * - 30C180GB:400GB ~ 10000GB
     * - 62C400G:800GB ~ 10000GB.
     * The default value of each package is its minimum value.
     */
    @JvmName("rmroiylgmpvnjtfv")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value The storage type of the cluster. Effective only in the standard cluster version (cloud disk).
     * Two types are currently supported:
     * - cloud_essd_pl1: cloud disk ESSD pl1.
     * - cloud_essd_pl0: cloud disk ESSD pl0. The default value is cloud_essd_pl1.
     */
    @JvmName("fnwynwvthuiojrpj")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Cluster specification information.
     * Four packages are currently supported:
     * - 4C16GB：4cores 16GB
     * - 8C32GB：8cores 32GB
     * - 14C70GB：14cores 70GB
     * - 24C120GB：24cores 120GB
     * - 30C180GB：30cores 180GB
     * - 62C400GB：62cores 400GB
     * - 104C600GB：104cores 600GB
     * - 16C70GB：16cores 70GB
     * - 32C160GB：32cores 160GB
     * - 64C380GB：64cores 380GB
     * - 20C32GB：20cores 32GB
     * - 40C64GB：40cores 64GB
     * - 16C32GB：16cores 32GB
     * - 32C70GB：32cores 70GB
     * - 64C180GB：64cores 180GB
     * - 32C180GB：32cores 180GB
     * - 64C400GB：64cores 400GB.
     */
    @JvmName("mhugviydwgwqecpc")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value OceanBase cluster name.The length is 1 to 20 English or Chinese characters.If this parameter is not specified, the default value is the InstanceId of the cluster.
     */
    @JvmName("wtyxbibxogexsbku")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The number of nodes in the cluster. If the deployment mode is n-n-n, the number of nodes is n * 3.
     */
    @JvmName("jefdnvmoqwitknga")
    public suspend fun nodeNum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeNum = mapped
    }

    /**
     * @param value The OceanBase Server version number.
     */
    @JvmName("nfgfyvnouxvhhucs")
    public suspend fun obVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.obVersion = mapped
    }

    /**
     * @param value The payment method of the instance. Value range:
     * - Subscription: Package year and month. When you select this type of payment method, you must make sure that your account supports balance payment or credit payment. Otherwise, an InvalidPayMethod error message will be returned.
     * - PayAsYouGo (default): Pay-as-you-go (default hourly billing).
     */
    @JvmName("jmhjpstlhuiacmfd")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration of the resource purchase. The unit is specified by the PeriodUnit. The parameter InstanceChargeType takes effect only when the value is PrePaid and is required. Once the DedicatedHostId is specified, the value cannot exceed the subscription duration of the dedicated host. When PeriodUnit = Week, Period values: {"1", "2", "3", "4"}. When PeriodUnit = Month, Period values: {"1", "2", "3", "4", "5", "6", "7", "8", "9", "12", "24", "36", "48", "60"}.
     */
    @JvmName("bdkintugrlfpwthy")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The duration of the purchase of resources.Package year and Month value range: Month.Default value: Month of the package, which is billed by volume. The default period is Hour.
     */
    @JvmName("moiibckahesiylig")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The ID of the enterprise resource group to which the instance resides.
     */
    @JvmName("suqjjwpmedtilykm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Series of OceanBase cluster instances-normal (default): Standard cluster version (cloud disk)-normal_SSD: Standard cluster version (local disk)-history: history Library cluster version.
     */
    @JvmName("mquctglwywxbugea")
    public suspend fun series(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.series = mapped
    }

    /**
     * @param value Information about the zone where the cluster is deployed.
     */
    @JvmName("efcvsbvkbdchnfxv")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Information about the zone where the cluster is deployed.
     */
    @JvmName("jpbsjrftdsppfply")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): BaseInstanceArgs = BaseInstanceArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        backupRetainMode = backupRetainMode,
        diskSize = diskSize,
        diskType = diskType,
        instanceClass = instanceClass,
        instanceName = instanceName,
        nodeNum = nodeNum,
        obVersion = obVersion,
        paymentType = paymentType,
        period = period,
        periodUnit = periodUnit,
        resourceGroupId = resourceGroupId,
        series = series,
        zones = zones,
    )
}
