@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ocean.kotlin

import com.pulumi.alicloud.ocean.OceanFunctions.getBaseInstancesPlain
import com.pulumi.alicloud.ocean.kotlin.inputs.GetBaseInstancesPlainArgs
import com.pulumi.alicloud.ocean.kotlin.inputs.GetBaseInstancesPlainArgsBuilder
import com.pulumi.alicloud.ocean.kotlin.outputs.GetBaseInstancesResult
import com.pulumi.alicloud.ocean.kotlin.outputs.GetBaseInstancesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object OceanFunctions {
    /**
     * This data source provides the Ocean Base Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.203.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ocean.getBaseInstances({});
     * export const oceanBaseInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * const nameRegex = alicloud.ocean.getBaseInstances({
     *     nameRegex: "^my-Instance",
     * });
     * export const oceanBaseInstanceId2 = nameRegex.then(nameRegex => nameRegex.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ocean.get_base_instances()
     * pulumi.export("oceanBaseInstanceId1", ids.instances[0].id)
     * name_regex = alicloud.ocean.get_base_instances(name_regex="^my-Instance")
     * pulumi.export("oceanBaseInstanceId2", name_regex.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ocean.GetBaseInstances.Invoke();
     *     var nameRegex = AliCloud.Ocean.GetBaseInstances.Invoke(new()
     *     {
     *         NameRegex = "^my-Instance",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["oceanBaseInstanceId1"] = ids&#46;Apply(getBaseInstancesResult => getBaseInstancesResult&#46;Instances[0]?.Id),
     *         ["oceanBaseInstanceId2"] = nameRegex&#46;Apply(getBaseInstancesResult => getBaseInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ocean"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ocean.GetBaseInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oceanBaseInstanceId1", ids.Instances[0].Id)
     * 		nameRegex, err := ocean.GetBaseInstances(ctx, &ocean.GetBaseInstancesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Instance"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oceanBaseInstanceId2", nameRegex.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ocean.OceanFunctions;
     * import com.pulumi.alicloud.ocean.inputs.GetBaseInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = OceanFunctions.getBaseInstances();
     *         ctx.export("oceanBaseInstanceId1", ids.applyValue(getBaseInstancesResult -> getBaseInstancesResult.instances()[0].id()));
     *         final var nameRegex = OceanFunctions.getBaseInstances(GetBaseInstancesArgs.builder()
     *             .nameRegex("^my-Instance")
     *             .build());
     *         ctx.export("oceanBaseInstanceId2", nameRegex.applyValue(getBaseInstancesResult -> getBaseInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ocean:getBaseInstances
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ocean:getBaseInstances
     *       Arguments:
     *         nameRegex: ^my-Instance
     * outputs:
     *   oceanBaseInstanceId1: ${ids.instances[0].id}
     *   oceanBaseInstanceId2: ${nameRegex.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBaseInstances.
     * @return A collection of values returned by getBaseInstances.
     */
    public suspend fun getBaseInstances(argument: GetBaseInstancesPlainArgs): GetBaseInstancesResult =
        toKotlin(getBaseInstancesPlain(argument.toJava()).await())

    /**
     * @see [getBaseInstances].
     * @param enableDetails
     * @param ids A list of Instance IDs.
     * @param instanceId OceanBase cluster ID.
     * @param instanceName OceanBase cluster name. The length is 1 to 20 English or Chinese characters. If this parameter is not specified, the default value is the InstanceId of the cluster.
     * @param nameRegex A regex string to filter results by Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId The ID of the enterprise resource group to which the instance resides.
     * @param searchKey The filter keyword for the query list.
     * @param status The status of the Instance. Value range: `PENDING_CREATE`, `ONLINE`, `TENANT_CREATING`, `TENANT_SPEC_MODIFYING`, `EXPANDING`, `REDUCING`, `SPEC_UPGRADING`, `DISK_UPGRADING`, `WHITE_LIST_MODIFYING`, `PARAMETER_MODIFYING`, `SSL_MODIFYING`, `PREPAID_EXPIRE_CLOSED`, `ARREARS_CLOSED`, `PENDING_DELETE`.
     * @return A collection of values returned by getBaseInstances.
     */
    public suspend fun getBaseInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        instanceName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        searchKey: String? = null,
        status: String? = null,
    ): GetBaseInstancesResult {
        val argument = GetBaseInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            searchKey = searchKey,
            status = status,
        )
        return toKotlin(getBaseInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBaseInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ocean&#46;kotlin&#46;inputs&#46;GetBaseInstancesPlainArgs].
     * @return A collection of values returned by getBaseInstances.
     */
    public suspend fun getBaseInstances(argument: suspend GetBaseInstancesPlainArgsBuilder.() -> Unit): GetBaseInstancesResult {
        val builder = GetBaseInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getBaseInstancesPlain(builtArgument.toJava()).await())
    }
}
