@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ocean.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commodityCode The product code of the OceanBase cluster.
 * @property cpu The number of CPU cores of the cluster.
 * @property createTime The creation time of the resource.
 * @property diskSize The size of the storage space, in GB.
 * @property id The ID of the Instance.
 * @property instanceClass Cluster specification information.
 * @property instanceId OceanBase cluster ID.
 * @property instanceName OceanBase cluster name.
 * @property nodeNum The number of nodes in the cluster.
 * @property paymentType The payment method of the instance.
 * @property resourceGroupId The ID of the enterprise resource group to which the instance resides.
 * @property series Series of OceanBase clusters.
 * @property status The status of the resource.
 * @property zones Information about the zone where the cluster is deployed.
 */
public data class GetBaseInstancesInstance(
    public val commodityCode: String,
    public val cpu: Int,
    public val createTime: String,
    public val diskSize: String,
    public val id: String,
    public val instanceClass: String,
    public val instanceId: String,
    public val instanceName: String,
    public val nodeNum: String,
    public val paymentType: String,
    public val resourceGroupId: String,
    public val series: String,
    public val status: String,
    public val zones: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ocean.outputs.GetBaseInstancesInstance): GetBaseInstancesInstance = GetBaseInstancesInstance(
            commodityCode = javaType.commodityCode(),
            cpu = javaType.cpu(),
            createTime = javaType.createTime(),
            diskSize = javaType.diskSize(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            nodeNum = javaType.nodeNum(),
            paymentType = javaType.paymentType(),
            resourceGroupId = javaType.resourceGroupId(),
            series = javaType.series(),
            status = javaType.status(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
