@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ocean.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBaseInstances.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property instanceName
 * @property instances
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId
 * @property searchKey
 * @property status
 */
public data class GetBaseInstancesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val instanceName: String? = null,
    public val instances: List<GetBaseInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val searchKey: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ocean.outputs.GetBaseInstancesResult): GetBaseInstancesResult = GetBaseInstancesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            instanceName = javaType.instanceName().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ocean.kotlin.outputs.GetBaseInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            searchKey = javaType.searchKey().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
