@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.ApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a OOS Application resource.
 * For information about OOS Application and how to use it, see [What is Application](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/api-oos-2019-06-01-createapplication).
 * > **NOTE:** Available since v1.145.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultApplication = new alicloud.oos.Application("default", {
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     applicationName: `${name}-${defaultInteger.result}`,
 *     description: name,
 *     tags: {
 *         Created: "TF",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_application = alicloud.oos.Application("default",
 *     resource_group_id=default.groups[0].id,
 *     application_name=f"{name}-{default_integer['result']}",
 *     description=name,
 *     tags={
 *         "Created": "TF",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultApplication = new AliCloud.Oos.Application("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         ApplicationName = $"{name}-{defaultInteger.Result}",
 *         Description = name,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewApplication(ctx, "default", &oos.ApplicationArgs{
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 			ApplicationName: pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			Description:     pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.oos.Application;
 * import com.pulumi.alicloud.oos.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .resourceGroupId(default_.groups()[0].id())
 *             .applicationName(String.format("%s-%s", name,defaultInteger.result()))
 *             .description(name)
 *             .tags(Map.of("Created", "TF"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultApplication:
 *     type: alicloud:oos:Application
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.groups[0].id}
 *       applicationName: ${name}-${defaultInteger.result}
 *       description: ${name}
 *       tags:
 *         Created: TF
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/application:Application example <id>
 * ```
 * @property applicationName The name of the application.
 * @property description Application group description information.
 * @property resourceGroupId The ID of the resource group.
 * @property tags The tag of the resource.
 */
public data class ApplicationArgs(
    public val applicationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.ApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.ApplicationArgs =
        com.pulumi.alicloud.oos.ApplicationArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var description: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the application.
     */
    @JvmName("prhnuahqiywaupoc")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value Application group description information.
     */
    @JvmName("qmxjbyggaoksfasw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("jlucgbyyoxxbolny")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("jcngddxbvrvqhstu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("vyhfbktixjcxencb")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value Application group description information.
     */
    @JvmName("vbuosgnacolmbspg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("lbvxifmvvhbsrlbl")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("cbdqqffkurvdmddp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("kdngcudbdgxrbbiu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationName = applicationName,
        description = description,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
