@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApplicationGroup].
 */
@PulumiTagMarker
public class ApplicationGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationGroupArgs = ApplicationGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationGroupArgsBuilder.() -> Unit) {
        val builder = ApplicationGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationGroup {
        val builtJavaResource = com.pulumi.alicloud.oos.ApplicationGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationGroup(builtJavaResource)
    }
}

/**
 * Provides a OOS Application Group resource.
 * For information about OOS Application Group and how to use it, see [What is Application Group](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/api-oos-2019-06-01-createapplicationgroup).
 * > **NOTE:** Available since v1.146.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultApplication = new alicloud.oos.Application("default", {
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     applicationName: `${name}-${defaultInteger.result}`,
 *     description: name,
 *     tags: {
 *         Created: "TF",
 *     },
 * });
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultApplicationGroup = new alicloud.oos.ApplicationGroup("default", {
 *     applicationGroupName: name,
 *     applicationName: defaultApplication.id,
 *     deployRegionId: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?.id),
 *     description: name,
 *     importTagKey: "example_key",
 *     importTagValue: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_application = alicloud.oos.Application("default",
 *     resource_group_id=default.groups[0].id,
 *     application_name=f"{name}-{default_integer['result']}",
 *     description=name,
 *     tags={
 *         "Created": "TF",
 *     })
 * default_get_regions = alicloud.get_regions(current=True)
 * default_application_group = alicloud.oos.ApplicationGroup("default",
 *     application_group_name=name,
 *     application_name=default_application.id,
 *     deploy_region_id=default_get_regions.regions[0].id,
 *     description=name,
 *     import_tag_key="example_key",
 *     import_tag_value="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultApplication = new AliCloud.Oos.Application("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         ApplicationName = $"{name}-{defaultInteger.Result}",
 *         Description = name,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *         },
 *     });
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultApplicationGroup = new AliCloud.Oos.ApplicationGroup("default", new()
 *     {
 *         ApplicationGroupName = name,
 *         ApplicationName = defaultApplication.Id,
 *         DeployRegionId = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *         Description = name,
 *         ImportTagKey = "example_key",
 *         ImportTagValue = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultApplication, err := oos.NewApplication(ctx, "default", &oos.ApplicationArgs{
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 			ApplicationName: pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			Description:     pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewApplicationGroup(ctx, "default", &oos.ApplicationGroupArgs{
 * 			ApplicationGroupName: pulumi.String(name),
 * 			ApplicationName:      defaultApplication.ID(),
 * 			DeployRegionId:       pulumi.String(defaultGetRegions.Regions[0].Id),
 * 			Description:          pulumi.String(name),
 * 			ImportTagKey:         pulumi.String("example_key"),
 * 			ImportTagValue:       pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.oos.Application;
 * import com.pulumi.alicloud.oos.ApplicationArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.oos.ApplicationGroup;
 * import com.pulumi.alicloud.oos.ApplicationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .resourceGroupId(default_.groups()[0].id())
 *             .applicationName(String.format("%s-%s", name,defaultInteger.result()))
 *             .description(name)
 *             .tags(Map.of("Created", "TF"))
 *             .build());
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultApplicationGroup = new ApplicationGroup("defaultApplicationGroup", ApplicationGroupArgs.builder()
 *             .applicationGroupName(name)
 *             .applicationName(defaultApplication.id())
 *             .deployRegionId(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .description(name)
 *             .importTagKey("example_key")
 *             .importTagValue("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultApplication:
 *     type: alicloud:oos:Application
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.groups[0].id}
 *       applicationName: ${name}-${defaultInteger.result}
 *       description: ${name}
 *       tags:
 *         Created: TF
 *   defaultApplicationGroup:
 *     type: alicloud:oos:ApplicationGroup
 *     name: default
 *     properties:
 *       applicationGroupName: ${name}
 *       applicationName: ${defaultApplication.id}
 *       deployRegionId: ${defaultGetRegions.regions[0].id}
 *       description: ${name}
 *       importTagKey: example_key
 *       importTagValue: example_value
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Application Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/applicationGroup:ApplicationGroup example <application_name>:<application_group_name>
 * ```
 */
public class ApplicationGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.oos.ApplicationGroup,
) : KotlinCustomResource(javaResource, ApplicationGroupMapper) {
    /**
     * The name of the Application group.
     */
    public val applicationGroupName: Output<String>
        get() = javaResource.applicationGroupName().applyValue({ args0 -> args0 })

    /**
     * The name of the Application.
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * The region ID of the deployment.
     */
    public val deployRegionId: Output<String>
        get() = javaResource.deployRegionId().applyValue({ args0 -> args0 })

    /**
     * Application group description information.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tag key must be passed in at the same time as the tag value (import_tag_value) or none, not just one. If both `import_tag_key` and `import_tag_value` are left empty, the default is app-{ApplicationName} (application name).
     */
    public val importTagKey: Output<String>
        get() = javaResource.importTagKey().applyValue({ args0 -> args0 })

    /**
     * The tag value must be passed in at the same time as the tag key (import_tag_key) or none, not just one. If both `import_tag_key` and `import_tag_value` are left empty, the default is application group name.
     * .
     */
    public val importTagValue: Output<String>
        get() = javaResource.importTagValue().applyValue({ args0 -> args0 })
}

public object ApplicationGroupMapper : ResourceMapper<ApplicationGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oos.ApplicationGroup::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationGroup = ApplicationGroup(
        javaResource as
            com.pulumi.alicloud.oos.ApplicationGroup,
    )
}

/**
 * @see [ApplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationGroup].
 */
public suspend fun applicationGroup(
    name: String,
    block: suspend ApplicationGroupResourceBuilder.() -> Unit,
): ApplicationGroup {
    val builder = ApplicationGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationGroup(name: String): ApplicationGroup {
    val builder = ApplicationGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
