@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.DefaultPatchBaselineArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Oos Default Patch Baseline resource.
 * For information about Oos Default Patch Baseline and how to use it, see [What is Default Patch Baseline](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/api-oos-2019-06-01-registerdefaultpatchbaseline).
 * > **NOTE:** Available in v1.203.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.oos.PatchBaseline("default", {
 *     operationSystem: "Windows",
 *     patchBaselineName: "terraform-example",
 *     description: "terraform-example",
 *     approvalRules: "{\"PatchRules\":[{\"PatchFilterGroup\":[{\"Key\":\"PatchSet\",\"Values\":[\"OS\"]},{\"Key\":\"ProductFamily\",\"Values\":[\"Windows\"]},{\"Key\":\"Product\",\"Values\":[\"Windows 10\",\"Windows 7\"]},{\"Key\":\"Classification\",\"Values\":[\"Security Updates\",\"Updates\",\"Update Rollups\",\"Critical Updates\"]},{\"Key\":\"Severity\",\"Values\":[\"Critical\",\"Important\",\"Moderate\"]}],\"ApproveAfterDays\":7,\"EnableNonSecurity\":true,\"ComplianceLevel\":\"Medium\"}]}",
 * });
 * const defaultDefaultPatchBaseline = new alicloud.oos.DefaultPatchBaseline("default", {patchBaselineName: _default.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.oos.PatchBaseline("default",
 *     operation_system="Windows",
 *     patch_baseline_name="terraform-example",
 *     description="terraform-example",
 *     approval_rules="{\"PatchRules\":[{\"PatchFilterGroup\":[{\"Key\":\"PatchSet\",\"Values\":[\"OS\"]},{\"Key\":\"ProductFamily\",\"Values\":[\"Windows\"]},{\"Key\":\"Product\",\"Values\":[\"Windows 10\",\"Windows 7\"]},{\"Key\":\"Classification\",\"Values\":[\"Security Updates\",\"Updates\",\"Update Rollups\",\"Critical Updates\"]},{\"Key\":\"Severity\",\"Values\":[\"Critical\",\"Important\",\"Moderate\"]}],\"ApproveAfterDays\":7,\"EnableNonSecurity\":true,\"ComplianceLevel\":\"Medium\"}]}")
 * default_default_patch_baseline = alicloud.oos.DefaultPatchBaseline("default", patch_baseline_name=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Oos.PatchBaseline("default", new()
 *     {
 *         OperationSystem = "Windows",
 *         PatchBaselineName = "terraform-example",
 *         Description = "terraform-example",
 *         ApprovalRules = "{\"PatchRules\":[{\"PatchFilterGroup\":[{\"Key\":\"PatchSet\",\"Values\":[\"OS\"]},{\"Key\":\"ProductFamily\",\"Values\":[\"Windows\"]},{\"Key\":\"Product\",\"Values\":[\"Windows 10\",\"Windows 7\"]},{\"Key\":\"Classification\",\"Values\":[\"Security Updates\",\"Updates\",\"Update Rollups\",\"Critical Updates\"]},{\"Key\":\"Severity\",\"Values\":[\"Critical\",\"Important\",\"Moderate\"]}],\"ApproveAfterDays\":7,\"EnableNonSecurity\":true,\"ComplianceLevel\":\"Medium\"}]}",
 *     });
 *     var defaultDefaultPatchBaseline = new AliCloud.Oos.DefaultPatchBaseline("default", new()
 *     {
 *         PatchBaselineName = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oos.NewPatchBaseline(ctx, "default", &oos.PatchBaselineArgs{
 * 			OperationSystem:   pulumi.String("Windows"),
 * 			PatchBaselineName: pulumi.String("terraform-example"),
 * 			Description:       pulumi.String("terraform-example"),
 * 			ApprovalRules:     pulumi.String("{\"PatchRules\":[{\"PatchFilterGroup\":[{\"Key\":\"PatchSet\",\"Values\":[\"OS\"]},{\"Key\":\"ProductFamily\",\"Values\":[\"Windows\"]},{\"Key\":\"Product\",\"Values\":[\"Windows 10\",\"Windows 7\"]},{\"Key\":\"Classification\",\"Values\":[\"Security Updates\",\"Updates\",\"Update Rollups\",\"Critical Updates\"]},{\"Key\":\"Severity\",\"Values\":[\"Critical\",\"Important\",\"Moderate\"]}],\"ApproveAfterDays\":7,\"EnableNonSecurity\":true,\"ComplianceLevel\":\"Medium\"}]}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewDefaultPatchBaseline(ctx, "default", &oos.DefaultPatchBaselineArgs{
 * 			PatchBaselineName: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oos.PatchBaseline;
 * import com.pulumi.alicloud.oos.PatchBaselineArgs;
 * import com.pulumi.alicloud.oos.DefaultPatchBaseline;
 * import com.pulumi.alicloud.oos.DefaultPatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new PatchBaseline("default", PatchBaselineArgs.builder()
 *             .operationSystem("Windows")
 *             .patchBaselineName("terraform-example")
 *             .description("terraform-example")
 *             .approvalRules("{\"PatchRules\":[{\"PatchFilterGroup\":[{\"Key\":\"PatchSet\",\"Values\":[\"OS\"]},{\"Key\":\"ProductFamily\",\"Values\":[\"Windows\"]},{\"Key\":\"Product\",\"Values\":[\"Windows 10\",\"Windows 7\"]},{\"Key\":\"Classification\",\"Values\":[\"Security Updates\",\"Updates\",\"Update Rollups\",\"Critical Updates\"]},{\"Key\":\"Severity\",\"Values\":[\"Critical\",\"Important\",\"Moderate\"]}],\"ApproveAfterDays\":7,\"EnableNonSecurity\":true,\"ComplianceLevel\":\"Medium\"}]}")
 *             .build());
 *         var defaultDefaultPatchBaseline = new DefaultPatchBaseline("defaultDefaultPatchBaseline", DefaultPatchBaselineArgs.builder()
 *             .patchBaselineName(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:oos:PatchBaseline
 *     properties:
 *       operationSystem: Windows
 *       patchBaselineName: terraform-example
 *       description: terraform-example
 *       approvalRules: '{"PatchRules":[{"PatchFilterGroup":[{"Key":"PatchSet","Values":["OS"]},{"Key":"ProductFamily","Values":["Windows"]},{"Key":"Product","Values":["Windows 10","Windows 7"]},{"Key":"Classification","Values":["Security Updates","Updates","Update Rollups","Critical Updates"]},{"Key":"Severity","Values":["Critical","Important","Moderate"]}],"ApproveAfterDays":7,"EnableNonSecurity":true,"ComplianceLevel":"Medium"}]}'
 *   defaultDefaultPatchBaseline:
 *     type: alicloud:oos:DefaultPatchBaseline
 *     name: default
 *     properties:
 *       patchBaselineName: ${default.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Oos Default Patch Baseline can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/defaultPatchBaseline:DefaultPatchBaseline example <id>
 * ```
 * @property patchBaselineName The name of the patch baseline.
 */
public data class DefaultPatchBaselineArgs(
    public val patchBaselineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.DefaultPatchBaselineArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.DefaultPatchBaselineArgs =
        com.pulumi.alicloud.oos.DefaultPatchBaselineArgs.builder()
            .patchBaselineName(patchBaselineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultPatchBaselineArgs].
 */
@PulumiTagMarker
public class DefaultPatchBaselineArgsBuilder internal constructor() {
    private var patchBaselineName: Output<String>? = null

    /**
     * @param value The name of the patch baseline.
     */
    @JvmName("fakaxykjavmchwea")
    public suspend fun patchBaselineName(`value`: Output<String>) {
        this.patchBaselineName = value
    }

    /**
     * @param value The name of the patch baseline.
     */
    @JvmName("hpehbdckamkvuxdp")
    public suspend fun patchBaselineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchBaselineName = mapped
    }

    internal fun build(): DefaultPatchBaselineArgs = DefaultPatchBaselineArgs(
        patchBaselineName = patchBaselineName,
    )
}
