@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Execution].
 */
@PulumiTagMarker
public class ExecutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExecutionArgs = ExecutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExecutionArgsBuilder.() -> Unit) {
        val builder = ExecutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Execution {
        val builtJavaResource = com.pulumi.alicloud.oos.Execution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Execution(builtJavaResource)
    }
}

/**
 * Provides a OOS Execution resource. For information about Alicloud OOS Execution and how to use it, see [What is Resource Alicloud OOS Execution](https://www.alibabacloud.com/help/doc-detail/120771.htm).
 * > **NOTE:** Available in 1.93.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.oos.Template("default", {
 *     content: `  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `,
 *     templateName: "test-name",
 *     versionName: "test",
 *     tags: {
 *         Created: "TF",
 *         For: "acceptance Test",
 *     },
 * });
 * const example = new alicloud.oos.Execution("example", {
 *     templateName: _default.templateName,
 *     description: "From TF Test",
 *     parameters: "\x09\x09\x09\x09{\"Status\":\"Running\"}\n",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.oos.Template("default",
 *     content="""  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * """,
 *     template_name="test-name",
 *     version_name="test",
 *     tags={
 *         "Created": "TF",
 *         "For": "acceptance Test",
 *     })
 * example = alicloud.oos.Execution("example",
 *     template_name=default.template_name,
 *     description="From TF Test",
 *     parameters="\x09\x09\x09\x09{\"Status\":\"Running\"}\n")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Oos.Template("default", new()
 *     {
 *         Content = @"  {
 *     ""FormatVersion"": ""OOS-2019-06-01"",
 *     ""Description"": ""Update Describe instances of given status"",
 *     ""Parameters"":{
 *       ""Status"":{
 *         ""Type"": ""String"",
 *         ""Description"": ""(Required) The status of the Ecs instance.""
 *       }
 *     },
 *     ""Tasks"": [
 *       {
 *         ""Properties"" :{
 *           ""Parameters"":{
 *             ""Status"": ""{{ Status }}""
 *           },
 *           ""API"": ""DescribeInstances"",
 *           ""Service"": ""Ecs""
 *         },
 *         ""Name"": ""foo"",
 *         ""Action"": ""ACS::ExecuteApi""
 *       }]
 *   }
 * ",
 *         TemplateName = "test-name",
 *         VersionName = "test",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "acceptance Test" },
 *         },
 *     });
 *     var example = new AliCloud.Oos.Execution("example", new()
 *     {
 *         TemplateName = @default.TemplateName,
 *         Description = "From TF Test",
 *         Parameters = @"				{""Status"":""Running""}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oos.NewTemplate(ctx, "default", &oos.TemplateArgs{
 * 			Content: pulumi.String(`  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `),
 * 			TemplateName: pulumi.String("test-name"),
 * 			VersionName:  pulumi.String("test"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("acceptance Test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewExecution(ctx, "example", &oos.ExecutionArgs{
 * 			TemplateName: _default.TemplateName,
 * 			Description:  pulumi.String("From TF Test"),
 * 			Parameters:   pulumi.String("				{\"Status\":\"Running\"}\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oos.Template;
 * import com.pulumi.alicloud.oos.TemplateArgs;
 * import com.pulumi.alicloud.oos.Execution;
 * import com.pulumi.alicloud.oos.ExecutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Template("default", TemplateArgs.builder()
 *             .content("""
 *   {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 *             """)
 *             .templateName("test-name")
 *             .versionName("test")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "acceptance Test")
 *             ))
 *             .build());
 *         var example = new Execution("example", ExecutionArgs.builder()
 *             .templateName(default_.templateName())
 *             .description("From TF Test")
 *             .parameters("""
 * 				{"Status":"Running"}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:oos:Template
 *     properties:
 *       content: |2
 *           {
 *             "FormatVersion": "OOS-2019-06-01",
 *             "Description": "Update Describe instances of given status",
 *             "Parameters":{
 *               "Status":{
 *                 "Type": "String",
 *                 "Description": "(Required) The status of the Ecs instance."
 *               }
 *             },
 *             "Tasks": [
 *               {
 *                 "Properties" :{
 *                   "Parameters":{
 *                     "Status": "{{ Status }}"
 *                   },
 *                   "API": "DescribeInstances",
 *                   "Service": "Ecs"
 *                 },
 *                 "Name": "foo",
 *                 "Action": "ACS::ExecuteApi"
 *               }]
 *           }
 *       templateName: test-name
 *       versionName: test
 *       tags:
 *         Created: TF
 *         For: acceptance Test
 *   example:
 *     type: alicloud:oos:Execution
 *     properties:
 *       templateName: ${default.templateName}
 *       description: From TF Test
 *       parameters: |
 *         				{"Status":"Running"}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Execution can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/execution:Execution example exec-ef6xxxx
 * ```
 */
public class Execution internal constructor(
    override val javaResource: com.pulumi.alicloud.oos.Execution,
) : KotlinCustomResource(javaResource, ExecutionMapper) {
    /**
     * The counters of OOS Execution.
     */
    public val counters: Output<String>
        get() = javaResource.counters().applyValue({ args0 -> args0 })

    /**
     * The time when the execution was created.
     */
    public val createDate: Output<String>
        get() = javaResource.createDate().applyValue({ args0 -> args0 })

    /**
     * The description of OOS Execution.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time when the execution was ended.
     */
    public val endDate: Output<String>
        get() = javaResource.endDate().applyValue({ args0 -> args0 })

    /**
     * The user who execute the template.
     */
    public val executedBy: Output<String>
        get() = javaResource.executedBy().applyValue({ args0 -> args0 })

    /**
     * Whether to include subtasks.
     */
    public val isParent: Output<Boolean>
        get() = javaResource.isParent().applyValue({ args0 -> args0 })

    /**
     * The loop mode of OOS Execution.
     */
    public val loopMode: Output<String>?
        get() = javaResource.loopMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The mode of OOS Execution. Valid: `Automatic`, `Debug`. Default to `Automatic`.
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The outputs of OOS Execution.
     */
    public val outputs: Output<String>
        get() = javaResource.outputs().applyValue({ args0 -> args0 })

    /**
     * The parameters required by the template. Default to `{}`.
     */
    public val parameters: Output<String>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of parent execution.
     */
    public val parentExecutionId: Output<String>?
        get() = javaResource.parentExecutionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The role that executes the current template.
     */
    public val ramRole: Output<String>
        get() = javaResource.ramRole().applyValue({ args0 -> args0 })

    /**
     * The mode of safety check.
     */
    public val safetyCheck: Output<String>?
        get() = javaResource.safetyCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time when the execution was started.
     */
    public val startDate: Output<String>
        get() = javaResource.startDate().applyValue({ args0 -> args0 })

    /**
     * The status of OOS Execution.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The message of status.
     */
    public val statusMessage: Output<String>
        get() = javaResource.statusMessage().applyValue({ args0 -> args0 })

    /**
     * The content of template. When the user selects an existing template to create and execute a task, it is not necessary to pass in this field.
     */
    public val templateContent: Output<String>?
        get() = javaResource.templateContent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of template.
     */
    public val templateId: Output<String>
        get() = javaResource.templateId().applyValue({ args0 -> args0 })

    /**
     * The name of execution template.
     */
    public val templateName: Output<String>
        get() = javaResource.templateName().applyValue({ args0 -> args0 })

    /**
     * The version of execution template.
     */
    public val templateVersion: Output<String>
        get() = javaResource.templateVersion().applyValue({ args0 -> args0 })

    /**
     * The time when the execution was updated.
     */
    public val updateDate: Output<String>
        get() = javaResource.updateDate().applyValue({ args0 -> args0 })
}

public object ExecutionMapper : ResourceMapper<Execution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oos.Execution::class == javaResource::class

    override fun map(javaResource: Resource): Execution = Execution(
        javaResource as
            com.pulumi.alicloud.oos.Execution,
    )
}

/**
 * @see [Execution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Execution].
 */
public suspend fun execution(name: String, block: suspend ExecutionResourceBuilder.() -> Unit): Execution {
    val builder = ExecutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Execution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun execution(name: String): Execution {
    val builder = ExecutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
