@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.ExecutionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a OOS Execution resource. For information about Alicloud OOS Execution and how to use it, see [What is Resource Alicloud OOS Execution](https://www.alibabacloud.com/help/doc-detail/120771.htm).
 * > **NOTE:** Available in 1.93.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.oos.Template("default", {
 *     content: `  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `,
 *     templateName: "test-name",
 *     versionName: "test",
 *     tags: {
 *         Created: "TF",
 *         For: "acceptance Test",
 *     },
 * });
 * const example = new alicloud.oos.Execution("example", {
 *     templateName: _default.templateName,
 *     description: "From TF Test",
 *     parameters: "\x09\x09\x09\x09{\"Status\":\"Running\"}\n",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.oos.Template("default",
 *     content="""  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * """,
 *     template_name="test-name",
 *     version_name="test",
 *     tags={
 *         "Created": "TF",
 *         "For": "acceptance Test",
 *     })
 * example = alicloud.oos.Execution("example",
 *     template_name=default.template_name,
 *     description="From TF Test",
 *     parameters="\x09\x09\x09\x09{\"Status\":\"Running\"}\n")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Oos.Template("default", new()
 *     {
 *         Content = @"  {
 *     ""FormatVersion"": ""OOS-2019-06-01"",
 *     ""Description"": ""Update Describe instances of given status"",
 *     ""Parameters"":{
 *       ""Status"":{
 *         ""Type"": ""String"",
 *         ""Description"": ""(Required) The status of the Ecs instance.""
 *       }
 *     },
 *     ""Tasks"": [
 *       {
 *         ""Properties"" :{
 *           ""Parameters"":{
 *             ""Status"": ""{{ Status }}""
 *           },
 *           ""API"": ""DescribeInstances"",
 *           ""Service"": ""Ecs""
 *         },
 *         ""Name"": ""foo"",
 *         ""Action"": ""ACS::ExecuteApi""
 *       }]
 *   }
 * ",
 *         TemplateName = "test-name",
 *         VersionName = "test",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "acceptance Test" },
 *         },
 *     });
 *     var example = new AliCloud.Oos.Execution("example", new()
 *     {
 *         TemplateName = @default.TemplateName,
 *         Description = "From TF Test",
 *         Parameters = @"				{""Status"":""Running""}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oos.NewTemplate(ctx, "default", &oos.TemplateArgs{
 * 			Content: pulumi.String(`  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `),
 * 			TemplateName: pulumi.String("test-name"),
 * 			VersionName:  pulumi.String("test"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("acceptance Test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewExecution(ctx, "example", &oos.ExecutionArgs{
 * 			TemplateName: _default.TemplateName,
 * 			Description:  pulumi.String("From TF Test"),
 * 			Parameters:   pulumi.String("				{\"Status\":\"Running\"}\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oos.Template;
 * import com.pulumi.alicloud.oos.TemplateArgs;
 * import com.pulumi.alicloud.oos.Execution;
 * import com.pulumi.alicloud.oos.ExecutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Template("default", TemplateArgs.builder()
 *             .content("""
 *   {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 *             """)
 *             .templateName("test-name")
 *             .versionName("test")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "acceptance Test")
 *             ))
 *             .build());
 *         var example = new Execution("example", ExecutionArgs.builder()
 *             .templateName(default_.templateName())
 *             .description("From TF Test")
 *             .parameters("""
 * 				{"Status":"Running"}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:oos:Template
 *     properties:
 *       content: |2
 *           {
 *             "FormatVersion": "OOS-2019-06-01",
 *             "Description": "Update Describe instances of given status",
 *             "Parameters":{
 *               "Status":{
 *                 "Type": "String",
 *                 "Description": "(Required) The status of the Ecs instance."
 *               }
 *             },
 *             "Tasks": [
 *               {
 *                 "Properties" :{
 *                   "Parameters":{
 *                     "Status": "{{ Status }}"
 *                   },
 *                   "API": "DescribeInstances",
 *                   "Service": "Ecs"
 *                 },
 *                 "Name": "foo",
 *                 "Action": "ACS::ExecuteApi"
 *               }]
 *           }
 *       templateName: test-name
 *       versionName: test
 *       tags:
 *         Created: TF
 *         For: acceptance Test
 *   example:
 *     type: alicloud:oos:Execution
 *     properties:
 *       templateName: ${default.templateName}
 *       description: From TF Test
 *       parameters: |
 *         				{"Status":"Running"}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Execution can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/execution:Execution example exec-ef6xxxx
 * ```
 * @property description The description of OOS Execution.
 * @property loopMode The loop mode of OOS Execution.
 * @property mode The mode of OOS Execution. Valid: `Automatic`, `Debug`. Default to `Automatic`.
 * @property parameters The parameters required by the template. Default to `{}`.
 * @property parentExecutionId The id of parent execution.
 * @property safetyCheck The mode of safety check.
 * @property templateContent The content of template. When the user selects an existing template to create and execute a task, it is not necessary to pass in this field.
 * @property templateName The name of execution template.
 * @property templateVersion The version of execution template.
 */
public data class ExecutionArgs(
    public val description: Output<String>? = null,
    public val loopMode: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val parameters: Output<String>? = null,
    public val parentExecutionId: Output<String>? = null,
    public val safetyCheck: Output<String>? = null,
    public val templateContent: Output<String>? = null,
    public val templateName: Output<String>? = null,
    public val templateVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.ExecutionArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.ExecutionArgs =
        com.pulumi.alicloud.oos.ExecutionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .loopMode(loopMode?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .parentExecutionId(parentExecutionId?.applyValue({ args0 -> args0 }))
            .safetyCheck(safetyCheck?.applyValue({ args0 -> args0 }))
            .templateContent(templateContent?.applyValue({ args0 -> args0 }))
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .templateVersion(templateVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExecutionArgs].
 */
@PulumiTagMarker
public class ExecutionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var loopMode: Output<String>? = null

    private var mode: Output<String>? = null

    private var parameters: Output<String>? = null

    private var parentExecutionId: Output<String>? = null

    private var safetyCheck: Output<String>? = null

    private var templateContent: Output<String>? = null

    private var templateName: Output<String>? = null

    private var templateVersion: Output<String>? = null

    /**
     * @param value The description of OOS Execution.
     */
    @JvmName("adekdgwxhaolcyyu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The loop mode of OOS Execution.
     */
    @JvmName("btgixwjqdikchibu")
    public suspend fun loopMode(`value`: Output<String>) {
        this.loopMode = value
    }

    /**
     * @param value The mode of OOS Execution. Valid: `Automatic`, `Debug`. Default to `Automatic`.
     */
    @JvmName("cdrgfgfowebxvptq")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The parameters required by the template. Default to `{}`.
     */
    @JvmName("dpjtwqclvhfgatlo")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value The id of parent execution.
     */
    @JvmName("xaembtjdebckmtap")
    public suspend fun parentExecutionId(`value`: Output<String>) {
        this.parentExecutionId = value
    }

    /**
     * @param value The mode of safety check.
     */
    @JvmName("wthbadiikdtlgaoa")
    public suspend fun safetyCheck(`value`: Output<String>) {
        this.safetyCheck = value
    }

    /**
     * @param value The content of template. When the user selects an existing template to create and execute a task, it is not necessary to pass in this field.
     */
    @JvmName("hbfxdmdayodljdxr")
    public suspend fun templateContent(`value`: Output<String>) {
        this.templateContent = value
    }

    /**
     * @param value The name of execution template.
     */
    @JvmName("mdynvaeqthtkrvfw")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value The version of execution template.
     */
    @JvmName("wptkxppsloixevwv")
    public suspend fun templateVersion(`value`: Output<String>) {
        this.templateVersion = value
    }

    /**
     * @param value The description of OOS Execution.
     */
    @JvmName("pegufmkyvkaawhvx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The loop mode of OOS Execution.
     */
    @JvmName("biwhbgdyheerlbqx")
    public suspend fun loopMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loopMode = mapped
    }

    /**
     * @param value The mode of OOS Execution. Valid: `Automatic`, `Debug`. Default to `Automatic`.
     */
    @JvmName("anckomuwpsqwhbco")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The parameters required by the template. Default to `{}`.
     */
    @JvmName("ssftdyoimqiqrtpx")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The id of parent execution.
     */
    @JvmName("aqmbvrkmcansiynl")
    public suspend fun parentExecutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentExecutionId = mapped
    }

    /**
     * @param value The mode of safety check.
     */
    @JvmName("tmoouurkbxsooxia")
    public suspend fun safetyCheck(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.safetyCheck = mapped
    }

    /**
     * @param value The content of template. When the user selects an existing template to create and execute a task, it is not necessary to pass in this field.
     */
    @JvmName("tpqffkjvxynkxfaa")
    public suspend fun templateContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateContent = mapped
    }

    /**
     * @param value The name of execution template.
     */
    @JvmName("kvlshfmolwnttgoa")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value The version of execution template.
     */
    @JvmName("jqtaelsyecnmwjfa")
    public suspend fun templateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateVersion = mapped
    }

    internal fun build(): ExecutionArgs = ExecutionArgs(
        description = description,
        loopMode = loopMode,
        mode = mode,
        parameters = parameters,
        parentExecutionId = parentExecutionId,
        safetyCheck = safetyCheck,
        templateContent = templateContent,
        templateName = templateName,
        templateVersion = templateVersion,
    )
}
