@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.OosFunctions.getApplicationGroupsPlain
import com.pulumi.alicloud.oos.OosFunctions.getApplicationsPlain
import com.pulumi.alicloud.oos.OosFunctions.getExecutionsPlain
import com.pulumi.alicloud.oos.OosFunctions.getParametersPlain
import com.pulumi.alicloud.oos.OosFunctions.getPatchBaselinesPlain
import com.pulumi.alicloud.oos.OosFunctions.getSecretParametersPlain
import com.pulumi.alicloud.oos.OosFunctions.getStateConfigurationsPlain
import com.pulumi.alicloud.oos.OosFunctions.getTemplatesPlain
import com.pulumi.alicloud.oos.kotlin.inputs.GetApplicationGroupsPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetApplicationGroupsPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.inputs.GetApplicationsPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetApplicationsPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.inputs.GetExecutionsPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetExecutionsPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.inputs.GetParametersPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetParametersPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.inputs.GetPatchBaselinesPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetPatchBaselinesPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.inputs.GetSecretParametersPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetSecretParametersPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.inputs.GetStateConfigurationsPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetStateConfigurationsPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.inputs.GetTemplatesPlainArgs
import com.pulumi.alicloud.oos.kotlin.inputs.GetTemplatesPlainArgsBuilder
import com.pulumi.alicloud.oos.kotlin.outputs.GetApplicationGroupsResult
import com.pulumi.alicloud.oos.kotlin.outputs.GetApplicationsResult
import com.pulumi.alicloud.oos.kotlin.outputs.GetExecutionsResult
import com.pulumi.alicloud.oos.kotlin.outputs.GetParametersResult
import com.pulumi.alicloud.oos.kotlin.outputs.GetPatchBaselinesResult
import com.pulumi.alicloud.oos.kotlin.outputs.GetSecretParametersResult
import com.pulumi.alicloud.oos.kotlin.outputs.GetStateConfigurationsResult
import com.pulumi.alicloud.oos.kotlin.outputs.GetTemplatesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.oos.kotlin.outputs.GetApplicationGroupsResult.Companion.toKotlin as getApplicationGroupsResultToKotlin
import com.pulumi.alicloud.oos.kotlin.outputs.GetApplicationsResult.Companion.toKotlin as getApplicationsResultToKotlin
import com.pulumi.alicloud.oos.kotlin.outputs.GetExecutionsResult.Companion.toKotlin as getExecutionsResultToKotlin
import com.pulumi.alicloud.oos.kotlin.outputs.GetParametersResult.Companion.toKotlin as getParametersResultToKotlin
import com.pulumi.alicloud.oos.kotlin.outputs.GetPatchBaselinesResult.Companion.toKotlin as getPatchBaselinesResultToKotlin
import com.pulumi.alicloud.oos.kotlin.outputs.GetSecretParametersResult.Companion.toKotlin as getSecretParametersResultToKotlin
import com.pulumi.alicloud.oos.kotlin.outputs.GetStateConfigurationsResult.Companion.toKotlin as getStateConfigurationsResultToKotlin
import com.pulumi.alicloud.oos.kotlin.outputs.GetTemplatesResult.Companion.toKotlin as getTemplatesResultToKotlin

public object OosFunctions {
    /**
     * This data source provides the Oos Application Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.146.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.oos.getApplicationGroups({
     *     applicationName: "example_value",
     *     ids: [
     *         "my-ApplicationGroup-1",
     *         "my-ApplicationGroup-2",
     *     ],
     * });
     * export const oosApplicationGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.oos.getApplicationGroups({
     *     applicationName: "example_value",
     *     nameRegex: "^my-ApplicationGroup",
     * });
     * export const oosApplicationGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.oos.get_application_groups(application_name="example_value",
     *     ids=[
     *         "my-ApplicationGroup-1",
     *         "my-ApplicationGroup-2",
     *     ])
     * pulumi.export("oosApplicationGroupId1", ids.groups[0].id)
     * name_regex = alicloud.oos.get_application_groups(application_name="example_value",
     *     name_regex="^my-ApplicationGroup")
     * pulumi.export("oosApplicationGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Oos.GetApplicationGroups.Invoke(new()
     *     {
     *         ApplicationName = "example_value",
     *         Ids = new[]
     *         {
     *             "my-ApplicationGroup-1",
     *             "my-ApplicationGroup-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Oos.GetApplicationGroups.Invoke(new()
     *     {
     *         ApplicationName = "example_value",
     *         NameRegex = "^my-ApplicationGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["oosApplicationGroupId1"] = ids&#46;Apply(getApplicationGroupsResult => getApplicationGroupsResult&#46;Groups[0]?.Id),
     *         ["oosApplicationGroupId2"] = nameRegex&#46;Apply(getApplicationGroupsResult => getApplicationGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := oos.GetApplicationGroups(ctx, &oos.GetApplicationGroupsArgs{
     * 			ApplicationName: "example_value",
     * 			Ids: []string{
     * 				"my-ApplicationGroup-1",
     * 				"my-ApplicationGroup-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosApplicationGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := oos.GetApplicationGroups(ctx, &oos.GetApplicationGroupsArgs{
     * 			ApplicationName: "example_value",
     * 			NameRegex:       pulumi.StringRef("^my-ApplicationGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosApplicationGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oos.OosFunctions;
     * import com.pulumi.alicloud.oos.inputs.GetApplicationGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = OosFunctions.getApplicationGroups(GetApplicationGroupsArgs.builder()
     *             .applicationName("example_value")
     *             .ids(
     *                 "my-ApplicationGroup-1",
     *                 "my-ApplicationGroup-2")
     *             .build());
     *         ctx.export("oosApplicationGroupId1", ids.applyValue(getApplicationGroupsResult -> getApplicationGroupsResult.groups()[0].id()));
     *         final var nameRegex = OosFunctions.getApplicationGroups(GetApplicationGroupsArgs.builder()
     *             .applicationName("example_value")
     *             .nameRegex("^my-ApplicationGroup")
     *             .build());
     *         ctx.export("oosApplicationGroupId2", nameRegex.applyValue(getApplicationGroupsResult -> getApplicationGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:oos:getApplicationGroups
     *       Arguments:
     *         applicationName: example_value
     *         ids:
     *           - my-ApplicationGroup-1
     *           - my-ApplicationGroup-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:oos:getApplicationGroups
     *       Arguments:
     *         applicationName: example_value
     *         nameRegex: ^my-ApplicationGroup
     * outputs:
     *   oosApplicationGroupId1: ${ids.groups[0].id}
     *   oosApplicationGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplicationGroups.
     * @return A collection of values returned by getApplicationGroups.
     */
    public suspend fun getApplicationGroups(argument: GetApplicationGroupsPlainArgs): GetApplicationGroupsResult =
        getApplicationGroupsResultToKotlin(getApplicationGroupsPlain(argument.toJava()).await())

    /**
     * @see [getApplicationGroups].
     * @param applicationName The name of the Application.
     * @param deployRegionId The region ID of the deployment.
     * @param ids A list of Application Group IDs. Its element value is same as Application Group Name.
     * @param nameRegex A regex string to filter results by Application Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getApplicationGroups.
     */
    public suspend fun getApplicationGroups(
        applicationName: String,
        deployRegionId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetApplicationGroupsResult {
        val argument = GetApplicationGroupsPlainArgs(
            applicationName = applicationName,
            deployRegionId = deployRegionId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getApplicationGroupsResultToKotlin(getApplicationGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetApplicationGroupsPlainArgs].
     * @return A collection of values returned by getApplicationGroups.
     */
    public suspend fun getApplicationGroups(argument: suspend GetApplicationGroupsPlainArgsBuilder.() -> Unit): GetApplicationGroupsResult {
        val builder = GetApplicationGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationGroupsResultToKotlin(getApplicationGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Oos Applications of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.145.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.oos.getApplications({});
     * export const oosApplicationId1 = ids.then(ids => ids.applications?.[0]?.id);
     * const nameRegex = alicloud.oos.getApplications({
     *     nameRegex: "^my-Application",
     * });
     * export const oosApplicationId2 = nameRegex.then(nameRegex => nameRegex.applications?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.oos.get_applications()
     * pulumi.export("oosApplicationId1", ids.applications[0].id)
     * name_regex = alicloud.oos.get_applications(name_regex="^my-Application")
     * pulumi.export("oosApplicationId2", name_regex.applications[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Oos.GetApplications.Invoke();
     *     var nameRegex = AliCloud.Oos.GetApplications.Invoke(new()
     *     {
     *         NameRegex = "^my-Application",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["oosApplicationId1"] = ids&#46;Apply(getApplicationsResult => getApplicationsResult&#46;Applications[0]?.Id),
     *         ["oosApplicationId2"] = nameRegex&#46;Apply(getApplicationsResult => getApplicationsResult&#46;Applications[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := oos.GetApplications(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosApplicationId1", ids.Applications[0].Id)
     * 		nameRegex, err := oos.GetApplications(ctx, &oos.GetApplicationsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Application"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosApplicationId2", nameRegex.Applications[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oos.OosFunctions;
     * import com.pulumi.alicloud.oos.inputs.GetApplicationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = OosFunctions.getApplications();
     *         ctx.export("oosApplicationId1", ids.applyValue(getApplicationsResult -> getApplicationsResult.applications()[0].id()));
     *         final var nameRegex = OosFunctions.getApplications(GetApplicationsArgs.builder()
     *             .nameRegex("^my-Application")
     *             .build());
     *         ctx.export("oosApplicationId2", nameRegex.applyValue(getApplicationsResult -> getApplicationsResult.applications()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:oos:getApplications
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:oos:getApplications
     *       Arguments:
     *         nameRegex: ^my-Application
     * outputs:
     *   oosApplicationId1: ${ids.applications[0].id}
     *   oosApplicationId2: ${nameRegex.applications[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplications.
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(argument: GetApplicationsPlainArgs): GetApplicationsResult =
        getApplicationsResultToKotlin(getApplicationsPlain(argument.toJava()).await())

    /**
     * @see [getApplications].
     * @param ids A list of Application IDs. Its element value is same as Application Name.
     * @param nameRegex A regex string to filter results by Application name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetApplicationsResult {
        val argument = GetApplicationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getApplicationsResultToKotlin(getApplicationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetApplicationsPlainArgs].
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(argument: suspend GetApplicationsPlainArgsBuilder.() -> Unit): GetApplicationsResult {
        val builder = GetApplicationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationsResultToKotlin(getApplicationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of OOS Executions in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.93.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const example = alicloud.oos.getExecutions({
     *     ids: ["execution_id"],
     *     templateName: "name",
     *     status: "Success",
     * });
     * export const firstExecutionId = example.then(example => example.executions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * example = alicloud.oos.get_executions(ids=["execution_id"],
     *     template_name="name",
     *     status="Success")
     * pulumi.export("firstExecutionId", example.executions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var example = AliCloud.Oos.GetExecutions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "execution_id",
     *         },
     *         TemplateName = "name",
     *         Status = "Success",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstExecutionId"] = example&#46;Apply(getExecutionsResult => getExecutionsResult&#46;Executions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		example, err := oos.GetExecutions(ctx, &oos.GetExecutionsArgs{
     * 			Ids: []string{
     * 				"execution_id",
     * 			},
     * 			TemplateName: pulumi.StringRef("name"),
     * 			Status:       pulumi.StringRef("Success"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstExecutionId", example.Executions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oos.OosFunctions;
     * import com.pulumi.alicloud.oos.inputs.GetExecutionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var example = OosFunctions.getExecutions(GetExecutionsArgs.builder()
     *             .ids("execution_id")
     *             .templateName("name")
     *             .status("Success")
     *             .build());
     *         ctx.export("firstExecutionId", example.applyValue(getExecutionsResult -> getExecutionsResult.executions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   example:
     *     fn::invoke:
     *       Function: alicloud:oos:getExecutions
     *       Arguments:
     *         ids:
     *           - execution_id
     *         templateName: name
     *         status: Success
     * outputs:
     *   firstExecutionId: ${example.executions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExecutions.
     * @return A collection of values returned by getExecutions.
     */
    public suspend fun getExecutions(argument: GetExecutionsPlainArgs): GetExecutionsResult =
        getExecutionsResultToKotlin(getExecutionsPlain(argument.toJava()).await())

    /**
     * @see [getExecutions].
     * @param category The category of template. Valid: `AlarmTrigger`, `EventTrigger`, `Other` and `TimerTrigger`.
     * @param endDate The time when the execution was ended.
     * @param endDateAfter Execution whose end time is less than or equal to the specified time.
     * @param executedBy The user who execute the template.
     * @param ids A list of OOS Execution ids.
     * @param includeChildExecution Whether to include sub-execution.
     * @param mode The mode of OOS Execution. Valid: `Automatic`, `Debug`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parentExecutionId The id of parent OOS Execution.
     * @param ramRole The role that executes the current template.
     * @param sortField The sort field.
     * @param sortOrder The sort order.
     * @param startDateAfter The execution whose start time is greater than or equal to the specified time.
     * @param startDateBefore The execution with start time less than or equal to the specified time.
     * @param status The Status of OOS Execution. Valid: `Cancelled`, `Failed`, `Queued`, `Running`, `Started`, `Success`, `Waiting`.
     * @param tags A mapping of tags to assign to the resource.
     * @param templateName The name of execution template.
     * @return A collection of values returned by getExecutions.
     */
    public suspend fun getExecutions(
        category: String? = null,
        endDate: String? = null,
        endDateAfter: String? = null,
        executedBy: String? = null,
        ids: List<String>? = null,
        includeChildExecution: Boolean? = null,
        mode: String? = null,
        outputFile: String? = null,
        parentExecutionId: String? = null,
        ramRole: String? = null,
        sortField: String? = null,
        sortOrder: String? = null,
        startDateAfter: String? = null,
        startDateBefore: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        templateName: String? = null,
    ): GetExecutionsResult {
        val argument = GetExecutionsPlainArgs(
            category = category,
            endDate = endDate,
            endDateAfter = endDateAfter,
            executedBy = executedBy,
            ids = ids,
            includeChildExecution = includeChildExecution,
            mode = mode,
            outputFile = outputFile,
            parentExecutionId = parentExecutionId,
            ramRole = ramRole,
            sortField = sortField,
            sortOrder = sortOrder,
            startDateAfter = startDateAfter,
            startDateBefore = startDateBefore,
            status = status,
            tags = tags,
            templateName = templateName,
        )
        return getExecutionsResultToKotlin(getExecutionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getExecutions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetExecutionsPlainArgs].
     * @return A collection of values returned by getExecutions.
     */
    public suspend fun getExecutions(argument: suspend GetExecutionsPlainArgsBuilder.() -> Unit): GetExecutionsResult {
        val builder = GetExecutionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExecutionsResultToKotlin(getExecutionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Oos Parameters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.147.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.oos.getParameters({
     *     ids: ["my-Parameter"],
     * });
     * export const oosParameterId1 = ids.then(ids => ids.parameters?.[0]?.id);
     * const nameRegex = alicloud.oos.getParameters({
     *     nameRegex: "^my-Parameter",
     * });
     * export const oosParameterId2 = nameRegex.then(nameRegex => nameRegex.parameters?.[0]?.id);
     * const resourceGroupId = alicloud.oos.getParameters({
     *     ids: ["my-Parameter"],
     *     resourceGroupId: "example_value",
     * });
     * export const oosParameterId3 = resourceGroupId.then(resourceGroupId => resourceGroupId.parameters?.[0]?.id);
     * const tags = alicloud.oos.getParameters({
     *     ids: ["my-Parameter"],
     *     tags: {
     *         Created: "TF",
     *         For: "OosParameter",
     *     },
     * });
     * export const oosParameterId4 = tags.then(tags => tags.parameters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.oos.get_parameters(ids=["my-Parameter"])
     * pulumi.export("oosParameterId1", ids.parameters[0].id)
     * name_regex = alicloud.oos.get_parameters(name_regex="^my-Parameter")
     * pulumi.export("oosParameterId2", name_regex.parameters[0].id)
     * resource_group_id = alicloud.oos.get_parameters(ids=["my-Parameter"],
     *     resource_group_id="example_value")
     * pulumi.export("oosParameterId3", resource_group_id.parameters[0].id)
     * tags = alicloud.oos.get_parameters(ids=["my-Parameter"],
     *     tags={
     *         "Created": "TF",
     *         "For": "OosParameter",
     *     })
     * pulumi.export("oosParameterId4", tags.parameters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Oos.GetParameters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "my-Parameter",
     *         },
     *     });
     *     var nameRegex = AliCloud.Oos.GetParameters.Invoke(new()
     *     {
     *         NameRegex = "^my-Parameter",
     *     });
     *     var resourceGroupId = AliCloud.Oos.GetParameters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "my-Parameter",
     *         },
     *         ResourceGroupId = "example_value",
     *     });
     *     var tags = AliCloud.Oos.GetParameters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "my-Parameter",
     *         },
     *         Tags =
     *         {
     *             { "Created", "TF" },
     *             { "For", "OosParameter" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["oosParameterId1"] = ids&#46;Apply(getParametersResult => getParametersResult&#46;Parameters[0]?.Id),
     *         ["oosParameterId2"] = nameRegex&#46;Apply(getParametersResult => getParametersResult&#46;Parameters[0]?.Id),
     *         ["oosParameterId3"] = resourceGroupId&#46;Apply(getParametersResult => getParametersResult&#46;Parameters[0]?.Id),
     *         ["oosParameterId4"] = tags&#46;Apply(getParametersResult => getParametersResult&#46;Parameters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := oos.GetParameters(ctx, &oos.GetParametersArgs{
     * 			Ids: []string{
     * 				"my-Parameter",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosParameterId1", ids.Parameters[0].Id)
     * 		nameRegex, err := oos.GetParameters(ctx, &oos.GetParametersArgs{
     * 			NameRegex: pulumi.StringRef("^my-Parameter"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosParameterId2", nameRegex.Parameters[0].Id)
     * 		resourceGroupId, err := oos.GetParameters(ctx, &oos.GetParametersArgs{
     * 			Ids: []string{
     * 				"my-Parameter",
     * 			},
     * 			ResourceGroupId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosParameterId3", resourceGroupId.Parameters[0].Id)
     * 		tags, err := oos.GetParameters(ctx, &oos.GetParametersArgs{
     * 			Ids: []string{
     * 				"my-Parameter",
     * 			},
     * 			Tags: map[string]interface{}{
     * 				"Created": "TF",
     * 				"For":     "OosParameter",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosParameterId4", tags.Parameters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oos.OosFunctions;
     * import com.pulumi.alicloud.oos.inputs.GetParametersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = OosFunctions.getParameters(GetParametersArgs.builder()
     *             .ids("my-Parameter")
     *             .build());
     *         ctx.export("oosParameterId1", ids.applyValue(getParametersResult -> getParametersResult.parameters()[0].id()));
     *         final var nameRegex = OosFunctions.getParameters(GetParametersArgs.builder()
     *             .nameRegex("^my-Parameter")
     *             .build());
     *         ctx.export("oosParameterId2", nameRegex.applyValue(getParametersResult -> getParametersResult.parameters()[0].id()));
     *         final var resourceGroupId = OosFunctions.getParameters(GetParametersArgs.builder()
     *             .ids("my-Parameter")
     *             .resourceGroupId("example_value")
     *             .build());
     *         ctx.export("oosParameterId3", resourceGroupId.applyValue(getParametersResult -> getParametersResult.parameters()[0].id()));
     *         final var tags = OosFunctions.getParameters(GetParametersArgs.builder()
     *             .ids("my-Parameter")
     *             .tags(Map.ofEntries(
     *                 Map.entry("Created", "TF"),
     *                 Map.entry("For", "OosParameter")
     *             ))
     *             .build());
     *         ctx.export("oosParameterId4", tags.applyValue(getParametersResult -> getParametersResult.parameters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:oos:getParameters
     *       Arguments:
     *         ids:
     *           - my-Parameter
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:oos:getParameters
     *       Arguments:
     *         nameRegex: ^my-Parameter
     *   resourceGroupId:
     *     fn::invoke:
     *       Function: alicloud:oos:getParameters
     *       Arguments:
     *         ids:
     *           - my-Parameter
     *         resourceGroupId: example_value
     *   tags:
     *     fn::invoke:
     *       Function: alicloud:oos:getParameters
     *       Arguments:
     *         ids:
     *           - my-Parameter
     *         tags:
     *           Created: TF
     *           For: OosParameter
     * outputs:
     *   oosParameterId1: ${ids.parameters[0].id}
     *   oosParameterId2: ${nameRegex.parameters[0].id}
     *   oosParameterId3: ${resourceGroupId.parameters[0].id}
     *   oosParameterId4: ${tags.parameters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getParameters.
     * @return A collection of values returned by getParameters.
     */
    public suspend fun getParameters(argument: GetParametersPlainArgs): GetParametersResult =
        getParametersResultToKotlin(getParametersPlain(argument.toJava()).await())

    /**
     * @see [getParameters].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Parameter IDs. Its element value is same as Parameter Name.
     * @param nameRegex A regex string to filter results by Parameter name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parameterName The name of the common parameter. You can enter a keyword to query parameter names in fuzzy match mode.
     * @param resourceGroupId The ID of the Resource Group.
     * @param sortField
     * @param sortOrder
     * @param tags A mapping of tags to assign to the resource.
     * @param type The data type of the common parameter. Valid values: `String` and `StringList`.
     * @return A collection of values returned by getParameters.
     */
    public suspend fun getParameters(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        parameterName: String? = null,
        resourceGroupId: String? = null,
        sortField: String? = null,
        sortOrder: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
    ): GetParametersResult {
        val argument = GetParametersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            parameterName = parameterName,
            resourceGroupId = resourceGroupId,
            sortField = sortField,
            sortOrder = sortOrder,
            tags = tags,
            type = type,
        )
        return getParametersResultToKotlin(getParametersPlain(argument.toJava()).await())
    }

    /**
     * @see [getParameters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetParametersPlainArgs].
     * @return A collection of values returned by getParameters.
     */
    public suspend fun getParameters(argument: suspend GetParametersPlainArgsBuilder.() -> Unit): GetParametersResult {
        val builder = GetParametersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParametersResultToKotlin(getParametersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Oos Patch Baselines of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.146.0+.
     * @param argument A collection of arguments for invoking getPatchBaselines.
     * @return A collection of values returned by getPatchBaselines.
     */
    public suspend fun getPatchBaselines(argument: GetPatchBaselinesPlainArgs): GetPatchBaselinesResult =
        getPatchBaselinesResultToKotlin(getPatchBaselinesPlain(argument.toJava()).await())

    /**
     * @see [getPatchBaselines].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Patch Baseline IDs. Its element value is same as Patch Baseline Name.
     * @param nameRegex A regex string to filter results by Patch Baseline name.
     * @param operationSystem Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param shareType Patch baseline sharing type. Valid values: `Private`, `Public`.
     * @return A collection of values returned by getPatchBaselines.
     */
    public suspend fun getPatchBaselines(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        operationSystem: String? = null,
        outputFile: String? = null,
        shareType: String? = null,
    ): GetPatchBaselinesResult {
        val argument = GetPatchBaselinesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            operationSystem = operationSystem,
            outputFile = outputFile,
            shareType = shareType,
        )
        return getPatchBaselinesResultToKotlin(getPatchBaselinesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPatchBaselines].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetPatchBaselinesPlainArgs].
     * @return A collection of values returned by getPatchBaselines.
     */
    public suspend fun getPatchBaselines(argument: suspend GetPatchBaselinesPlainArgsBuilder.() -> Unit): GetPatchBaselinesResult {
        val builder = GetPatchBaselinesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPatchBaselinesResultToKotlin(getPatchBaselinesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Oos Secret Parameters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.147.0+.
     * @param argument A collection of arguments for invoking getSecretParameters.
     * @return A collection of values returned by getSecretParameters.
     */
    public suspend fun getSecretParameters(argument: GetSecretParametersPlainArgs): GetSecretParametersResult =
        getSecretParametersResultToKotlin(getSecretParametersPlain(argument.toJava()).await())

    /**
     * @see [getSecretParameters].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Secret Parameter IDs.
     * @param nameRegex A regex string to filter results by Secret Parameter name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the Resource Group.
     * @param secretParameterName The name of the secret parameter.
     * @param sortField
     * @param sortOrder
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getSecretParameters.
     */
    public suspend fun getSecretParameters(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        secretParameterName: String? = null,
        sortField: String? = null,
        sortOrder: String? = null,
        tags: Map<String, String>? = null,
    ): GetSecretParametersResult {
        val argument = GetSecretParametersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            secretParameterName = secretParameterName,
            sortField = sortField,
            sortOrder = sortOrder,
            tags = tags,
        )
        return getSecretParametersResultToKotlin(getSecretParametersPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretParameters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetSecretParametersPlainArgs].
     * @return A collection of values returned by getSecretParameters.
     */
    public suspend fun getSecretParameters(argument: suspend GetSecretParametersPlainArgsBuilder.() -> Unit): GetSecretParametersResult {
        val builder = GetSecretParametersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretParametersResultToKotlin(getSecretParametersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Oos State Configurations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.147.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.oos.getStateConfigurations({});
     * export const oosStateConfigurationId1 = ids.then(ids => ids.configurations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.oos.get_state_configurations()
     * pulumi.export("oosStateConfigurationId1", ids.configurations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Oos.GetStateConfigurations.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["oosStateConfigurationId1"] = ids&#46;Apply(getStateConfigurationsResult => getStateConfigurationsResult&#46;Configurations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := oos.GetStateConfigurations(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("oosStateConfigurationId1", ids.Configurations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oos.OosFunctions;
     * import com.pulumi.alicloud.oos.inputs.GetStateConfigurationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = OosFunctions.getStateConfigurations();
     *         ctx.export("oosStateConfigurationId1", ids.applyValue(getStateConfigurationsResult -> getStateConfigurationsResult.configurations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:oos:getStateConfigurations
     *       Arguments: {}
     * outputs:
     *   oosStateConfigurationId1: ${ids.configurations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStateConfigurations.
     * @return A collection of values returned by getStateConfigurations.
     */
    public suspend fun getStateConfigurations(argument: GetStateConfigurationsPlainArgs): GetStateConfigurationsResult =
        getStateConfigurationsResultToKotlin(getStateConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [getStateConfigurations].
     * @param ids A list of State Configuration IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param tags The tag of the resource.
     * @return A collection of values returned by getStateConfigurations.
     */
    public suspend fun getStateConfigurations(
        ids: List<String>? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetStateConfigurationsResult {
        val argument = GetStateConfigurationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getStateConfigurationsResultToKotlin(getStateConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getStateConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetStateConfigurationsPlainArgs].
     * @return A collection of values returned by getStateConfigurations.
     */
    public suspend fun getStateConfigurations(argument: suspend GetStateConfigurationsPlainArgsBuilder.() -> Unit): GetStateConfigurationsResult {
        val builder = GetStateConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStateConfigurationsResultToKotlin(getStateConfigurationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of OOS Templates in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.92.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const example = alicloud.oos.getTemplates({
     *     nameRegex: "test",
     *     tags: {
     *         Created: "TF",
     *         For: "template Test",
     *     },
     *     shareType: "Private",
     *     hasTrigger: false,
     * });
     * export const firstTemplateName = example.then(example => example.templates?.[0]?.templateName);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * example = alicloud.oos.get_templates(name_regex="test",
     *     tags={
     *         "Created": "TF",
     *         "For": "template Test",
     *     },
     *     share_type="Private",
     *     has_trigger=False)
     * pulumi.export("firstTemplateName", example.templates[0].template_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var example = AliCloud.Oos.GetTemplates.Invoke(new()
     *     {
     *         NameRegex = "test",
     *         Tags =
     *         {
     *             { "Created", "TF" },
     *             { "For", "template Test" },
     *         },
     *         ShareType = "Private",
     *         HasTrigger = false,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTemplateName"] = example&#46;Apply(getTemplatesResult => getTemplatesResult&#46;Templates[0]?.TemplateName),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		example, err := oos.GetTemplates(ctx, &oos.GetTemplatesArgs{
     * 			NameRegex: pulumi.StringRef("test"),
     * 			Tags: map[string]interface{}{
     * 				"Created": "TF",
     * 				"For":     "template Test",
     * 			},
     * 			ShareType:  pulumi.StringRef("Private"),
     * 			HasTrigger: pulumi.BoolRef(false),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTemplateName", example.Templates[0].TemplateName)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oos.OosFunctions;
     * import com.pulumi.alicloud.oos.inputs.GetTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var example = OosFunctions.getTemplates(GetTemplatesArgs.builder()
     *             .nameRegex("test")
     *             .tags(Map.ofEntries(
     *                 Map.entry("Created", "TF"),
     *                 Map.entry("For", "template Test")
     *             ))
     *             .shareType("Private")
     *             .hasTrigger(false)
     *             .build());
     *         ctx.export("firstTemplateName", example.applyValue(getTemplatesResult -> getTemplatesResult.templates()[0].templateName()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   example:
     *     fn::invoke:
     *       Function: alicloud:oos:getTemplates
     *       Arguments:
     *         nameRegex: test
     *         tags:
     *           Created: TF
     *           For: template Test
     *         shareType: Private
     *         hasTrigger: false
     * outputs:
     *   firstTemplateName: ${example.templates[0].templateName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTemplates.
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(argument: GetTemplatesPlainArgs): GetTemplatesResult =
        getTemplatesResultToKotlin(getTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getTemplates].
     * @param category The category of template.
     * @param createdBy The creator of the template.
     * @param createdDate The template whose creation time is less than or equal to the specified time. The format is: YYYY-MM-DDThh:mm::ssZ.
     * @param createdDateAfter Create a template whose time is greater than or equal to the specified time. The format is: YYYY-MM-DDThh:mm:ssZ.
     * @param hasTrigger Is it triggered successfully.
     * @param ids A list of OOS Template ids. Each element in the list is same as template_name.
     * @param nameRegex A regex string to filter the results by the template_name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param shareType The sharing type of the template. Valid values: `Private`, `Public`.
     * @param sortField Sort field. Valid values: `TotalExecutionCount`, `Popularity`, `TemplateName` and `CreatedDate`. Default to `TotalExecutionCount`.
     * @param sortOrder Sort order. Valid values: `Ascending`, `Descending`. Default to `Descending`
     * @param tags A mapping of tags to assign to the resource.
     * @param templateFormat The format of the template. Valid values: `JSON`, `YAML`.
     * @param templateType The type of OOS Template.
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(
        category: String? = null,
        createdBy: String? = null,
        createdDate: String? = null,
        createdDateAfter: String? = null,
        hasTrigger: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        shareType: String? = null,
        sortField: String? = null,
        sortOrder: String? = null,
        tags: Map<String, String>? = null,
        templateFormat: String? = null,
        templateType: String? = null,
    ): GetTemplatesResult {
        val argument = GetTemplatesPlainArgs(
            category = category,
            createdBy = createdBy,
            createdDate = createdDate,
            createdDateAfter = createdDateAfter,
            hasTrigger = hasTrigger,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            shareType = shareType,
            sortField = sortField,
            sortOrder = sortOrder,
            tags = tags,
            templateFormat = templateFormat,
            templateType = templateType,
        )
        return getTemplatesResultToKotlin(getTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oos&#46;kotlin&#46;inputs&#46;GetTemplatesPlainArgs].
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(argument: suspend GetTemplatesPlainArgsBuilder.() -> Unit): GetTemplatesResult {
        val builder = GetTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplatesResultToKotlin(getTemplatesPlain(builtArgument.toJava()).await())
    }
}
