@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Parameter].
 */
@PulumiTagMarker
public class ParameterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ParameterArgs = ParameterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ParameterArgsBuilder.() -> Unit) {
        val builder = ParameterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Parameter {
        val builtJavaResource = com.pulumi.alicloud.oos.Parameter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Parameter(builtJavaResource)
    }
}

/**
 * Provides a OOS Parameter resource.
 * For information about OOS Parameter and how to use it, see [What is Parameter](https://www.alibabacloud.com/help/en/doc-detail/183408.html).
 * > **NOTE:** Available in v1.147.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const example = new alicloud.oos.Parameter("example", {
 *     parameterName: "my-Parameter",
 *     type: "String",
 *     value: "example_value",
 *     description: "example_value",
 *     tags: {
 *         Created: "TF",
 *         For: "OosParameter",
 *     },
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * example = alicloud.oos.Parameter("example",
 *     parameter_name="my-Parameter",
 *     type="String",
 *     value="example_value",
 *     description="example_value",
 *     tags={
 *         "Created": "TF",
 *         "For": "OosParameter",
 *     },
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var example = new AliCloud.Oos.Parameter("example", new()
 *     {
 *         ParameterName = "my-Parameter",
 *         Type = "String",
 *         Value = "example_value",
 *         Description = "example_value",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "OosParameter" },
 *         },
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewParameter(ctx, "example", &oos.ParameterArgs{
 * 			ParameterName: pulumi.String("my-Parameter"),
 * 			Type:          pulumi.String("String"),
 * 			Value:         pulumi.String("example_value"),
 * 			Description:   pulumi.String("example_value"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("OosParameter"),
 * 			},
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.oos.Parameter;
 * import com.pulumi.alicloud.oos.ParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var example = new Parameter("example", ParameterArgs.builder()
 *             .parameterName("my-Parameter")
 *             .type("String")
 *             .value("example_value")
 *             .description("example_value")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "OosParameter")
 *             ))
 *             .resourceGroupId(default_.groups()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:oos:Parameter
 *     properties:
 *       parameterName: my-Parameter
 *       type: String
 *       value: example_value
 *       description: example_value
 *       tags:
 *         Created: TF
 *         For: OosParameter
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Parameter can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/parameter:Parameter example <parameter_name>
 * ```
 */
public class Parameter internal constructor(
    override val javaResource: com.pulumi.alicloud.oos.Parameter,
) : KotlinCustomResource(javaResource, ParameterMapper) {
    /**
     * The constraints of the common parameter. This value follows the json format. By default, this parameter is null. Valid values:
     * * `AllowedValues`: The value that is allowed for the common parameter. It must be an array string.
     * * `AllowedPattern`: The pattern that is allowed for the common parameter. It must be a regular expression.
     * * `MinLength`: The minimum length of the common parameter.
     * * `MaxLength`: The maximum length of the common parameter.
     */
    public val constraints: Output<String>?
        get() = javaResource.constraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the common parameter. The description must be `1` to `200` characters in length.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The name of the common parameter. The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
     */
    public val parameterName: Output<String>
        get() = javaResource.parameterName().applyValue({ args0 -> args0 })

    /**
     * The ID of the Resource Group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The data type of the common parameter. Valid values: `String` and `StringList`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The value of the common parameter. The value must be `1` to `4096` characters in length.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object ParameterMapper : ResourceMapper<Parameter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oos.Parameter::class == javaResource::class

    override fun map(javaResource: Resource): Parameter = Parameter(
        javaResource as
            com.pulumi.alicloud.oos.Parameter,
    )
}

/**
 * @see [Parameter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Parameter].
 */
public suspend fun parameter(name: String, block: suspend ParameterResourceBuilder.() -> Unit): Parameter {
    val builder = ParameterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Parameter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun parameter(name: String): Parameter {
    val builder = ParameterResourceBuilder()
    builder.name(name)
    return builder.build()
}
