@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.ParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a OOS Parameter resource.
 * For information about OOS Parameter and how to use it, see [What is Parameter](https://www.alibabacloud.com/help/en/doc-detail/183408.html).
 * > **NOTE:** Available in v1.147.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const example = new alicloud.oos.Parameter("example", {
 *     parameterName: "my-Parameter",
 *     type: "String",
 *     value: "example_value",
 *     description: "example_value",
 *     tags: {
 *         Created: "TF",
 *         For: "OosParameter",
 *     },
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * example = alicloud.oos.Parameter("example",
 *     parameter_name="my-Parameter",
 *     type="String",
 *     value="example_value",
 *     description="example_value",
 *     tags={
 *         "Created": "TF",
 *         "For": "OosParameter",
 *     },
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var example = new AliCloud.Oos.Parameter("example", new()
 *     {
 *         ParameterName = "my-Parameter",
 *         Type = "String",
 *         Value = "example_value",
 *         Description = "example_value",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "OosParameter" },
 *         },
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewParameter(ctx, "example", &oos.ParameterArgs{
 * 			ParameterName: pulumi.String("my-Parameter"),
 * 			Type:          pulumi.String("String"),
 * 			Value:         pulumi.String("example_value"),
 * 			Description:   pulumi.String("example_value"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("OosParameter"),
 * 			},
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.oos.Parameter;
 * import com.pulumi.alicloud.oos.ParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var example = new Parameter("example", ParameterArgs.builder()
 *             .parameterName("my-Parameter")
 *             .type("String")
 *             .value("example_value")
 *             .description("example_value")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "OosParameter")
 *             ))
 *             .resourceGroupId(default_.groups()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:oos:Parameter
 *     properties:
 *       parameterName: my-Parameter
 *       type: String
 *       value: example_value
 *       description: example_value
 *       tags:
 *         Created: TF
 *         For: OosParameter
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Parameter can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/parameter:Parameter example <parameter_name>
 * ```
 * @property constraints The constraints of the common parameter. This value follows the json format. By default, this parameter is null. Valid values:
 * * `AllowedValues`: The value that is allowed for the common parameter. It must be an array string.
 * * `AllowedPattern`: The pattern that is allowed for the common parameter. It must be a regular expression.
 * * `MinLength`: The minimum length of the common parameter.
 * * `MaxLength`: The maximum length of the common parameter.
 * @property description The description of the common parameter. The description must be `1` to `200` characters in length.
 * @property parameterName The name of the common parameter. The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
 * @property resourceGroupId The ID of the Resource Group.
 * @property tags A mapping of tags to assign to the resource.
 * @property type The data type of the common parameter. Valid values: `String` and `StringList`.
 * @property value The value of the common parameter. The value must be `1` to `4096` characters in length.
 */
public data class ParameterArgs(
    public val constraints: Output<String>? = null,
    public val description: Output<String>? = null,
    public val parameterName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.ParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.ParameterArgs =
        com.pulumi.alicloud.oos.ParameterArgs.builder()
            .constraints(constraints?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameterName(parameterName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterArgs].
 */
@PulumiTagMarker
public class ParameterArgsBuilder internal constructor() {
    private var constraints: Output<String>? = null

    private var description: Output<String>? = null

    private var parameterName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The constraints of the common parameter. This value follows the json format. By default, this parameter is null. Valid values:
     * * `AllowedValues`: The value that is allowed for the common parameter. It must be an array string.
     * * `AllowedPattern`: The pattern that is allowed for the common parameter. It must be a regular expression.
     * * `MinLength`: The minimum length of the common parameter.
     * * `MaxLength`: The maximum length of the common parameter.
     */
    @JvmName("geasoppdffucqxsw")
    public suspend fun constraints(`value`: Output<String>) {
        this.constraints = value
    }

    /**
     * @param value The description of the common parameter. The description must be `1` to `200` characters in length.
     */
    @JvmName("vyqaaxqpgkbivrsa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the common parameter. The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
     */
    @JvmName("dwwhwscrppgpalrb")
    public suspend fun parameterName(`value`: Output<String>) {
        this.parameterName = value
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("ynuxewdetvdwbxgm")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("freclwbdwfebijgc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The data type of the common parameter. Valid values: `String` and `StringList`.
     */
    @JvmName("fmnvpatgwlnsuupc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value of the common parameter. The value must be `1` to `4096` characters in length.
     */
    @JvmName("qbggpelsxavviolu")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The constraints of the common parameter. This value follows the json format. By default, this parameter is null. Valid values:
     * * `AllowedValues`: The value that is allowed for the common parameter. It must be an array string.
     * * `AllowedPattern`: The pattern that is allowed for the common parameter. It must be a regular expression.
     * * `MinLength`: The minimum length of the common parameter.
     * * `MaxLength`: The maximum length of the common parameter.
     */
    @JvmName("tnekhvogwiwsprve")
    public suspend fun constraints(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constraints = mapped
    }

    /**
     * @param value The description of the common parameter. The description must be `1` to `200` characters in length.
     */
    @JvmName("aupwlfmlugwnsfak")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the common parameter. The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
     */
    @JvmName("ysujoduohabpnbge")
    public suspend fun parameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterName = mapped
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("ofaaheeslurjeqhf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("kawbrgfmjtyrcnyx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("gvnfehuxwdelubvf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The data type of the common parameter. Valid values: `String` and `StringList`.
     */
    @JvmName("ridpfkvpgvdtrqih")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of the common parameter. The value must be `1` to `4096` characters in length.
     */
    @JvmName("fmsxsoalawuliklb")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterArgs = ParameterArgs(
        constraints = constraints,
        description = description,
        parameterName = parameterName,
        resourceGroupId = resourceGroupId,
        tags = tags,
        type = type,
        `value` = `value`,
    )
}
