@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [PatchBaseline].
 */
@PulumiTagMarker
public class PatchBaselineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PatchBaselineArgs = PatchBaselineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PatchBaselineArgsBuilder.() -> Unit) {
        val builder = PatchBaselineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PatchBaseline {
        val builtJavaResource = com.pulumi.alicloud.oos.PatchBaseline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PatchBaseline(builtJavaResource)
    }
}

/**
 * Provides a OOS Patch Baseline resource.
 * For information about OOS Patch Baseline and how to use it, see [What is Patch Baseline](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/patch-manager-overview).
 * > **NOTE:** Available since v1.146.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.oos.PatchBaseline("default", {
 *     patchBaselineName: name,
 *     operationSystem: "Windows",
 *     approvalRules: "{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.oos.PatchBaseline("default",
 *     patch_baseline_name=name,
 *     operation_system="Windows",
 *     approval_rules="{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Oos.PatchBaseline("default", new()
 *     {
 *         PatchBaselineName = name,
 *         OperationSystem = "Windows",
 *         ApprovalRules = "{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := oos.NewPatchBaseline(ctx, "default", &oos.PatchBaselineArgs{
 * 			PatchBaselineName: pulumi.String(name),
 * 			OperationSystem:   pulumi.String("Windows"),
 * 			ApprovalRules:     pulumi.String("{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oos.PatchBaseline;
 * import com.pulumi.alicloud.oos.PatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new PatchBaseline("default", PatchBaselineArgs.builder()
 *             .patchBaselineName(name)
 *             .operationSystem("Windows")
 *             .approvalRules("{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:oos:PatchBaseline
 *     properties:
 *       patchBaselineName: ${name}
 *       operationSystem: Windows
 *       approvalRules: '{"PatchRules":[{"EnableNonSecurity":true,"PatchFilterGroup":[{"Values":["*"],"Key":"Product"},{"Values":["Security","Bugfix"],"Key":"Classification"},{"Values":["Critical","Important"],"Key":"Severity"}],"ApproveAfterDays":7,"ComplianceLevel":"Unspecified"}]}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Patch Baseline can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/patchBaseline:PatchBaseline example <id>
 * ```
 */
public class PatchBaseline internal constructor(
    override val javaResource: com.pulumi.alicloud.oos.PatchBaseline,
) : KotlinCustomResource(javaResource, PatchBaselineMapper) {
    /**
     * Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
     */
    public val approvalRules: Output<String>
        get() = javaResource.approvalRules().applyValue({ args0 -> args0 })

    /**
     * Approved Patch.
     */
    public val approvedPatches: Output<List<String>>?
        get() = javaResource.approvedPatches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * ApprovedPatchesEnableNonSecurity.
     */
    public val approvedPatchesEnableNonSecurity: Output<Boolean>?
        get() = javaResource.approvedPatchesEnableNonSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Patches baseline description information.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
     */
    public val operationSystem: Output<String>
        get() = javaResource.operationSystem().applyValue({ args0 -> args0 })

    /**
     * The name of the patch baseline.
     */
    public val patchBaselineName: Output<String>
        get() = javaResource.patchBaselineName().applyValue({ args0 -> args0 })

    /**
     * Reject patches.
     */
    public val rejectedPatches: Output<List<String>>?
        get() = javaResource.rejectedPatches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
     */
    public val rejectedPatchesAction: Output<String>
        get() = javaResource.rejectedPatchesAction().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Source.
     */
    public val sources: Output<List<String>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Label.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object PatchBaselineMapper : ResourceMapper<PatchBaseline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oos.PatchBaseline::class == javaResource::class

    override fun map(javaResource: Resource): PatchBaseline = PatchBaseline(
        javaResource as
            com.pulumi.alicloud.oos.PatchBaseline,
    )
}

/**
 * @see [PatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PatchBaseline].
 */
public suspend fun patchBaseline(
    name: String,
    block: suspend PatchBaselineResourceBuilder.() -> Unit,
): PatchBaseline {
    val builder = PatchBaselineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun patchBaseline(name: String): PatchBaseline {
    val builder = PatchBaselineResourceBuilder()
    builder.name(name)
    return builder.build()
}
