@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.PatchBaselineArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a OOS Patch Baseline resource.
 * For information about OOS Patch Baseline and how to use it, see [What is Patch Baseline](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/patch-manager-overview).
 * > **NOTE:** Available since v1.146.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.oos.PatchBaseline("default", {
 *     patchBaselineName: name,
 *     operationSystem: "Windows",
 *     approvalRules: "{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.oos.PatchBaseline("default",
 *     patch_baseline_name=name,
 *     operation_system="Windows",
 *     approval_rules="{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Oos.PatchBaseline("default", new()
 *     {
 *         PatchBaselineName = name,
 *         OperationSystem = "Windows",
 *         ApprovalRules = "{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := oos.NewPatchBaseline(ctx, "default", &oos.PatchBaselineArgs{
 * 			PatchBaselineName: pulumi.String(name),
 * 			OperationSystem:   pulumi.String("Windows"),
 * 			ApprovalRules:     pulumi.String("{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oos.PatchBaseline;
 * import com.pulumi.alicloud.oos.PatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new PatchBaseline("default", PatchBaselineArgs.builder()
 *             .patchBaselineName(name)
 *             .operationSystem("Windows")
 *             .approvalRules("{\"PatchRules\":[{\"EnableNonSecurity\":true,\"PatchFilterGroup\":[{\"Values\":[\"*\"],\"Key\":\"Product\"},{\"Values\":[\"Security\",\"Bugfix\"],\"Key\":\"Classification\"},{\"Values\":[\"Critical\",\"Important\"],\"Key\":\"Severity\"}],\"ApproveAfterDays\":7,\"ComplianceLevel\":\"Unspecified\"}]}")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:oos:PatchBaseline
 *     properties:
 *       patchBaselineName: ${name}
 *       operationSystem: Windows
 *       approvalRules: '{"PatchRules":[{"EnableNonSecurity":true,"PatchFilterGroup":[{"Values":["*"],"Key":"Product"},{"Values":["Security","Bugfix"],"Key":"Classification"},{"Values":["Critical","Important"],"Key":"Severity"}],"ApproveAfterDays":7,"ComplianceLevel":"Unspecified"}]}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Patch Baseline can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/patchBaseline:PatchBaseline example <id>
 * ```
 * @property approvalRules Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
 * @property approvedPatches Approved Patch.
 * @property approvedPatchesEnableNonSecurity ApprovedPatchesEnableNonSecurity.
 * @property description Patches baseline description information.
 * @property operationSystem Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
 * @property patchBaselineName The name of the patch baseline.
 * @property rejectedPatches Reject patches.
 * @property rejectedPatchesAction Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
 * @property resourceGroupId The ID of the resource group.
 * @property sources Source.
 * @property tags Label.
 */
public data class PatchBaselineArgs(
    public val approvalRules: Output<String>? = null,
    public val approvedPatches: Output<List<String>>? = null,
    public val approvedPatchesEnableNonSecurity: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val operationSystem: Output<String>? = null,
    public val patchBaselineName: Output<String>? = null,
    public val rejectedPatches: Output<List<String>>? = null,
    public val rejectedPatchesAction: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val sources: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.PatchBaselineArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.PatchBaselineArgs =
        com.pulumi.alicloud.oos.PatchBaselineArgs.builder()
            .approvalRules(approvalRules?.applyValue({ args0 -> args0 }))
            .approvedPatches(approvedPatches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .approvedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .operationSystem(operationSystem?.applyValue({ args0 -> args0 }))
            .patchBaselineName(patchBaselineName?.applyValue({ args0 -> args0 }))
            .rejectedPatches(rejectedPatches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .rejectedPatchesAction(rejectedPatchesAction?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .sources(sources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PatchBaselineArgs].
 */
@PulumiTagMarker
public class PatchBaselineArgsBuilder internal constructor() {
    private var approvalRules: Output<String>? = null

    private var approvedPatches: Output<List<String>>? = null

    private var approvedPatchesEnableNonSecurity: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var operationSystem: Output<String>? = null

    private var patchBaselineName: Output<String>? = null

    private var rejectedPatches: Output<List<String>>? = null

    private var rejectedPatchesAction: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var sources: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
     */
    @JvmName("drmetcqsypcmcjif")
    public suspend fun approvalRules(`value`: Output<String>) {
        this.approvalRules = value
    }

    /**
     * @param value Approved Patch.
     */
    @JvmName("pvmxpudixnigsmox")
    public suspend fun approvedPatches(`value`: Output<List<String>>) {
        this.approvedPatches = value
    }

    @JvmName("ulstubaoqoxddpkv")
    public suspend fun approvedPatches(vararg values: Output<String>) {
        this.approvedPatches = Output.all(values.asList())
    }

    /**
     * @param values Approved Patch.
     */
    @JvmName("tcyuyiqnmaqtcgfm")
    public suspend fun approvedPatches(values: List<Output<String>>) {
        this.approvedPatches = Output.all(values)
    }

    /**
     * @param value ApprovedPatchesEnableNonSecurity.
     */
    @JvmName("cmjyxfpnqpousfjq")
    public suspend fun approvedPatchesEnableNonSecurity(`value`: Output<Boolean>) {
        this.approvedPatchesEnableNonSecurity = value
    }

    /**
     * @param value Patches baseline description information.
     */
    @JvmName("mbrnvfnmsxmgyywb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
     */
    @JvmName("kjqqsdiesqnxkcsj")
    public suspend fun operationSystem(`value`: Output<String>) {
        this.operationSystem = value
    }

    /**
     * @param value The name of the patch baseline.
     */
    @JvmName("rtrdrtylhbnolxlj")
    public suspend fun patchBaselineName(`value`: Output<String>) {
        this.patchBaselineName = value
    }

    /**
     * @param value Reject patches.
     */
    @JvmName("pxnfngdnbglbkynm")
    public suspend fun rejectedPatches(`value`: Output<List<String>>) {
        this.rejectedPatches = value
    }

    @JvmName("wdggyjsffudvsgsc")
    public suspend fun rejectedPatches(vararg values: Output<String>) {
        this.rejectedPatches = Output.all(values.asList())
    }

    /**
     * @param values Reject patches.
     */
    @JvmName("pcgnjajpgcmvjwgm")
    public suspend fun rejectedPatches(values: List<Output<String>>) {
        this.rejectedPatches = Output.all(values)
    }

    /**
     * @param value Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
     */
    @JvmName("qxcwbvuxrvicxcdw")
    public suspend fun rejectedPatchesAction(`value`: Output<String>) {
        this.rejectedPatchesAction = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("fqmmtipkewhrsndr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Source.
     */
    @JvmName("qlhnqlgxuodrqetb")
    public suspend fun sources(`value`: Output<List<String>>) {
        this.sources = value
    }

    @JvmName("psjydhfjrnlvvluo")
    public suspend fun sources(vararg values: Output<String>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Source.
     */
    @JvmName("lwiafobeenmdxfmv")
    public suspend fun sources(values: List<Output<String>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value Label.
     */
    @JvmName("xhggscrekttkscyn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
     */
    @JvmName("nhxtqnojmvadweek")
    public suspend fun approvalRules(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param value Approved Patch.
     */
    @JvmName("ubfriulgiosadkvd")
    public suspend fun approvedPatches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatches = mapped
    }

    /**
     * @param values Approved Patch.
     */
    @JvmName("nllqbhemgakfeiaq")
    public suspend fun approvedPatches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.approvedPatches = mapped
    }

    /**
     * @param value ApprovedPatchesEnableNonSecurity.
     */
    @JvmName("ckpoxuskbteggxmw")
    public suspend fun approvedPatchesEnableNonSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatchesEnableNonSecurity = mapped
    }

    /**
     * @param value Patches baseline description information.
     */
    @JvmName("iojkcqfibivsvfcw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
     */
    @JvmName("dxfyfnosixedlyqt")
    public suspend fun operationSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationSystem = mapped
    }

    /**
     * @param value The name of the patch baseline.
     */
    @JvmName("lyrmubacnfgkrxyv")
    public suspend fun patchBaselineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchBaselineName = mapped
    }

    /**
     * @param value Reject patches.
     */
    @JvmName("qoqftskhbajwqaij")
    public suspend fun rejectedPatches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectedPatches = mapped
    }

    /**
     * @param values Reject patches.
     */
    @JvmName("gefseweporwuyqwh")
    public suspend fun rejectedPatches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rejectedPatches = mapped
    }

    /**
     * @param value Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
     */
    @JvmName("qtpsspnxoqeejbjp")
    public suspend fun rejectedPatchesAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectedPatchesAction = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("efhnkvlveqfpdrge")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Source.
     */
    @JvmName("etpurxnljsmfqoij")
    public suspend fun sources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param values Source.
     */
    @JvmName("eqlpasjggopsqsjh")
    public suspend fun sources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value Label.
     */
    @JvmName("iewuphsdaxynifbo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Label.
     */
    @JvmName("jtcdjcbylvdbfpbb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PatchBaselineArgs = PatchBaselineArgs(
        approvalRules = approvalRules,
        approvedPatches = approvedPatches,
        approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity,
        description = description,
        operationSystem = operationSystem,
        patchBaselineName = patchBaselineName,
        rejectedPatches = rejectedPatches,
        rejectedPatchesAction = rejectedPatchesAction,
        resourceGroupId = resourceGroupId,
        sources = sources,
        tags = tags,
    )
}
