@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SecretParameter].
 */
@PulumiTagMarker
public class SecretParameterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretParameterArgs = SecretParameterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretParameterArgsBuilder.() -> Unit) {
        val builder = SecretParameterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecretParameter {
        val builtJavaResource = com.pulumi.alicloud.oos.SecretParameter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecretParameter(builtJavaResource)
    }
}

/**
 * Provides a OOS Secret Parameter resource.
 * For information about OOS Secret Parameter and how to use it, see [What is Secret Parameter](https://www.alibabacloud.com/help/en/doc-detail/183418.html).
 * > **NOTE:** Available since v1.147.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.resourcemanager.getResourceGroups({});
 * const exampleKey = new alicloud.kms.Key("example", {
 *     description: "terraform-example",
 *     status: "Enabled",
 *     pendingWindowInDays: 7,
 * });
 * const exampleSecretParameter = new alicloud.oos.SecretParameter("example", {
 *     secretParameterName: "terraform-example",
 *     value: "terraform-example",
 *     type: "Secret",
 *     keyId: exampleKey.id,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "OosSecretParameter",
 *     },
 *     resourceGroupId: example.then(example => example.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.resourcemanager.get_resource_groups()
 * example_key = alicloud.kms.Key("example",
 *     description="terraform-example",
 *     status="Enabled",
 *     pending_window_in_days=7)
 * example_secret_parameter = alicloud.oos.SecretParameter("example",
 *     secret_parameter_name="terraform-example",
 *     value="terraform-example",
 *     type="Secret",
 *     key_id=example_key.id,
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "OosSecretParameter",
 *     },
 *     resource_group_id=example.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var exampleKey = new AliCloud.Kms.Key("example", new()
 *     {
 *         Description = "terraform-example",
 *         Status = "Enabled",
 *         PendingWindowInDays = 7,
 *     });
 *     var exampleSecretParameter = new AliCloud.Oos.SecretParameter("example", new()
 *     {
 *         SecretParameterName = "terraform-example",
 *         Value = "terraform-example",
 *         Type = "Secret",
 *         KeyId = exampleKey.Id,
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "OosSecretParameter" },
 *         },
 *         ResourceGroupId = example.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:         pulumi.String("terraform-example"),
 * 			Status:              pulumi.String("Enabled"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewSecretParameter(ctx, "example", &oos.SecretParameterArgs{
 * 			SecretParameterName: pulumi.String("terraform-example"),
 * 			Value:               pulumi.String("terraform-example"),
 * 			Type:                pulumi.String("Secret"),
 * 			KeyId:               exampleKey.ID(),
 * 			Description:         pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("OosSecretParameter"),
 * 			},
 * 			ResourceGroupId: pulumi.String(example.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import com.pulumi.alicloud.oos.SecretParameter;
 * import com.pulumi.alicloud.oos.SecretParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = ResourcemanagerFunctions.getResourceGroups();
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("terraform-example")
 *             .status("Enabled")
 *             .pendingWindowInDays(7)
 *             .build());
 *         var exampleSecretParameter = new SecretParameter("exampleSecretParameter", SecretParameterArgs.builder()
 *             .secretParameterName("terraform-example")
 *             .value("terraform-example")
 *             .type("Secret")
 *             .keyId(exampleKey.id())
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "OosSecretParameter")
 *             ))
 *             .resourceGroupId(example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: alicloud:kms:Key
 *     name: example
 *     properties:
 *       description: terraform-example
 *       status: Enabled
 *       pendingWindowInDays: 7
 *   exampleSecretParameter:
 *     type: alicloud:oos:SecretParameter
 *     name: example
 *     properties:
 *       secretParameterName: terraform-example
 *       value: terraform-example
 *       type: Secret
 *       keyId: ${exampleKey.id}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: OosSecretParameter
 *       resourceGroupId: ${example.groups[0].id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Secret Parameter can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/secretParameter:SecretParameter example <secret_parameter_name>
 * ```
 */
public class SecretParameter internal constructor(
    override val javaResource: com.pulumi.alicloud.oos.SecretParameter,
) : KotlinCustomResource(javaResource, SecretParameterMapper) {
    /**
     * The constraints of the encryption parameter. By default, this parameter is null. Valid values:
     * * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
     * * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
     * * `MinLength`: The minimum length of the encryption parameter.
     * * `MaxLength`: The maximum length of the encryption parameter.
     */
    public val constraints: Output<String>?
        get() = javaResource.constraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the encryption parameter. The description must be `1` to `200` characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
     */
    public val keyId: Output<String>?
        get() = javaResource.keyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the Resource Group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
     */
    public val secretParameterName: Output<String>
        get() = javaResource.secretParameterName().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The data type of the encryption parameter. Valid values: `Secret`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The value of the encryption parameter. The value must be `1` to `4096` characters in length.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object SecretParameterMapper : ResourceMapper<SecretParameter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oos.SecretParameter::class == javaResource::class

    override fun map(javaResource: Resource): SecretParameter = SecretParameter(
        javaResource as
            com.pulumi.alicloud.oos.SecretParameter,
    )
}

/**
 * @see [SecretParameter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecretParameter].
 */
public suspend fun secretParameter(
    name: String,
    block: suspend SecretParameterResourceBuilder.() -> Unit,
): SecretParameter {
    val builder = SecretParameterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecretParameter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secretParameter(name: String): SecretParameter {
    val builder = SecretParameterResourceBuilder()
    builder.name(name)
    return builder.build()
}
