@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.SecretParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a OOS Secret Parameter resource.
 * For information about OOS Secret Parameter and how to use it, see [What is Secret Parameter](https://www.alibabacloud.com/help/en/doc-detail/183418.html).
 * > **NOTE:** Available since v1.147.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.resourcemanager.getResourceGroups({});
 * const exampleKey = new alicloud.kms.Key("example", {
 *     description: "terraform-example",
 *     status: "Enabled",
 *     pendingWindowInDays: 7,
 * });
 * const exampleSecretParameter = new alicloud.oos.SecretParameter("example", {
 *     secretParameterName: "terraform-example",
 *     value: "terraform-example",
 *     type: "Secret",
 *     keyId: exampleKey.id,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "OosSecretParameter",
 *     },
 *     resourceGroupId: example.then(example => example.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.resourcemanager.get_resource_groups()
 * example_key = alicloud.kms.Key("example",
 *     description="terraform-example",
 *     status="Enabled",
 *     pending_window_in_days=7)
 * example_secret_parameter = alicloud.oos.SecretParameter("example",
 *     secret_parameter_name="terraform-example",
 *     value="terraform-example",
 *     type="Secret",
 *     key_id=example_key.id,
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "OosSecretParameter",
 *     },
 *     resource_group_id=example.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var exampleKey = new AliCloud.Kms.Key("example", new()
 *     {
 *         Description = "terraform-example",
 *         Status = "Enabled",
 *         PendingWindowInDays = 7,
 *     });
 *     var exampleSecretParameter = new AliCloud.Oos.SecretParameter("example", new()
 *     {
 *         SecretParameterName = "terraform-example",
 *         Value = "terraform-example",
 *         Type = "Secret",
 *         KeyId = exampleKey.Id,
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "OosSecretParameter" },
 *         },
 *         ResourceGroupId = example.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:         pulumi.String("terraform-example"),
 * 			Status:              pulumi.String("Enabled"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewSecretParameter(ctx, "example", &oos.SecretParameterArgs{
 * 			SecretParameterName: pulumi.String("terraform-example"),
 * 			Value:               pulumi.String("terraform-example"),
 * 			Type:                pulumi.String("Secret"),
 * 			KeyId:               exampleKey.ID(),
 * 			Description:         pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("OosSecretParameter"),
 * 			},
 * 			ResourceGroupId: pulumi.String(example.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import com.pulumi.alicloud.oos.SecretParameter;
 * import com.pulumi.alicloud.oos.SecretParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = ResourcemanagerFunctions.getResourceGroups();
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("terraform-example")
 *             .status("Enabled")
 *             .pendingWindowInDays(7)
 *             .build());
 *         var exampleSecretParameter = new SecretParameter("exampleSecretParameter", SecretParameterArgs.builder()
 *             .secretParameterName("terraform-example")
 *             .value("terraform-example")
 *             .type("Secret")
 *             .keyId(exampleKey.id())
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "OosSecretParameter")
 *             ))
 *             .resourceGroupId(example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: alicloud:kms:Key
 *     name: example
 *     properties:
 *       description: terraform-example
 *       status: Enabled
 *       pendingWindowInDays: 7
 *   exampleSecretParameter:
 *     type: alicloud:oos:SecretParameter
 *     name: example
 *     properties:
 *       secretParameterName: terraform-example
 *       value: terraform-example
 *       type: Secret
 *       keyId: ${exampleKey.id}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: OosSecretParameter
 *       resourceGroupId: ${example.groups[0].id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Secret Parameter can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/secretParameter:SecretParameter example <secret_parameter_name>
 * ```
 * @property constraints The constraints of the encryption parameter. By default, this parameter is null. Valid values:
 * * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
 * * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
 * * `MinLength`: The minimum length of the encryption parameter.
 * * `MaxLength`: The maximum length of the encryption parameter.
 * @property description The description of the encryption parameter. The description must be `1` to `200` characters in length.
 * @property keyId The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
 * @property resourceGroupId The ID of the Resource Group.
 * @property secretParameterName The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
 * @property tags A mapping of tags to assign to the resource.
 * @property type The data type of the encryption parameter. Valid values: `Secret`.
 * @property value The value of the encryption parameter. The value must be `1` to `4096` characters in length.
 */
public data class SecretParameterArgs(
    public val constraints: Output<String>? = null,
    public val description: Output<String>? = null,
    public val keyId: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val secretParameterName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.SecretParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.SecretParameterArgs =
        com.pulumi.alicloud.oos.SecretParameterArgs.builder()
            .constraints(constraints?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .secretParameterName(secretParameterName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretParameterArgs].
 */
@PulumiTagMarker
public class SecretParameterArgsBuilder internal constructor() {
    private var constraints: Output<String>? = null

    private var description: Output<String>? = null

    private var keyId: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var secretParameterName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The constraints of the encryption parameter. By default, this parameter is null. Valid values:
     * * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
     * * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
     * * `MinLength`: The minimum length of the encryption parameter.
     * * `MaxLength`: The maximum length of the encryption parameter.
     */
    @JvmName("ufjaemeeqmmwhcle")
    public suspend fun constraints(`value`: Output<String>) {
        this.constraints = value
    }

    /**
     * @param value The description of the encryption parameter. The description must be `1` to `200` characters in length.
     */
    @JvmName("nyrbsttcqccpkcqe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
     */
    @JvmName("ocwkgwtbdoxgiqpm")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("lqtvxgsjashlcseu")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
     */
    @JvmName("wnvncfyhavmgvdbc")
    public suspend fun secretParameterName(`value`: Output<String>) {
        this.secretParameterName = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("nvrnhsasiuompdkh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The data type of the encryption parameter. Valid values: `Secret`.
     */
    @JvmName("btplowbvtppombvr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value of the encryption parameter. The value must be `1` to `4096` characters in length.
     */
    @JvmName("jxkfuussnfvttstl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The constraints of the encryption parameter. By default, this parameter is null. Valid values:
     * * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
     * * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
     * * `MinLength`: The minimum length of the encryption parameter.
     * * `MaxLength`: The maximum length of the encryption parameter.
     */
    @JvmName("hsocacodxqcsxtux")
    public suspend fun constraints(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constraints = mapped
    }

    /**
     * @param value The description of the encryption parameter. The description must be `1` to `200` characters in length.
     */
    @JvmName("kuhangelpjcxjien")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
     */
    @JvmName("pwyxiskwrxpuispo")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("kaupodtowamixsfd")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
     */
    @JvmName("qgdfqbgqllkyjswf")
    public suspend fun secretParameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretParameterName = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("lqsjraxbempuaokk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("urhqdnckxsenwhfg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The data type of the encryption parameter. Valid values: `Secret`.
     */
    @JvmName("duotubxaluyrnwvu")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of the encryption parameter. The value must be `1` to `4096` characters in length.
     */
    @JvmName("nwqcudajsotkfsgx")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecretParameterArgs = SecretParameterArgs(
        constraints = constraints,
        description = description,
        keyId = keyId,
        resourceGroupId = resourceGroupId,
        secretParameterName = secretParameterName,
        tags = tags,
        type = type,
        `value` = `value`,
    )
}
