@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.ServiceSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a OOS Service Setting resource.
 * For information about OOS Service Setting and how to use it, see [What is Service Setting](https://www.alibabacloud.com/help/en/doc-detail/268700.html).
 * > **NOTE:** Available in v1.147.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testaccoossetting";
 * const _default = new alicloud.oss.Bucket("default", {
 *     bucket: name,
 *     acl: "public-read-write",
 * });
 * const defaultProject = new alicloud.log.Project("default", {name: name});
 * const defaultServiceSetting = new alicloud.oos.ServiceSetting("default", {
 *     deliveryOssEnabled: true,
 *     deliveryOssKeyPrefix: "path1/",
 *     deliveryOssBucketName: _default.bucket,
 *     deliverySlsEnabled: true,
 *     deliverySlsProjectName: defaultProject.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testaccoossetting"
 * default = alicloud.oss.Bucket("default",
 *     bucket=name,
 *     acl="public-read-write")
 * default_project = alicloud.log.Project("default", name=name)
 * default_service_setting = alicloud.oos.ServiceSetting("default",
 *     delivery_oss_enabled=True,
 *     delivery_oss_key_prefix="path1/",
 *     delivery_oss_bucket_name=default.bucket,
 *     delivery_sls_enabled=True,
 *     delivery_sls_project_name=default_project.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testaccoossetting";
 *     var @default = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = name,
 *         Acl = "public-read-write",
 *     });
 *     var defaultProject = new AliCloud.Log.Project("default", new()
 *     {
 *         Name = name,
 *     });
 *     var defaultServiceSetting = new AliCloud.Oos.ServiceSetting("default", new()
 *     {
 *         DeliveryOssEnabled = true,
 *         DeliveryOssKeyPrefix = "path1/",
 *         DeliveryOssBucketName = @default.BucketName,
 *         DeliverySlsEnabled = true,
 *         DeliverySlsProjectName = defaultProject.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testaccoossetting"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.String(name),
 * 			Acl:    pulumi.String("public-read-write"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultProject, err := log.NewProject(ctx, "default", &log.ProjectArgs{
 * 			Name: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewServiceSetting(ctx, "default", &oos.ServiceSettingArgs{
 * 			DeliveryOssEnabled:     pulumi.Bool(true),
 * 			DeliveryOssKeyPrefix:   pulumi.String("path1/"),
 * 			DeliveryOssBucketName:  _default.Bucket,
 * 			DeliverySlsEnabled:     pulumi.Bool(true),
 * 			DeliverySlsProjectName: defaultProject.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.oos.ServiceSetting;
 * import com.pulumi.alicloud.oos.ServiceSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testaccoossetting");
 *         var default_ = new Bucket("default", BucketArgs.builder()
 *             .bucket(name)
 *             .acl("public-read-write")
 *             .build());
 *         var defaultProject = new Project("defaultProject", ProjectArgs.builder()
 *             .name(name)
 *             .build());
 *         var defaultServiceSetting = new ServiceSetting("defaultServiceSetting", ServiceSettingArgs.builder()
 *             .deliveryOssEnabled(true)
 *             .deliveryOssKeyPrefix("path1/")
 *             .deliveryOssBucketName(default_.bucket())
 *             .deliverySlsEnabled(true)
 *             .deliverySlsProjectName(defaultProject.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testaccoossetting
 * resources:
 *   default:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: ${name}
 *       acl: public-read-write
 *   defaultProject:
 *     type: alicloud:log:Project
 *     name: default
 *     properties:
 *       name: ${name}
 *   defaultServiceSetting:
 *     type: alicloud:oos:ServiceSetting
 *     name: default
 *     properties:
 *       deliveryOssEnabled: true
 *       deliveryOssKeyPrefix: path1/
 *       deliveryOssBucketName: ${default.bucket}
 *       deliverySlsEnabled: true
 *       deliverySlsProjectName: ${defaultProject.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Service Setting can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/serviceSetting:ServiceSetting example <id>
 * ```
 * @property deliveryOssBucketName The name of the OSS bucket. **NOTE:** When the `delivery_oss_enabled` is `true`, The `delivery_oss_bucket_name` is valid.
 * @property deliveryOssEnabled Is the recording function for the OSS delivery template enabled.
 * @property deliveryOssKeyPrefix The Directory of the OSS bucket. **NOTE:** When the `delivery_oss_enabled` is `true`, The `delivery_oss_bucket_name` is valid.
 * @property deliverySlsEnabled Is the execution record function to SLS delivery Template turned on.
 * @property deliverySlsProjectName The name of SLS  Project. **NOTE:** When the `delivery_sls_enabled` is `true`, The `delivery_sls_project_name` is valid.
 */
public data class ServiceSettingArgs(
    public val deliveryOssBucketName: Output<String>? = null,
    public val deliveryOssEnabled: Output<Boolean>? = null,
    public val deliveryOssKeyPrefix: Output<String>? = null,
    public val deliverySlsEnabled: Output<Boolean>? = null,
    public val deliverySlsProjectName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.ServiceSettingArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.ServiceSettingArgs =
        com.pulumi.alicloud.oos.ServiceSettingArgs.builder()
            .deliveryOssBucketName(deliveryOssBucketName?.applyValue({ args0 -> args0 }))
            .deliveryOssEnabled(deliveryOssEnabled?.applyValue({ args0 -> args0 }))
            .deliveryOssKeyPrefix(deliveryOssKeyPrefix?.applyValue({ args0 -> args0 }))
            .deliverySlsEnabled(deliverySlsEnabled?.applyValue({ args0 -> args0 }))
            .deliverySlsProjectName(deliverySlsProjectName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSettingArgs].
 */
@PulumiTagMarker
public class ServiceSettingArgsBuilder internal constructor() {
    private var deliveryOssBucketName: Output<String>? = null

    private var deliveryOssEnabled: Output<Boolean>? = null

    private var deliveryOssKeyPrefix: Output<String>? = null

    private var deliverySlsEnabled: Output<Boolean>? = null

    private var deliverySlsProjectName: Output<String>? = null

    /**
     * @param value The name of the OSS bucket. **NOTE:** When the `delivery_oss_enabled` is `true`, The `delivery_oss_bucket_name` is valid.
     */
    @JvmName("clsjfcndheknewgp")
    public suspend fun deliveryOssBucketName(`value`: Output<String>) {
        this.deliveryOssBucketName = value
    }

    /**
     * @param value Is the recording function for the OSS delivery template enabled.
     */
    @JvmName("pjgrfleceqomiaim")
    public suspend fun deliveryOssEnabled(`value`: Output<Boolean>) {
        this.deliveryOssEnabled = value
    }

    /**
     * @param value The Directory of the OSS bucket. **NOTE:** When the `delivery_oss_enabled` is `true`, The `delivery_oss_bucket_name` is valid.
     */
    @JvmName("adgiuwxthohcgaau")
    public suspend fun deliveryOssKeyPrefix(`value`: Output<String>) {
        this.deliveryOssKeyPrefix = value
    }

    /**
     * @param value Is the execution record function to SLS delivery Template turned on.
     */
    @JvmName("lajdwnqyrnnxhiwv")
    public suspend fun deliverySlsEnabled(`value`: Output<Boolean>) {
        this.deliverySlsEnabled = value
    }

    /**
     * @param value The name of SLS  Project. **NOTE:** When the `delivery_sls_enabled` is `true`, The `delivery_sls_project_name` is valid.
     */
    @JvmName("dnmflamayijpwqdp")
    public suspend fun deliverySlsProjectName(`value`: Output<String>) {
        this.deliverySlsProjectName = value
    }

    /**
     * @param value The name of the OSS bucket. **NOTE:** When the `delivery_oss_enabled` is `true`, The `delivery_oss_bucket_name` is valid.
     */
    @JvmName("nhaihcuvetlfjxka")
    public suspend fun deliveryOssBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryOssBucketName = mapped
    }

    /**
     * @param value Is the recording function for the OSS delivery template enabled.
     */
    @JvmName("qcrvkdkopxouybon")
    public suspend fun deliveryOssEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryOssEnabled = mapped
    }

    /**
     * @param value The Directory of the OSS bucket. **NOTE:** When the `delivery_oss_enabled` is `true`, The `delivery_oss_bucket_name` is valid.
     */
    @JvmName("rbxoixvcpmqygpii")
    public suspend fun deliveryOssKeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryOssKeyPrefix = mapped
    }

    /**
     * @param value Is the execution record function to SLS delivery Template turned on.
     */
    @JvmName("qisfwfojfbrcxjtn")
    public suspend fun deliverySlsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliverySlsEnabled = mapped
    }

    /**
     * @param value The name of SLS  Project. **NOTE:** When the `delivery_sls_enabled` is `true`, The `delivery_sls_project_name` is valid.
     */
    @JvmName("vfmemijuvyytwron")
    public suspend fun deliverySlsProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliverySlsProjectName = mapped
    }

    internal fun build(): ServiceSettingArgs = ServiceSettingArgs(
        deliveryOssBucketName = deliveryOssBucketName,
        deliveryOssEnabled = deliveryOssEnabled,
        deliveryOssKeyPrefix = deliveryOssKeyPrefix,
        deliverySlsEnabled = deliverySlsEnabled,
        deliverySlsProjectName = deliverySlsProjectName,
    )
}
