@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [StateConfiguration].
 */
@PulumiTagMarker
public class StateConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StateConfigurationArgs = StateConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StateConfigurationArgsBuilder.() -> Unit) {
        val builder = StateConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StateConfiguration {
        val builtJavaResource = com.pulumi.alicloud.oos.StateConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StateConfiguration(builtJavaResource)
    }
}

/**
 * Provides a OOS State Configuration resource.
 * For information about OOS State Configuration and how to use it, see [What is State Configuration](https://www.alibabacloud.com/help/en/doc-detail/208728.html).
 * > **NOTE:** Available in v1.147.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultStateConfiguration = new alicloud.oos.StateConfiguration("default", {
 *     templateName: "ACS-ECS-InventoryDataCollection",
 *     configureMode: "ApplyOnly",
 *     description: "terraform-example",
 *     scheduleType: "rate",
 *     scheduleExpression: "1 hour",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     targets: "{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}",
 *     parameters: "{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_state_configuration = alicloud.oos.StateConfiguration("default",
 *     template_name="ACS-ECS-InventoryDataCollection",
 *     configure_mode="ApplyOnly",
 *     description="terraform-example",
 *     schedule_type="rate",
 *     schedule_expression="1 hour",
 *     resource_group_id=default.ids[0],
 *     targets="{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}",
 *     parameters="{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultStateConfiguration = new AliCloud.Oos.StateConfiguration("default", new()
 *     {
 *         TemplateName = "ACS-ECS-InventoryDataCollection",
 *         ConfigureMode = "ApplyOnly",
 *         Description = "terraform-example",
 *         ScheduleType = "rate",
 *         ScheduleExpression = "1 hour",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         Targets = "{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}",
 *         Parameters = "{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewStateConfiguration(ctx, "default", &oos.StateConfigurationArgs{
 * 			TemplateName:       pulumi.String("ACS-ECS-InventoryDataCollection"),
 * 			ConfigureMode:      pulumi.String("ApplyOnly"),
 * 			Description:        pulumi.String("terraform-example"),
 * 			ScheduleType:       pulumi.String("rate"),
 * 			ScheduleExpression: pulumi.String("1 hour"),
 * 			ResourceGroupId:    pulumi.String(_default.Ids[0]),
 * 			Targets:            pulumi.String("{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}"),
 * 			Parameters:         pulumi.String("{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.oos.StateConfiguration;
 * import com.pulumi.alicloud.oos.StateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultStateConfiguration = new StateConfiguration("defaultStateConfiguration", StateConfigurationArgs.builder()
 *             .templateName("ACS-ECS-InventoryDataCollection")
 *             .configureMode("ApplyOnly")
 *             .description("terraform-example")
 *             .scheduleType("rate")
 *             .scheduleExpression("1 hour")
 *             .resourceGroupId(default_.ids()[0])
 *             .targets("{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}")
 *             .parameters("{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultStateConfiguration:
 *     type: alicloud:oos:StateConfiguration
 *     name: default
 *     properties:
 *       templateName: ACS-ECS-InventoryDataCollection
 *       configureMode: ApplyOnly
 *       description: terraform-example
 *       scheduleType: rate
 *       scheduleExpression: 1 hour
 *       resourceGroupId: ${default.ids[0]}
 *       targets: '{"Filters": [{"Type": "All", "Parameters": {"InstanceChargeType": "PrePaid"}}], "ResourceType": "ALIYUN::ECS::Instance"}'
 *       parameters: '{"policy": {"ACS:Application": {"Collection": "Enabled"}}}'
 *       tags:
 *         Created: TF
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS State Configuration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/stateConfiguration:StateConfiguration example <id>
 * ```
 */
public class StateConfiguration internal constructor(
    override val javaResource: com.pulumi.alicloud.oos.StateConfiguration,
) : KotlinCustomResource(javaResource, StateConfigurationMapper) {
    /**
     * Configuration mode. Valid values: `ApplyAndAutoCorrect`, `ApplyAndMonitor`, `ApplyOnly`.
     */
    public val configureMode: Output<String>
        get() = javaResource.configureMode().applyValue({ args0 -> args0 })

    /**
     * The description of the resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The parameter of the Template. This field is in the format of JSON strings. For detailed definition instructions, please refer to [Metadata types that are supported by a configuration list](https://www.alibabacloud.com/help/en/doc-detail/208276.html).
     */
    public val parameters: Output<String>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Timing expression.
     */
    public val scheduleExpression: Output<String>
        get() = javaResource.scheduleExpression().applyValue({ args0 -> args0 })

    /**
     * Timing type. Valid values: `rate`.
     */
    public val scheduleType: Output<String>
        get() = javaResource.scheduleType().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The Target resources.  This field is in the format of JSON strings. For detailed definition instructions, please refer to [Parameter](https://www.alibabacloud.com/help/en/doc-detail/120674.html).
     */
    public val targets: Output<String>
        get() = javaResource.targets().applyValue({ args0 -> args0 })

    /**
     * The name of the template.
     */
    public val templateName: Output<String>
        get() = javaResource.templateName().applyValue({ args0 -> args0 })

    /**
     * The version number. If you do not specify this parameter, the system uses the latest version.
     */
    public val templateVersion: Output<String>
        get() = javaResource.templateVersion().applyValue({ args0 -> args0 })
}

public object StateConfigurationMapper : ResourceMapper<StateConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oos.StateConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): StateConfiguration = StateConfiguration(
        javaResource as
            com.pulumi.alicloud.oos.StateConfiguration,
    )
}

/**
 * @see [StateConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StateConfiguration].
 */
public suspend fun stateConfiguration(
    name: String,
    block: suspend StateConfigurationResourceBuilder.() -> Unit,
): StateConfiguration {
    val builder = StateConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StateConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stateConfiguration(name: String): StateConfiguration {
    val builder = StateConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
