@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.StateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a OOS State Configuration resource.
 * For information about OOS State Configuration and how to use it, see [What is State Configuration](https://www.alibabacloud.com/help/en/doc-detail/208728.html).
 * > **NOTE:** Available in v1.147.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultStateConfiguration = new alicloud.oos.StateConfiguration("default", {
 *     templateName: "ACS-ECS-InventoryDataCollection",
 *     configureMode: "ApplyOnly",
 *     description: "terraform-example",
 *     scheduleType: "rate",
 *     scheduleExpression: "1 hour",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     targets: "{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}",
 *     parameters: "{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_state_configuration = alicloud.oos.StateConfiguration("default",
 *     template_name="ACS-ECS-InventoryDataCollection",
 *     configure_mode="ApplyOnly",
 *     description="terraform-example",
 *     schedule_type="rate",
 *     schedule_expression="1 hour",
 *     resource_group_id=default.ids[0],
 *     targets="{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}",
 *     parameters="{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultStateConfiguration = new AliCloud.Oos.StateConfiguration("default", new()
 *     {
 *         TemplateName = "ACS-ECS-InventoryDataCollection",
 *         ConfigureMode = "ApplyOnly",
 *         Description = "terraform-example",
 *         ScheduleType = "rate",
 *         ScheduleExpression = "1 hour",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         Targets = "{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}",
 *         Parameters = "{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oos.NewStateConfiguration(ctx, "default", &oos.StateConfigurationArgs{
 * 			TemplateName:       pulumi.String("ACS-ECS-InventoryDataCollection"),
 * 			ConfigureMode:      pulumi.String("ApplyOnly"),
 * 			Description:        pulumi.String("terraform-example"),
 * 			ScheduleType:       pulumi.String("rate"),
 * 			ScheduleExpression: pulumi.String("1 hour"),
 * 			ResourceGroupId:    pulumi.String(_default.Ids[0]),
 * 			Targets:            pulumi.String("{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}"),
 * 			Parameters:         pulumi.String("{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.oos.StateConfiguration;
 * import com.pulumi.alicloud.oos.StateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultStateConfiguration = new StateConfiguration("defaultStateConfiguration", StateConfigurationArgs.builder()
 *             .templateName("ACS-ECS-InventoryDataCollection")
 *             .configureMode("ApplyOnly")
 *             .description("terraform-example")
 *             .scheduleType("rate")
 *             .scheduleExpression("1 hour")
 *             .resourceGroupId(default_.ids()[0])
 *             .targets("{\"Filters\": [{\"Type\": \"All\", \"Parameters\": {\"InstanceChargeType\": \"PrePaid\"}}], \"ResourceType\": \"ALIYUN::ECS::Instance\"}")
 *             .parameters("{\"policy\": {\"ACS:Application\": {\"Collection\": \"Enabled\"}}}")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultStateConfiguration:
 *     type: alicloud:oos:StateConfiguration
 *     name: default
 *     properties:
 *       templateName: ACS-ECS-InventoryDataCollection
 *       configureMode: ApplyOnly
 *       description: terraform-example
 *       scheduleType: rate
 *       scheduleExpression: 1 hour
 *       resourceGroupId: ${default.ids[0]}
 *       targets: '{"Filters": [{"Type": "All", "Parameters": {"InstanceChargeType": "PrePaid"}}], "ResourceType": "ALIYUN::ECS::Instance"}'
 *       parameters: '{"policy": {"ACS:Application": {"Collection": "Enabled"}}}'
 *       tags:
 *         Created: TF
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS State Configuration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/stateConfiguration:StateConfiguration example <id>
 * ```
 * @property configureMode Configuration mode. Valid values: `ApplyAndAutoCorrect`, `ApplyAndMonitor`, `ApplyOnly`.
 * @property description The description of the resource.
 * @property parameters The parameter of the Template. This field is in the format of JSON strings. For detailed definition instructions, please refer to [Metadata types that are supported by a configuration list](https://www.alibabacloud.com/help/en/doc-detail/208276.html).
 * @property resourceGroupId The ID of the resource group.
 * @property scheduleExpression Timing expression.
 * @property scheduleType Timing type. Valid values: `rate`.
 * @property tags The tag of the resource.
 * @property targets The Target resources.  This field is in the format of JSON strings. For detailed definition instructions, please refer to [Parameter](https://www.alibabacloud.com/help/en/doc-detail/120674.html).
 * @property templateName The name of the template.
 * @property templateVersion The version number. If you do not specify this parameter, the system uses the latest version.
 */
public data class StateConfigurationArgs(
    public val configureMode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scheduleExpression: Output<String>? = null,
    public val scheduleType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targets: Output<String>? = null,
    public val templateName: Output<String>? = null,
    public val templateVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.StateConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.StateConfigurationArgs =
        com.pulumi.alicloud.oos.StateConfigurationArgs.builder()
            .configureMode(configureMode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression?.applyValue({ args0 -> args0 }))
            .scheduleType(scheduleType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targets(targets?.applyValue({ args0 -> args0 }))
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .templateVersion(templateVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StateConfigurationArgs].
 */
@PulumiTagMarker
public class StateConfigurationArgsBuilder internal constructor() {
    private var configureMode: Output<String>? = null

    private var description: Output<String>? = null

    private var parameters: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    private var scheduleType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targets: Output<String>? = null

    private var templateName: Output<String>? = null

    private var templateVersion: Output<String>? = null

    /**
     * @param value Configuration mode. Valid values: `ApplyAndAutoCorrect`, `ApplyAndMonitor`, `ApplyOnly`.
     */
    @JvmName("kepcptokrnugyyqs")
    public suspend fun configureMode(`value`: Output<String>) {
        this.configureMode = value
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("hyvvyctfjqnkoggm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The parameter of the Template. This field is in the format of JSON strings. For detailed definition instructions, please refer to [Metadata types that are supported by a configuration list](https://www.alibabacloud.com/help/en/doc-detail/208276.html).
     */
    @JvmName("wiyxocnbqmlergls")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("bqfkbmyqfdcmmyas")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Timing expression.
     */
    @JvmName("xdifyxarxgeufuyp")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value Timing type. Valid values: `rate`.
     */
    @JvmName("qtllklnfkekwkxgn")
    public suspend fun scheduleType(`value`: Output<String>) {
        this.scheduleType = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("fqrigxlcwfwgqyak")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Target resources.  This field is in the format of JSON strings. For detailed definition instructions, please refer to [Parameter](https://www.alibabacloud.com/help/en/doc-detail/120674.html).
     */
    @JvmName("qphdydxoamfegwwr")
    public suspend fun targets(`value`: Output<String>) {
        this.targets = value
    }

    /**
     * @param value The name of the template.
     */
    @JvmName("bjyxrhilhplwpaxo")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value The version number. If you do not specify this parameter, the system uses the latest version.
     */
    @JvmName("tyoqjblcxtgmwybp")
    public suspend fun templateVersion(`value`: Output<String>) {
        this.templateVersion = value
    }

    /**
     * @param value Configuration mode. Valid values: `ApplyAndAutoCorrect`, `ApplyAndMonitor`, `ApplyOnly`.
     */
    @JvmName("bqeagswrojmveovv")
    public suspend fun configureMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configureMode = mapped
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("agtbakpnhktythfg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The parameter of the Template. This field is in the format of JSON strings. For detailed definition instructions, please refer to [Metadata types that are supported by a configuration list](https://www.alibabacloud.com/help/en/doc-detail/208276.html).
     */
    @JvmName("ksiqmjwhwwlaxhns")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("xkdojjmgrrimivkq")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Timing expression.
     */
    @JvmName("erkjhftcraupbndk")
    public suspend fun scheduleExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    /**
     * @param value Timing type. Valid values: `rate`.
     */
    @JvmName("cneswjpqqrjdkagn")
    public suspend fun scheduleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleType = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("ignvtibmxctubcxp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("hgpsqwcedverctce")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Target resources.  This field is in the format of JSON strings. For detailed definition instructions, please refer to [Parameter](https://www.alibabacloud.com/help/en/doc-detail/120674.html).
     */
    @JvmName("ppvkuwyoibpvdjuj")
    public suspend fun targets(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value The name of the template.
     */
    @JvmName("qrydrelmclxibnsd")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value The version number. If you do not specify this parameter, the system uses the latest version.
     */
    @JvmName("xltwhpicmhqjjncm")
    public suspend fun templateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateVersion = mapped
    }

    internal fun build(): StateConfigurationArgs = StateConfigurationArgs(
        configureMode = configureMode,
        description = description,
        parameters = parameters,
        resourceGroupId = resourceGroupId,
        scheduleExpression = scheduleExpression,
        scheduleType = scheduleType,
        tags = tags,
        targets = targets,
        templateName = templateName,
        templateVersion = templateVersion,
    )
}
