@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Template].
 */
@PulumiTagMarker
public class TemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateArgs = TemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateArgsBuilder.() -> Unit) {
        val builder = TemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Template {
        val builtJavaResource = com.pulumi.alicloud.oos.Template(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Template(builtJavaResource)
    }
}

/**
 * Provides a OOS Template resource. For information about Alicloud OOS Template and how to use it, see [What is Resource Alicloud OOS Template](https://www.alibabacloud.com/help/doc-detail/120761.htm).
 * > **NOTE:** Available in 1.92.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.oos.Template("example", {
 *     content: `  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `,
 *     templateName: "test-name",
 *     versionName: "test",
 *     tags: {
 *         Created: "TF",
 *         For: "acceptance Test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.oos.Template("example",
 *     content="""  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * """,
 *     template_name="test-name",
 *     version_name="test",
 *     tags={
 *         "Created": "TF",
 *         "For": "acceptance Test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Oos.Template("example", new()
 *     {
 *         Content = @"  {
 *     ""FormatVersion"": ""OOS-2019-06-01"",
 *     ""Description"": ""Update Describe instances of given status"",
 *     ""Parameters"":{
 *       ""Status"":{
 *         ""Type"": ""String"",
 *         ""Description"": ""(Required) The status of the Ecs instance.""
 *       }
 *     },
 *     ""Tasks"": [
 *       {
 *         ""Properties"" :{
 *           ""Parameters"":{
 *             ""Status"": ""{{ Status }}""
 *           },
 *           ""API"": ""DescribeInstances"",
 *           ""Service"": ""Ecs""
 *         },
 *         ""Name"": ""foo"",
 *         ""Action"": ""ACS::ExecuteApi""
 *       }]
 *   }
 * ",
 *         TemplateName = "test-name",
 *         VersionName = "test",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "acceptance Test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oos.NewTemplate(ctx, "example", &oos.TemplateArgs{
 * 			Content: pulumi.String(`  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `),
 * 			TemplateName: pulumi.String("test-name"),
 * 			VersionName:  pulumi.String("test"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("acceptance Test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oos.Template;
 * import com.pulumi.alicloud.oos.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .content("""
 *   {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 *             """)
 *             .templateName("test-name")
 *             .versionName("test")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "acceptance Test")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:oos:Template
 *     properties:
 *       content: |2
 *           {
 *             "FormatVersion": "OOS-2019-06-01",
 *             "Description": "Update Describe instances of given status",
 *             "Parameters":{
 *               "Status":{
 *                 "Type": "String",
 *                 "Description": "(Required) The status of the Ecs instance."
 *               }
 *             },
 *             "Tasks": [
 *               {
 *                 "Properties" :{
 *                   "Parameters":{
 *                     "Status": "{{ Status }}"
 *                   },
 *                   "API": "DescribeInstances",
 *                   "Service": "Ecs"
 *                 },
 *                 "Name": "foo",
 *                 "Action": "ACS::ExecuteApi"
 *               }]
 *           }
 *       templateName: test-name
 *       versionName: test
 *       tags:
 *         Created: TF
 *         For: acceptance Test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Template can be imported using the id or template_name, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/template:Template example template_name
 * ```
 */
public class Template internal constructor(
    override val javaResource: com.pulumi.alicloud.oos.Template,
) : KotlinCustomResource(javaResource, TemplateMapper) {
    /**
     * When deleting a template, whether to delete its related executions. Default to `false`.
     */
    public val autoDeleteExecutions: Output<Boolean>?
        get() = javaResource.autoDeleteExecutions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The content of the template. The template must be in the JSON or YAML format. Maximum size: 64 KB.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * The creator of the template.
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * The time when the template is created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The description of the template.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Is it triggered successfully.
     */
    public val hasTrigger: Output<Boolean>
        get() = javaResource.hasTrigger().applyValue({ args0 -> args0 })

    /**
     * The ID of resource group which the template belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The sharing type of the template. The sharing type of templates created by users are set to Private. The sharing type of common templates provided by OOS are set to Public.
     */
    public val shareType: Output<String>
        get() = javaResource.shareType().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The format of the template. The format can be JSON or YAML. The system automatically identifies the format.
     */
    public val templateFormat: Output<String>
        get() = javaResource.templateFormat().applyValue({ args0 -> args0 })

    /**
     * The id of OOS Template.
     */
    public val templateId: Output<String>
        get() = javaResource.templateId().applyValue({ args0 -> args0 })

    /**
     * The name of the template. The template name can be up to 200 characters in length. The name can contain letters, digits, hyphens (-), and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, or `ALICLOUD`.
     */
    public val templateName: Output<String>
        get() = javaResource.templateName().applyValue({ args0 -> args0 })

    /**
     * The type of OOS Template. `Automation` means the implementation of Alibaba Cloud API template, `Package` means represents a template for installing software.
     */
    public val templateType: Output<String>
        get() = javaResource.templateType().applyValue({ args0 -> args0 })

    /**
     * The version of OOS Template.
     */
    public val templateVersion: Output<String>
        get() = javaResource.templateVersion().applyValue({ args0 -> args0 })

    /**
     * The user who updated the template.
     */
    public val updatedBy: Output<String>
        get() = javaResource.updatedBy().applyValue({ args0 -> args0 })

    /**
     * The time when the template was updated.
     */
    public val updatedDate: Output<String>
        get() = javaResource.updatedDate().applyValue({ args0 -> args0 })

    /**
     * The name of template version.
     */
    public val versionName: Output<String>?
        get() = javaResource.versionName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TemplateMapper : ResourceMapper<Template> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oos.Template::class == javaResource::class

    override fun map(javaResource: Resource): Template = Template(
        javaResource as
            com.pulumi.alicloud.oos.Template,
    )
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Template].
 */
public suspend fun template(name: String, block: suspend TemplateResourceBuilder.() -> Unit): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 */
public fun template(name: String): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
