@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin

import com.pulumi.alicloud.oos.TemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a OOS Template resource. For information about Alicloud OOS Template and how to use it, see [What is Resource Alicloud OOS Template](https://www.alibabacloud.com/help/doc-detail/120761.htm).
 * > **NOTE:** Available in 1.92.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.oos.Template("example", {
 *     content: `  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `,
 *     templateName: "test-name",
 *     versionName: "test",
 *     tags: {
 *         Created: "TF",
 *         For: "acceptance Test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.oos.Template("example",
 *     content="""  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * """,
 *     template_name="test-name",
 *     version_name="test",
 *     tags={
 *         "Created": "TF",
 *         "For": "acceptance Test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Oos.Template("example", new()
 *     {
 *         Content = @"  {
 *     ""FormatVersion"": ""OOS-2019-06-01"",
 *     ""Description"": ""Update Describe instances of given status"",
 *     ""Parameters"":{
 *       ""Status"":{
 *         ""Type"": ""String"",
 *         ""Description"": ""(Required) The status of the Ecs instance.""
 *       }
 *     },
 *     ""Tasks"": [
 *       {
 *         ""Properties"" :{
 *           ""Parameters"":{
 *             ""Status"": ""{{ Status }}""
 *           },
 *           ""API"": ""DescribeInstances"",
 *           ""Service"": ""Ecs""
 *         },
 *         ""Name"": ""foo"",
 *         ""Action"": ""ACS::ExecuteApi""
 *       }]
 *   }
 * ",
 *         TemplateName = "test-name",
 *         VersionName = "test",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "acceptance Test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oos.NewTemplate(ctx, "example", &oos.TemplateArgs{
 * 			Content: pulumi.String(`  {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 * `),
 * 			TemplateName: pulumi.String("test-name"),
 * 			VersionName:  pulumi.String("test"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("acceptance Test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oos.Template;
 * import com.pulumi.alicloud.oos.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .content("""
 *   {
 *     "FormatVersion": "OOS-2019-06-01",
 *     "Description": "Update Describe instances of given status",
 *     "Parameters":{
 *       "Status":{
 *         "Type": "String",
 *         "Description": "(Required) The status of the Ecs instance."
 *       }
 *     },
 *     "Tasks": [
 *       {
 *         "Properties" :{
 *           "Parameters":{
 *             "Status": "{{ Status }}"
 *           },
 *           "API": "DescribeInstances",
 *           "Service": "Ecs"
 *         },
 *         "Name": "foo",
 *         "Action": "ACS::ExecuteApi"
 *       }]
 *   }
 *             """)
 *             .templateName("test-name")
 *             .versionName("test")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "acceptance Test")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:oos:Template
 *     properties:
 *       content: |2
 *           {
 *             "FormatVersion": "OOS-2019-06-01",
 *             "Description": "Update Describe instances of given status",
 *             "Parameters":{
 *               "Status":{
 *                 "Type": "String",
 *                 "Description": "(Required) The status of the Ecs instance."
 *               }
 *             },
 *             "Tasks": [
 *               {
 *                 "Properties" :{
 *                   "Parameters":{
 *                     "Status": "{{ Status }}"
 *                   },
 *                   "API": "DescribeInstances",
 *                   "Service": "Ecs"
 *                 },
 *                 "Name": "foo",
 *                 "Action": "ACS::ExecuteApi"
 *               }]
 *           }
 *       templateName: test-name
 *       versionName: test
 *       tags:
 *         Created: TF
 *         For: acceptance Test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OOS Template can be imported using the id or template_name, e.g.
 * ```sh
 * $ pulumi import alicloud:oos/template:Template example template_name
 * ```
 * @property autoDeleteExecutions When deleting a template, whether to delete its related executions. Default to `false`.
 * @property content The content of the template. The template must be in the JSON or YAML format. Maximum size: 64 KB.
 * @property resourceGroupId The ID of resource group which the template belongs.
 * @property tags A mapping of tags to assign to the resource.
 * @property templateName The name of the template. The template name can be up to 200 characters in length. The name can contain letters, digits, hyphens (-), and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, or `ALICLOUD`.
 * @property versionName The name of template version.
 */
public data class TemplateArgs(
    public val autoDeleteExecutions: Output<Boolean>? = null,
    public val content: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateName: Output<String>? = null,
    public val versionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.TemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.TemplateArgs =
        com.pulumi.alicloud.oos.TemplateArgs.builder()
            .autoDeleteExecutions(autoDeleteExecutions?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .versionName(versionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var autoDeleteExecutions: Output<Boolean>? = null

    private var content: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateName: Output<String>? = null

    private var versionName: Output<String>? = null

    /**
     * @param value When deleting a template, whether to delete its related executions. Default to `false`.
     */
    @JvmName("lgaevogtkkotjjuu")
    public suspend fun autoDeleteExecutions(`value`: Output<Boolean>) {
        this.autoDeleteExecutions = value
    }

    /**
     * @param value The content of the template. The template must be in the JSON or YAML format. Maximum size: 64 KB.
     */
    @JvmName("bnbqdtuayiowaqof")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The ID of resource group which the template belongs.
     */
    @JvmName("ojpkupamxsfafbqt")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("iygtnftifnmwfxae")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the template. The template name can be up to 200 characters in length. The name can contain letters, digits, hyphens (-), and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, or `ALICLOUD`.
     */
    @JvmName("ujqfjgcoujadifnm")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value The name of template version.
     */
    @JvmName("jqisoaykyxbuexdo")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value When deleting a template, whether to delete its related executions. Default to `false`.
     */
    @JvmName("vdoqmkpxhqmmxrcu")
    public suspend fun autoDeleteExecutions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteExecutions = mapped
    }

    /**
     * @param value The content of the template. The template must be in the JSON or YAML format. Maximum size: 64 KB.
     */
    @JvmName("lcbdpcvxnyrgmxlf")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The ID of resource group which the template belongs.
     */
    @JvmName("lvhhbojyqnknugou")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("eoglahclyqdoydei")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("xskmivwtyhjxmxpn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the template. The template name can be up to 200 characters in length. The name can contain letters, digits, hyphens (-), and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, or `ALICLOUD`.
     */
    @JvmName("nhfsdokmtfifkswf")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value The name of template version.
     */
    @JvmName("dekbfocurgrbhkfm")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        autoDeleteExecutions = autoDeleteExecutions,
        content = content,
        resourceGroupId = resourceGroupId,
        tags = tags,
        templateName = templateName,
        versionName = versionName,
    )
}
