@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.inputs

import com.pulumi.alicloud.oos.inputs.GetApplicationGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplicationGroups.
 * @property applicationName The name of the Application.
 * @property deployRegionId The region ID of the deployment.
 * @property ids A list of Application Group IDs. Its element value is same as Application Group Name.
 * @property nameRegex A regex string to filter results by Application Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetApplicationGroupsPlainArgs(
    public val applicationName: String,
    public val deployRegionId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.inputs.GetApplicationGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.inputs.GetApplicationGroupsPlainArgs =
        com.pulumi.alicloud.oos.inputs.GetApplicationGroupsPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .deployRegionId(deployRegionId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationGroupsPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var deployRegionId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of the Application.
     */
    @JvmName("pkqrivtqroovraub")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The region ID of the deployment.
     */
    @JvmName("ggiqhecuaxitsltb")
    public suspend fun deployRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deployRegionId = mapped
    }

    /**
     * @param value A list of Application Group IDs. Its element value is same as Application Group Name.
     */
    @JvmName("isuiqbxrqcjlgkrk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Application Group IDs. Its element value is same as Application Group Name.
     */
    @JvmName("wkaucuwjetyidrip")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Application Group name.
     */
    @JvmName("fyheshvpicerksau")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("iaomcdrcmbjyftyw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetApplicationGroupsPlainArgs = GetApplicationGroupsPlainArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        deployRegionId = deployRegionId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
