@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.inputs

import com.pulumi.alicloud.oos.inputs.GetExecutionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExecutions.
 * @property category The category of template. Valid: `AlarmTrigger`, `EventTrigger`, `Other` and `TimerTrigger`.
 * @property endDate The time when the execution was ended.
 * @property endDateAfter Execution whose end time is less than or equal to the specified time.
 * @property executedBy The user who execute the template.
 * @property ids A list of OOS Execution ids.
 * @property includeChildExecution Whether to include sub-execution.
 * @property mode The mode of OOS Execution. Valid: `Automatic`, `Debug`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property parentExecutionId The id of parent OOS Execution.
 * @property ramRole The role that executes the current template.
 * @property sortField The sort field.
 * @property sortOrder The sort order.
 * @property startDateAfter The execution whose start time is greater than or equal to the specified time.
 * @property startDateBefore The execution with start time less than or equal to the specified time.
 * @property status The Status of OOS Execution. Valid: `Cancelled`, `Failed`, `Queued`, `Running`, `Started`, `Success`, `Waiting`.
 * @property tags A mapping of tags to assign to the resource.
 * @property templateName The name of execution template.
 */
public data class GetExecutionsPlainArgs(
    public val category: String? = null,
    public val endDate: String? = null,
    public val endDateAfter: String? = null,
    public val executedBy: String? = null,
    public val ids: List<String>? = null,
    public val includeChildExecution: Boolean? = null,
    public val mode: String? = null,
    public val outputFile: String? = null,
    public val parentExecutionId: String? = null,
    public val ramRole: String? = null,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
    public val startDateAfter: String? = null,
    public val startDateBefore: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val templateName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.inputs.GetExecutionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.inputs.GetExecutionsPlainArgs =
        com.pulumi.alicloud.oos.inputs.GetExecutionsPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .endDate(endDate?.let({ args0 -> args0 }))
            .endDateAfter(endDateAfter?.let({ args0 -> args0 }))
            .executedBy(executedBy?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeChildExecution(includeChildExecution?.let({ args0 -> args0 }))
            .mode(mode?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .parentExecutionId(parentExecutionId?.let({ args0 -> args0 }))
            .ramRole(ramRole?.let({ args0 -> args0 }))
            .sortField(sortField?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 }))
            .startDateAfter(startDateAfter?.let({ args0 -> args0 }))
            .startDateBefore(startDateBefore?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateName(templateName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExecutionsPlainArgs].
 */
@PulumiTagMarker
public class GetExecutionsPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var endDate: String? = null

    private var endDateAfter: String? = null

    private var executedBy: String? = null

    private var ids: List<String>? = null

    private var includeChildExecution: Boolean? = null

    private var mode: String? = null

    private var outputFile: String? = null

    private var parentExecutionId: String? = null

    private var ramRole: String? = null

    private var sortField: String? = null

    private var sortOrder: String? = null

    private var startDateAfter: String? = null

    private var startDateBefore: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var templateName: String? = null

    /**
     * @param value The category of template. Valid: `AlarmTrigger`, `EventTrigger`, `Other` and `TimerTrigger`.
     */
    @JvmName("yymckfjnaesxdims")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value The time when the execution was ended.
     */
    @JvmName("wfddfdorywujleae")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endDate = mapped
    }

    /**
     * @param value Execution whose end time is less than or equal to the specified time.
     */
    @JvmName("pkusltckhimchpgd")
    public suspend fun endDateAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endDateAfter = mapped
    }

    /**
     * @param value The user who execute the template.
     */
    @JvmName("dkqflmnxxtmifvcp")
    public suspend fun executedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.executedBy = mapped
    }

    /**
     * @param value A list of OOS Execution ids.
     */
    @JvmName("vaakrdsvipaqacoo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of OOS Execution ids.
     */
    @JvmName("ggkkqutbiynueqgo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Whether to include sub-execution.
     */
    @JvmName("bdpblemygmcbfgiw")
    public suspend fun includeChildExecution(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeChildExecution = mapped
    }

    /**
     * @param value The mode of OOS Execution. Valid: `Automatic`, `Debug`.
     */
    @JvmName("dfqgxlklefghgept")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mode = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("unwdpkfttpffysnq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The id of parent OOS Execution.
     */
    @JvmName("hlpxupnxhglijqjd")
    public suspend fun parentExecutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parentExecutionId = mapped
    }

    /**
     * @param value The role that executes the current template.
     */
    @JvmName("fkcatcvupbetxblc")
    public suspend fun ramRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ramRole = mapped
    }

    /**
     * @param value The sort field.
     */
    @JvmName("buiirlmjwwjinnpv")
    public suspend fun sortField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortField = mapped
    }

    /**
     * @param value The sort order.
     */
    @JvmName("wmyditmvaujxhihh")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    /**
     * @param value The execution whose start time is greater than or equal to the specified time.
     */
    @JvmName("dyhmvlqipaaunnmp")
    public suspend fun startDateAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startDateAfter = mapped
    }

    /**
     * @param value The execution with start time less than or equal to the specified time.
     */
    @JvmName("dcwkrodmkgvwffeq")
    public suspend fun startDateBefore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startDateBefore = mapped
    }

    /**
     * @param value The Status of OOS Execution. Valid: `Cancelled`, `Failed`, `Queued`, `Running`, `Started`, `Success`, `Waiting`.
     */
    @JvmName("osgfabpmajfghvhn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("seppxxragvuqqgww")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("jajcvoyrkxohdsrh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The name of execution template.
     */
    @JvmName("jxjoxvbwjibidfrk")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templateName = mapped
    }

    internal fun build(): GetExecutionsPlainArgs = GetExecutionsPlainArgs(
        category = category,
        endDate = endDate,
        endDateAfter = endDateAfter,
        executedBy = executedBy,
        ids = ids,
        includeChildExecution = includeChildExecution,
        mode = mode,
        outputFile = outputFile,
        parentExecutionId = parentExecutionId,
        ramRole = ramRole,
        sortField = sortField,
        sortOrder = sortOrder,
        startDateAfter = startDateAfter,
        startDateBefore = startDateBefore,
        status = status,
        tags = tags,
        templateName = templateName,
    )
}
