@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.inputs

import com.pulumi.alicloud.oos.inputs.GetParametersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getParameters.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Parameter IDs. Its element value is same as Parameter Name.
 * @property nameRegex A regex string to filter results by Parameter name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property parameterName The name of the common parameter. You can enter a keyword to query parameter names in fuzzy match mode.
 * @property resourceGroupId The ID of the Resource Group.
 * @property sortField
 * @property sortOrder
 * @property tags A mapping of tags to assign to the resource.
 * @property type The data type of the common parameter. Valid values: `String` and `StringList`.
 */
public data class GetParametersPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val parameterName: String? = null,
    public val resourceGroupId: String? = null,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.inputs.GetParametersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.inputs.GetParametersPlainArgs =
        com.pulumi.alicloud.oos.inputs.GetParametersPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .parameterName(parameterName?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .sortField(sortField?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetParametersPlainArgs].
 */
@PulumiTagMarker
public class GetParametersPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var parameterName: String? = null

    private var resourceGroupId: String? = null

    private var sortField: String? = null

    private var sortOrder: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("rllbrwrduufjqcap")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Parameter IDs. Its element value is same as Parameter Name.
     */
    @JvmName("kmsewqbohkwdlgpd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Parameter IDs. Its element value is same as Parameter Name.
     */
    @JvmName("frqlottbrmxabkpd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Parameter name.
     */
    @JvmName("tnmcgtrfhucygxsi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gmykbkydwhtoxirs")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the common parameter. You can enter a keyword to query parameter names in fuzzy match mode.
     */
    @JvmName("xxsdjojoofgcghop")
    public suspend fun parameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameterName = mapped
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("cereckybxavtnvlf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("jwojwgdfamhsajpo")
    public suspend fun sortField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortField = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktrbqkwlscovequq")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ergfqhlbeivihlgi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("kapniqebpjylwdsk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The data type of the common parameter. Valid values: `String` and `StringList`.
     */
    @JvmName("owphmfilyufjhwnd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetParametersPlainArgs = GetParametersPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        parameterName = parameterName,
        resourceGroupId = resourceGroupId,
        sortField = sortField,
        sortOrder = sortOrder,
        tags = tags,
        type = type,
    )
}
